package gov.grants.apply.applicant.v2;

import java.util.List;
import java.util.Set;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;

import gov.grants.apply.services.applicantwebservices_v2.ApplicantWebServicesPortType;
import gov.grants.apply.services.applicantwebservices_v2.GetApplicationListAsThirdPartyRequest;
import gov.grants.apply.services.applicantwebservices_v2.GetApplicationListAsThirdPartyResponse;
import gov.grants.apply.services.applicantwebservices_v2.GetSubmissionListRequest;
import gov.grants.apply.services.applicantwebservices_v2.GetSubmissionListResponse;
import gov.grants.apply.services.applicantwebservices_v2.GetApplicationListAsThirdPartyResponse.ApplicationInfo;
import gov.grants.apply.services.applicantwebservices_v2.GetSubmissionListAsThirdPartyRequest;
import gov.grants.apply.services.applicantwebservices_v2.GetSubmissionListAsThirdPartyResponse;
import gov.grants.apply.system.applicantcommonelements_v1.SubmissionDetails;
import gov.grants.apply.system.applicantcommonelements_v1.SubmissionFilter;
import gov.grants.apply.system.applicantcommonelements_v1.SubmissionFilterType;
import gov.grants.apply.system.grantscommonelements_v1.ApplicationFilter;

public class GetSubmissionListAsThirdPartyClient extends BaseApplicantClient {
	
	private static final String CLASSNAME = GetSubmissionListAsThirdPartyClient.class.getSimpleName();
	private static final Logger log = Logger.getLogger( CLASSNAME );
	
	
	/**
	 * @param args
	 */
	public static void main( String[] args ) {
		log.debug( "Begin " + CLASSNAME );
		
		try {
			GetSubmissionListAsThirdPartyClient client = new GetSubmissionListAsThirdPartyClient();
			
			log.debug( "args length: " + args.length );
			client.init( args );
			
			client.makeServiceCall();
			log.debug( "\n\nSUCCESS: " + CLASSNAME + " successfully completed" );

		} catch ( Exception e ) {
			log.error( "\n\nException: " + e.getMessage() );
		}// try-catch
		
	}// main
	
	public void makeServiceCall() throws Exception {
		try {
			ApplicantWebServicesPortType port = getApplicantPort();
			GetSubmissionListAsThirdPartyRequest request = new GetSubmissionListAsThirdPartyRequest();
			List<SubmissionFilter> filters = request.getSubmissionFilter();
			SubmissionFilter filter = null;
			
			Set<String> argKeys = getArgMap().keySet();
			String filterType = null;
			String filterValue = null;
			
			for ( String key : argKeys ) {
				log.debug( "key: " + key );
				filterType = FILTER_NAMES.get( key.toLowerCase() );
				log.debug( "filter name: " + filterType );
				if ( StringUtils.isNotBlank( filterType ) ) {
					filterValue = getArgMap().get( key );
					
					if ( StringUtils.isNotBlank( filterValue ) ) {
						log.debug( "create filter[" + filterType + "]: " + filterValue );
						filter = new SubmissionFilter();
						filter.setType( SubmissionFilterType.fromValue( filterType));
						filter.setValue( filterValue );
						filters.add( filter );
					} else {
						log.error( "no value for filter name: " + filterType );
					}// if-else

				}// if
			}// for
			
			// verify filters before making service call
			log.debug( "filter count: " + request.getSubmissionFilter().size() );
			for ( SubmissionFilter submissionFilter : request.getSubmissionFilter() ) {
				log.debug( "\n-filter: " + ToStringBuilder.reflectionToString( submissionFilter ) );
			}// for
			
			GetSubmissionListAsThirdPartyResponse response = port.getSubmissionListAsThirdParty( request);
			log.debug( "available submission count: " + response.getAvailableApplicationNumber() );
			List <SubmissionDetails> list = response.getSubmissionDetails();
			
			printList( list );
			printListConcise( list );
			
			log.debug( "Total Available submission Count: " + response.getAvailableApplicationNumber());
			
		} catch ( Exception e ) {
			log.error( "Exception: " + e.getMessage() );
			e.printStackTrace();
			throw e;
		}// try-catch
		
	}// makeServiceCall
	
	public void printList( List<SubmissionDetails> list ) {
		if ( list == null || list.size() == 0 ) {
			log.debug( "Submission list is empty." );
				return;
		}// if
	         
		log.debug( "Received " + list.size() + " submissions in list" );
		for ( SubmissionDetails details : list ) {
			log.debug( "\n\n" );
			log.debug( ToStringBuilder.reflectionToString( details ) );
			log.debug( "\n\n" );
		}// for-each
	}// printList
	
	
	
	public void printListConcise( List<SubmissionDetails> list ) {
		if ( list == null || list.size() == 0 ) {
			log.debug( "Submission list is empty." );
				return;
		}// if
	         
		log.debug( "Received " + list.size() + " submissions in list" );
		StringBuilder sb = new StringBuilder().append( "\n" );
		int count = 0;
		for ( SubmissionDetails details : list ) {
			log.debug( "details: " + ToStringBuilder.reflectionToString( details ) );
			count++;
			sb.append( "Submission list element " )
				.append( count )
				.append( ": " )
				.append( details.getGrantsGovTrackingNumber() )
				.append( "--- PackageID: " )
				.append( details.getPackageID() )
				.append( "--- Status: " )
				.append( details.getGrantsGovApplicationStatus() )
				.append( "\n" );
		}// for-each
			
		log.debug( sb.toString() );
	}// printListConcise
	
}

