/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware.xpath;

import com.ximpleware.Expr;
import com.ximpleware.VTDNav;
import com.ximpleware.XPathEvalException;

public class UnaryExpr
extends Expr {
    public int op;
    public Expr operand;

    public UnaryExpr(int n, Expr expr) {
        this.op = n;
        this.operand = expr;
    }

    public String toString() {
        return "-" + this.operand;
    }

    public boolean evalBoolean(VTDNav vTDNav) {
        return this.operand.evalBoolean(vTDNav);
    }

    public double evalNumber(VTDNav vTDNav) {
        return -1.0 * this.operand.evalNumber(vTDNav);
    }

    public int evalNodeSet(VTDNav vTDNav) throws XPathEvalException {
        throw new XPathEvalException("UnaryExpr can't eval to a node set!");
    }

    public String evalString(VTDNav vTDNav) {
        double d = this.operand.evalNumber(vTDNav);
        if (d == (double)((int)d)) {
            return "" + (int)d;
        }
        return "" + d;
    }

    public void reset(VTDNav vTDNav) {
        this.operand.reset(vTDNav);
    }

    public boolean isNodeSet() {
        return false;
    }

    public boolean isNumerical() {
        return true;
    }

    public boolean isString() {
        return false;
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean requireContextSize() {
        return this.operand.requireContextSize();
    }

    public void setContextSize(int n) {
        this.operand.setContextSize(n);
    }

    public void setPosition(int n) {
        this.operand.setPosition(n);
    }

    public int adjust(int n) {
        return 0;
    }
}

