/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware.xpath;

import com.ximpleware.Expr;
import com.ximpleware.VTDNav;
import com.ximpleware.XPathEvalException;

public class NumExpr
extends Expr {
    public double dval;

    public NumExpr(double d) {
        this.dval = d;
    }

    public String toString() {
        if (this.dval == (double)((long)this.dval)) {
            return "" + (long)this.dval;
        }
        return "" + this.dval;
    }

    public double eval() {
        return this.dval;
    }

    public boolean isNodeSet() {
        return false;
    }

    public boolean isNumerical() {
        return true;
    }

    public boolean evalBoolean(VTDNav vTDNav) {
        return this.dval != 0.0 && !Double.isNaN(this.dval);
    }

    public double evalNumber(VTDNav vTDNav) {
        return this.dval;
    }

    public int evalNodeSet(VTDNav vTDNav) throws XPathEvalException {
        throw new XPathEvalException("NumExpr can't eval to a node set!");
    }

    public String evalString(VTDNav vTDNav) {
        if (this.dval == (double)((int)this.dval)) {
            return "" + (int)this.dval;
        }
        return "" + this.dval;
    }

    public void reset(VTDNav vTDNav) {
    }

    public boolean isString() {
        return false;
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean requireContextSize() {
        return false;
    }

    public void setContextSize(int n) {
    }

    public void setPosition(int n) {
    }

    public int adjust(int n) {
        return 0;
    }
}

