/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware.xpath;

import com.ximpleware.Expr;
import com.ximpleware.VTDNav;
import com.ximpleware.XPathEvalException;

public class LiteralExpr
extends Expr {
    public String s;

    public LiteralExpr(String string) {
        this.s = string;
    }

    public String toString() {
        boolean bl = true;
        for (int i = 0; i < this.s.length(); ++i) {
            if (this.s.charAt(i) != '\'') continue;
            bl = false;
            break;
        }
        if (bl) {
            return "\"" + this.s + "\"";
        }
        return "'" + this.s + "'";
    }

    public boolean evalBoolean(VTDNav vTDNav) {
        return this.s.length() != 0;
    }

    public double evalNumber(VTDNav vTDNav) {
        try {
            double d = Double.parseDouble(this.s);
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            return Double.NaN;
        }
    }

    public int evalNodeSet(VTDNav vTDNav) throws XPathEvalException {
        throw new XPathEvalException("LiteralExpr can't eval to a node set!");
    }

    public String evalString(VTDNav vTDNav) {
        return this.s;
    }

    public void reset(VTDNav vTDNav) {
    }

    public boolean isNodeSet() {
        return false;
    }

    public boolean isNumerical() {
        return false;
    }

    public boolean isString() {
        return true;
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean requireContextSize() {
        return false;
    }

    public void setContextSize(int n) {
    }

    public void setPosition(int n) {
    }

    public int adjust(int n) {
        return 0;
    }
}

