/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware.extended.xpath;

import com.ximpleware.extended.VTDNavHuge;
import com.ximpleware.extended.XPathEvalExceptionHuge;
import com.ximpleware.extended.xpath.Expr;

public class UnaryExpr
extends Expr {
    public int op;
    public Expr operand;

    public UnaryExpr(int n, Expr expr) {
        this.op = n;
        this.operand = expr;
    }

    public String toString() {
        return "-" + this.operand;
    }

    public boolean evalBoolean(VTDNavHuge vTDNavHuge) {
        return this.operand.evalBoolean(vTDNavHuge);
    }

    public double evalNumber(VTDNavHuge vTDNavHuge) {
        return -1.0 * this.operand.evalNumber(vTDNavHuge);
    }

    public int evalNodeSet(VTDNavHuge vTDNavHuge) throws XPathEvalExceptionHuge {
        throw new XPathEvalExceptionHuge("UnaryExpr can't eval to a node set!");
    }

    public String evalString(VTDNavHuge vTDNavHuge) {
        double d = this.operand.evalNumber(vTDNavHuge);
        if (d == (double)((int)d)) {
            return "" + (int)d;
        }
        return "" + d;
    }

    public void reset(VTDNavHuge vTDNavHuge) {
        this.operand.reset(vTDNavHuge);
    }

    public boolean isNodeSet() {
        return false;
    }

    public boolean isNumerical() {
        return true;
    }

    public boolean isString() {
        return false;
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean requireContextSize() {
        return this.operand.requireContextSize();
    }

    public void setContextSize(int n) {
        this.operand.setContextSize(n);
    }

    public void setPosition(int n) {
        this.operand.setPosition(n);
    }

    public int adjust(int n) {
        return 0;
    }
}

