/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware.extended.xpath;

import com.ximpleware.extended.VTDNavHuge;
import com.ximpleware.extended.XPathEvalExceptionHuge;
import com.ximpleware.extended.xpath.Expr;

public class NumExpr
extends Expr {
    public double dval;

    public NumExpr(double d) {
        this.dval = d;
    }

    public String toString() {
        if (this.dval == (double)((long)this.dval)) {
            return "" + (long)this.dval;
        }
        return "" + this.dval;
    }

    public double eval() {
        return this.dval;
    }

    public boolean isNodeSet() {
        return false;
    }

    public boolean isNumerical() {
        return true;
    }

    public boolean evalBoolean(VTDNavHuge vTDNavHuge) {
        return this.dval != 0.0 && !Double.isNaN(this.dval);
    }

    public double evalNumber(VTDNavHuge vTDNavHuge) {
        return this.dval;
    }

    public int evalNodeSet(VTDNavHuge vTDNavHuge) throws XPathEvalExceptionHuge {
        throw new XPathEvalExceptionHuge("NumExpr can't eval to a node set!");
    }

    public String evalString(VTDNavHuge vTDNavHuge) {
        if (this.dval == (double)((int)this.dval)) {
            return "" + (int)this.dval;
        }
        return "" + this.dval;
    }

    public void reset(VTDNavHuge vTDNavHuge) {
    }

    public boolean isString() {
        return false;
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean requireContextSize() {
        return false;
    }

    public void setContextSize(int n) {
    }

    public void setPosition(int n) {
    }

    public int adjust(int n) {
        return 0;
    }
}

