/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware.extended.xpath;

import com.ximpleware.extended.VTDNavHuge;
import com.ximpleware.extended.XPathEvalExceptionHuge;
import com.ximpleware.extended.xpath.Expr;

public class LiteralExpr
extends Expr {
    public String s;

    public LiteralExpr(String string) {
        this.s = string;
    }

    public String toString() {
        boolean bl = true;
        for (int i = 0; i < this.s.length(); ++i) {
            if (this.s.charAt(i) != '\'') continue;
            bl = false;
            break;
        }
        if (bl) {
            return "\"" + this.s + "\"";
        }
        return "'" + this.s + "'";
    }

    public boolean evalBoolean(VTDNavHuge vTDNavHuge) {
        return this.s.length() != 0;
    }

    public double evalNumber(VTDNavHuge vTDNavHuge) {
        try {
            double d = Double.parseDouble(this.s);
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            return Double.NaN;
        }
    }

    public int evalNodeSet(VTDNavHuge vTDNavHuge) throws XPathEvalExceptionHuge {
        throw new XPathEvalExceptionHuge("LiteralExpr can't eval to a node set!");
    }

    public String evalString(VTDNavHuge vTDNavHuge) {
        return this.s;
    }

    public void reset(VTDNavHuge vTDNavHuge) {
    }

    public boolean isNodeSet() {
        return false;
    }

    public boolean isNumerical() {
        return false;
    }

    public boolean isString() {
        return true;
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean requireContextSize() {
        return false;
    }

    public void setContextSize(int n) {
    }

    public void setPosition(int n) {
    }

    public int adjust(int n) {
        return 0;
    }
}

