/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware.extended;

import com.ximpleware.extended.FastIntBuffer;
import com.ximpleware.extended.NavExceptionHuge;
import com.ximpleware.extended.VTDNavHuge;
import com.ximpleware.extended.XPathEvalExceptionHuge;
import com.ximpleware.extended.xpath.Expr;

public class BinaryExpr
extends Expr {
    public static final int ADD = 0;
    public static final int SUB = 1;
    public static final int MULT = 2;
    public static final int DIV = 3;
    public static final int MOD = 4;
    public static final int OR = 5;
    public static final int AND = 6;
    public static final int EQ = 7;
    public static final int NE = 8;
    public static final int LE = 9;
    public static final int GE = 10;
    public static final int LT = 11;
    public static final int GT = 12;
    public static final int BUF_SZ_EXP = 7;
    protected int op;
    boolean isNumerical;
    boolean isBoolean;
    protected Expr left;
    protected Expr right;
    protected FastIntBuffer fib1;

    public BinaryExpr(Expr expr, int n, Expr expr2) {
        this.op = n;
        this.left = expr;
        this.right = expr2;
        this.fib1 = null;
        switch (this.op) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.isNumerical = true;
                this.isBoolean = false;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                this.isNumerical = false;
                this.isBoolean = true;
            }
        }
    }

    public String toString() {
        String string;
        switch (this.op) {
            case 0: {
                string = " + ";
                break;
            }
            case 1: {
                string = " - ";
                break;
            }
            case 2: {
                string = " * ";
                break;
            }
            case 3: {
                string = " / ";
                break;
            }
            case 4: {
                string = " mod ";
                break;
            }
            case 5: {
                string = " or ";
                break;
            }
            case 6: {
                string = " and ";
                break;
            }
            case 7: {
                string = " = ";
                break;
            }
            case 8: {
                string = " != ";
                break;
            }
            case 9: {
                string = " <= ";
                break;
            }
            case 10: {
                string = " >= ";
                break;
            }
            case 11: {
                string = " < ";
                break;
            }
            default: {
                string = " > ";
            }
        }
        return "(" + this.left + string + this.right + ")";
    }

    public boolean evalBoolean(VTDNavHuge vTDNavHuge) {
        switch (this.op) {
            case 5: {
                return this.left.evalBoolean(vTDNavHuge) || this.right.evalBoolean(vTDNavHuge);
            }
            case 6: {
                return this.left.evalBoolean(vTDNavHuge) && this.right.evalBoolean(vTDNavHuge);
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return this.computeComp(this.op, vTDNavHuge);
            }
        }
        double d = this.evalNumber(vTDNavHuge);
        return d != -0.0 && d != 0.0 && !Double.isNaN(d);
    }

    public double evalNumber(VTDNavHuge vTDNavHuge) {
        switch (this.op) {
            case 0: {
                return this.left.evalNumber(vTDNavHuge) + this.right.evalNumber(vTDNavHuge);
            }
            case 1: {
                return this.left.evalNumber(vTDNavHuge) - this.right.evalNumber(vTDNavHuge);
            }
            case 2: {
                return this.left.evalNumber(vTDNavHuge) * this.right.evalNumber(vTDNavHuge);
            }
            case 3: {
                return this.left.evalNumber(vTDNavHuge) / this.right.evalNumber(vTDNavHuge);
            }
            case 4: {
                return this.left.evalNumber(vTDNavHuge) % this.right.evalNumber(vTDNavHuge);
            }
        }
        if (this.evalBoolean(vTDNavHuge)) {
            return 1.0;
        }
        return 0.0;
    }

    public int evalNodeSet(VTDNavHuge vTDNavHuge) throws XPathEvalExceptionHuge {
        throw new XPathEvalExceptionHuge("BinaryExpr can't eval to a node set!");
    }

    public String evalString(VTDNavHuge vTDNavHuge) {
        if (this.isNumerical()) {
            double d = this.evalNumber(vTDNavHuge);
            if (d == (double)((long)d)) {
                return "" + (long)d;
            }
            return "" + d;
        }
        boolean bl = this.evalBoolean(vTDNavHuge);
        if (bl) {
            return "true";
        }
        return "false";
    }

    public void reset(VTDNavHuge vTDNavHuge) {
        this.left.reset(vTDNavHuge);
        this.right.reset(vTDNavHuge);
    }

    public boolean isNodeSet() {
        return false;
    }

    public boolean isNumerical() {
        return this.isNumerical;
    }

    public boolean isString() {
        return false;
    }

    public boolean isBoolean() {
        return this.isBoolean;
    }

    private boolean computeComp(int n, VTDNavHuge vTDNavHuge) {
        if (this.left.isNodeSet() && this.right.isNodeSet()) {
            return this.compNodeSetNodeSet(this.left, this.right, vTDNavHuge, n);
        }
        if (this.left.isNumerical() && this.right.isNodeSet()) {
            return this.compNumericalNodeSet(this.left, this.right, vTDNavHuge, n);
        }
        if (this.left.isNodeSet() && this.right.isNumerical()) {
            return this.compNodeSetNumerical(this.left, this.right, vTDNavHuge, n);
        }
        if (this.left.isString() && this.right.isNodeSet()) {
            return this.compStringNodeSet(this.left, this.right, vTDNavHuge, n);
        }
        if (this.left.isNodeSet() && this.right.isString()) {
            return this.compNodeSetString(this.left, this.right, vTDNavHuge, n);
        }
        if (n == 7 || n == 8) {
            if (this.left.isBoolean() || this.right.isBoolean()) {
                if (n == 7) {
                    return this.left.evalBoolean(vTDNavHuge) == this.right.evalBoolean(vTDNavHuge);
                }
                return this.left.evalBoolean(vTDNavHuge) != this.right.evalBoolean(vTDNavHuge);
            }
            if (this.left.isNumerical() || this.right.isNumerical()) {
                if (n == 7) {
                    return this.left.evalNumber(vTDNavHuge) == this.right.evalNumber(vTDNavHuge);
                }
                return this.left.evalNumber(vTDNavHuge) != this.right.evalNumber(vTDNavHuge);
            }
            String string = this.left.evalString(vTDNavHuge);
            String string2 = this.right.evalString(vTDNavHuge);
            return n == 7 ? string.equals(string2) : !string.equals(string2);
        }
        return this.compNumbers(this.left.evalNumber(vTDNavHuge), this.right.evalNumber(vTDNavHuge), n);
    }

    public boolean requireContextSize() {
        return this.left.requireContextSize() || this.right.requireContextSize();
    }

    public void setContextSize(int n) {
        this.left.setContextSize(n);
        this.right.setContextSize(n);
    }

    public void setPosition(int n) {
        this.left.setPosition(n);
        this.right.setPosition(n);
    }

    private boolean compNodeSetString(Expr expr, Expr expr2, VTDNavHuge vTDNavHuge, int n) {
        int n2 = 0;
        try {
            int n3;
            String string = expr2.evalString(vTDNavHuge);
            vTDNavHuge.push2();
            int n4 = vTDNavHuge.contextStack2.size;
            while ((n3 = expr.evalNodeSet(vTDNavHuge)) != -1) {
                boolean bl;
                n2 = this.getStringVal(vTDNavHuge, n3);
                if (n2 == -1 || !(bl = this.compareVString1(n2, vTDNavHuge, string, n))) continue;
                expr.reset(vTDNavHuge);
                vTDNavHuge.contextStack2.size = n4;
                vTDNavHuge.pop2();
                return bl;
            }
            vTDNavHuge.contextStack2.size = n4;
            vTDNavHuge.pop2();
            expr.reset(vTDNavHuge);
            return false;
        }
        catch (Exception exception) {
            throw new RuntimeException("Undefined behavior");
        }
    }

    private boolean compareEmptyNodeSet(int n, String string) {
        if (n == 8) {
            return string.length() != 0;
        }
        return string.length() == 0;
    }

    private boolean compStringNodeSet(Expr expr, Expr expr2, VTDNavHuge vTDNavHuge, int n) {
        int n2 = 0;
        try {
            int n3;
            String string = expr.evalString(vTDNavHuge);
            vTDNavHuge.push2();
            int n4 = vTDNavHuge.contextStack2.size;
            while ((n3 = expr2.evalNodeSet(vTDNavHuge)) != -1) {
                boolean bl;
                n2 = this.getStringVal(vTDNavHuge, n3);
                if (n2 == -1 || !(bl = this.compareVString2(n2, vTDNavHuge, string, n))) continue;
                expr2.reset(vTDNavHuge);
                vTDNavHuge.contextStack2.size = n4;
                vTDNavHuge.pop2();
                return bl;
            }
            vTDNavHuge.contextStack2.size = n4;
            vTDNavHuge.pop2();
            expr2.reset(vTDNavHuge);
            return false;
        }
        catch (Exception exception) {
            throw new RuntimeException("Undefined behavior");
        }
    }

    private boolean compNumbers(double d, double d2, int n) {
        switch (n) {
            case 9: {
                return d <= d2;
            }
            case 10: {
                return d >= d2;
            }
            case 11: {
                return d < d2;
            }
            case 12: {
                return d > d2;
            }
        }
        return false;
    }

    private boolean compNumericalNodeSet(Expr expr, Expr expr2, VTDNavHuge vTDNavHuge, int n) {
        int n2 = 0;
        try {
            int n3;
            double d = expr.evalNumber(vTDNavHuge);
            vTDNavHuge.push2();
            int n4 = vTDNavHuge.contextStack2.size;
            while ((n3 = expr2.evalNodeSet(vTDNavHuge)) != -1) {
                n2 = this.getStringVal(vTDNavHuge, n3);
                if (n2 == -1 || !this.compareVNumber1(n2, vTDNavHuge, d, n)) continue;
                expr2.reset(vTDNavHuge);
                vTDNavHuge.contextStack2.size = n4;
                vTDNavHuge.pop2();
                return true;
            }
            vTDNavHuge.contextStack2.size = n4;
            vTDNavHuge.pop2();
            expr2.reset(vTDNavHuge);
            return false;
        }
        catch (Exception exception) {
            throw new RuntimeException("Undefined behavior");
        }
    }

    private boolean compNodeSetNumerical(Expr expr, Expr expr2, VTDNavHuge vTDNavHuge, int n) {
        int n2 = 0;
        try {
            int n3;
            double d = expr2.evalNumber(vTDNavHuge);
            vTDNavHuge.push2();
            int n4 = vTDNavHuge.contextStack2.size;
            while ((n3 = expr.evalNodeSet(vTDNavHuge)) != -1) {
                n2 = this.getStringVal(vTDNavHuge, n3);
                if (n2 == -1 || !this.compareVNumber2(n2, vTDNavHuge, d, n)) continue;
                expr.reset(vTDNavHuge);
                vTDNavHuge.contextStack2.size = n4;
                vTDNavHuge.pop2();
                return true;
            }
            vTDNavHuge.contextStack2.size = n4;
            vTDNavHuge.pop2();
            expr.reset(vTDNavHuge);
            return false;
        }
        catch (Exception exception) {
            throw new RuntimeException("Undefined behavior");
        }
    }

    private int getStringVal(VTDNavHuge vTDNavHuge, int n) {
        int n2 = vTDNavHuge.getTokenType(n);
        if (n2 == 0) {
            int n3 = vTDNavHuge.getText();
            return n3;
        }
        if (n2 == 2 || n2 == 3) {
            return n + 1;
        }
        return n;
    }

    private boolean compareVNumber1(int n, VTDNavHuge vTDNavHuge, double d, int n2) throws NavExceptionHuge {
        double d2 = vTDNavHuge.parseDouble(n);
        switch (n2) {
            case 7: {
                return d == d2;
            }
            case 8: {
                return d != d2;
            }
            case 10: {
                return d >= d2;
            }
            case 9: {
                return d <= d2;
            }
            case 12: {
                return d > d2;
            }
        }
        return d < d2;
    }

    private boolean compareVString1(int n, VTDNavHuge vTDNavHuge, String string, int n2) throws NavExceptionHuge {
        int n3 = vTDNavHuge.compareTokenString(n, string);
        switch (n3) {
            case -1: {
                if (n2 != 8 && n2 != 11 && n2 != 9) break;
                return true;
            }
            case 0: {
                if (n2 != 7 && n2 != 9 && n2 != 10) break;
                return true;
            }
            case 1: {
                if (n2 != 8 && n2 != 10 && n2 != 12) break;
                return true;
            }
        }
        return false;
    }

    private boolean compareVString2(int n, VTDNavHuge vTDNavHuge, String string, int n2) throws NavExceptionHuge {
        int n3 = vTDNavHuge.compareTokenString(n, string);
        switch (n3) {
            case -1: {
                if (n2 != 8 && n2 != 12 && n2 != 10) break;
                return true;
            }
            case 0: {
                if (n2 != 7 && n2 != 9 && n2 != 10) break;
                return true;
            }
            case 1: {
                if (n2 != 8 && n2 != 9 && n2 != 11) break;
                return true;
            }
        }
        return false;
    }

    private boolean compareVNumber2(int n, VTDNavHuge vTDNavHuge, double d, int n2) throws NavExceptionHuge {
        double d2 = vTDNavHuge.parseDouble(n);
        switch (n2) {
            case 7: {
                return d2 == d;
            }
            case 8: {
                return d2 != d;
            }
            case 10: {
                return d2 >= d;
            }
            case 9: {
                return d2 <= d;
            }
            case 12: {
                return d2 > d;
            }
        }
        return d2 < d;
    }

    private boolean compareVV(int n, VTDNavHuge vTDNavHuge, int n2, int n3) throws NavExceptionHuge {
        int n4 = vTDNavHuge.compareTokens(n, vTDNavHuge, n2);
        switch (n4) {
            case 1: {
                if (n3 != 8 && n3 != 10 && n3 != 12) break;
                return true;
            }
            case 0: {
                if (n3 != 7 && n3 != 9 && n3 != 10) break;
                return true;
            }
            case -1: {
                if (n3 != 8 && n3 != 11 && n3 != 9) break;
                return true;
            }
        }
        return false;
    }

    private boolean compNodeSetNodeSet(Expr expr, Expr expr2, VTDNavHuge vTDNavHuge, int n) {
        try {
            int n2;
            int n3;
            if (this.fib1 == null) {
                this.fib1 = new FastIntBuffer(7);
            }
            vTDNavHuge.push2();
            int n4 = vTDNavHuge.contextStack2.size;
            while ((n3 = expr.evalNodeSet(vTDNavHuge)) != -1) {
                n2 = this.getStringVal(vTDNavHuge, n3);
                if (n2 == -1) continue;
                this.fib1.append(n2);
            }
            expr.reset(vTDNavHuge);
            vTDNavHuge.contextStack2.size = n4;
            vTDNavHuge.pop2();
            vTDNavHuge.push2();
            n4 = vTDNavHuge.contextStack2.size;
            while ((n3 = expr2.evalNodeSet(vTDNavHuge)) != -1) {
                n2 = this.getStringVal(vTDNavHuge, n3);
                if (n2 == -1) continue;
                int n5 = this.fib1.size();
                for (int i = 0; i < n5; ++i) {
                    boolean bl = this.compareVV(this.fib1.intAt(i), vTDNavHuge, n2, n);
                    if (!bl) continue;
                    this.fib1.clear();
                    vTDNavHuge.contextStack2.size = n4;
                    vTDNavHuge.pop2();
                    expr2.reset(vTDNavHuge);
                    return true;
                }
            }
            vTDNavHuge.contextStack2.size = n4;
            vTDNavHuge.pop2();
            expr2.reset(vTDNavHuge);
            this.fib1.clear();
            return false;
        }
        catch (Exception exception) {
            this.fib1.clear();
            throw new RuntimeException("Undefined behavior");
        }
    }

    public int adjust(int n) {
        int n2;
        int n3 = this.left.adjust(n);
        if (n3 > (n2 = this.right.adjust(n))) {
            return n3;
        }
        return n2;
    }
}

