/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware;

import com.ximpleware.IObjectBuffer;
import com.ximpleware.arrayList;

public class FastObjectBuffer
implements IObjectBuffer {
    private arrayList bufferArrayList;
    private int capacity;
    private int pageSize;
    protected int size;
    private int exp;
    private int r;

    public FastObjectBuffer() {
        this.size = 0;
        this.capacity = 0;
        this.pageSize = 1024;
        this.exp = 10;
        this.r = 1023;
        this.bufferArrayList = new arrayList();
    }

    public FastObjectBuffer(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.size = 0;
        this.capacity = 0;
        this.pageSize = 1 << n;
        this.exp = n;
        this.r = this.pageSize - 1;
        this.bufferArrayList = new arrayList();
    }

    public void append(Object[] objectArray) {
        int n;
        Object[] objectArray2;
        if (objectArray == null) {
            throw new NullPointerException();
        }
        if (this.bufferArrayList.size == 0) {
            objectArray2 = new Object[this.pageSize];
            this.bufferArrayList.add(objectArray2);
            n = 0;
            this.capacity = this.pageSize;
        } else {
            n = Math.min(this.size >> this.exp, this.bufferArrayList.size - 1);
            objectArray2 = (Object[])this.bufferArrayList.get(n);
        }
        if (this.size + objectArray.length < this.capacity) {
            if (this.size + objectArray.length < n + 1 << this.exp) {
                System.arraycopy(objectArray, 0, objectArray2, this.size & this.r, objectArray.length);
            } else {
                int n2;
                int n3 = this.pageSize - (this.size & this.r);
                System.arraycopy(objectArray, 0, objectArray2, this.size & this.r, n3);
                int n4 = objectArray.length - n3;
                int n5 = n4 >> this.exp;
                for (n2 = 1; n2 <= n5; ++n2) {
                    System.arraycopy(objectArray, n3, (Object[])this.bufferArrayList.get(n + n2), 0, this.pageSize);
                    n3 += this.pageSize;
                }
                System.arraycopy(objectArray, n3, (Object[])this.bufferArrayList.get(n + n2), 0, n4 & this.r);
            }
            this.size += objectArray.length;
            return;
        }
        int n6 = (objectArray.length + this.size >> this.exp) + ((objectArray.length + this.size & this.r) > 0 ? 1 : 0) - (this.capacity >> this.exp);
        System.arraycopy(objectArray, 0, objectArray2, this.size & this.r, this.capacity - this.size);
        for (int i = 0; i < n6; ++i) {
            Object[] objectArray3 = new Object[this.pageSize];
            if (i < n6 - 1) {
                System.arraycopy(objectArray, this.pageSize * i + this.capacity - this.size, objectArray3, 0, this.pageSize);
            } else {
                System.arraycopy(objectArray, this.pageSize * i + this.capacity - this.size, objectArray3, 0, objectArray.length + this.size - this.capacity - this.pageSize * i);
            }
            this.bufferArrayList.add(objectArray3);
        }
        this.size += objectArray.length;
        this.capacity += n6 * this.pageSize;
    }

    public final void append(Object object) {
        if (this.size < this.capacity) {
            ((Object[])this.bufferArrayList.oa[this.bufferArrayList.size - 1])[this.size & this.r] = object;
            ++this.size;
        } else {
            Object[] objectArray = new Object[this.pageSize];
            ++this.size;
            this.capacity += this.pageSize;
            this.bufferArrayList.add(objectArray);
            objectArray[0] = object;
        }
    }

    public final int getCapacity() {
        return this.capacity;
    }

    public Object[] getObjectArray(int n, int n2) {
        if (this.size <= 0 || n < 0) {
            throw new IllegalArgumentException();
        }
        if (n + n2 > this.size) {
            throw new IndexOutOfBoundsException();
        }
        Object[] objectArray = new Object[n2];
        int n3 = n >> this.exp;
        int n4 = n + n2 >> this.exp;
        if ((n + n2 & this.r) == 0) {
            --n4;
        }
        if (n3 == n4) {
            System.arraycopy((Object[])this.bufferArrayList.get(n3), n & this.r, objectArray, 0, n2);
        } else {
            int n5 = 0;
            for (int i = n3; i <= n4; ++i) {
                Object[] objectArray2 = (Object[])this.bufferArrayList.get(i);
                if (i == n3) {
                    System.arraycopy(objectArray2, n & this.r, objectArray, 0, this.pageSize - (n & this.r));
                    n5 += this.pageSize - (n & this.r);
                    continue;
                }
                if (i == n4) {
                    System.arraycopy(objectArray2, 0, objectArray, n5, n2 - n5);
                    continue;
                }
                System.arraycopy(objectArray2, 0, objectArray, n5, this.pageSize);
                n5 += this.pageSize;
            }
        }
        return objectArray;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public Object objectAt(int n) {
        if (n > this.size - 1) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = n >> this.exp;
        int n3 = n & this.r;
        return ((Object[])this.bufferArrayList.get(n2))[n3];
    }

    public void modifyEntry(int n, Object object) {
        if (n > this.size - 1) {
            throw new IndexOutOfBoundsException();
        }
        ((Object[])this.bufferArrayList.get((int)(n >> this.exp)))[n & this.r] = object;
    }

    public int size() {
        return this.size;
    }

    public Object[] toObjectArray() {
        if (this.size > 0) {
            int n = this.size;
            Object[] objectArray = new Object[this.size];
            int n2 = 0;
            int n3 = 0;
            while (n > 0) {
                System.arraycopy((Object[])this.bufferArrayList.get(n3), 0, objectArray, n2, n < this.pageSize ? n : this.pageSize);
                n -= this.pageSize;
                n2 += this.pageSize;
                ++n3;
            }
            return objectArray;
        }
        return null;
    }

    public void clear() {
        this.size = 0;
    }
}

