/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware;

import com.ximpleware.ILongBuffer;
import com.ximpleware.arrayList;

public class FastLongBuffer
implements ILongBuffer {
    private arrayList bufferArrayList;
    private int capacity;
    private int pageSize;
    protected int size;
    private int exp;
    private int r;

    public FastLongBuffer() {
        this.size = 0;
        this.capacity = 0;
        this.pageSize = 1024;
        this.exp = 10;
        this.r = 1023;
        this.bufferArrayList = new arrayList();
    }

    public FastLongBuffer(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.size = 0;
        this.capacity = 0;
        this.pageSize = 1 << n;
        this.exp = n;
        this.r = this.pageSize - 1;
        this.bufferArrayList = new arrayList();
    }

    public FastLongBuffer(int n, int n2) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.size = 0;
        this.capacity = 0;
        this.pageSize = 1 << n;
        this.exp = n;
        this.r = this.pageSize - 1;
        this.bufferArrayList = new arrayList(n2);
    }

    public void append(long[] lArray) {
        int n;
        long[] lArray2;
        if (lArray == null) {
            throw new NullPointerException();
        }
        if (this.bufferArrayList.size == 0) {
            lArray2 = new long[this.pageSize];
            this.bufferArrayList.add(lArray2);
            n = 0;
            this.capacity = this.pageSize;
        } else {
            n = Math.min(this.size >> this.exp, this.bufferArrayList.size - 1);
            lArray2 = (long[])this.bufferArrayList.oa[n];
        }
        if (this.size + lArray.length < this.capacity) {
            if (this.size + lArray.length < n + 1 << this.exp) {
                System.arraycopy(lArray, 0, lArray2, this.size & this.r, lArray.length);
            } else {
                int n2;
                int n3 = this.pageSize - (this.size & this.r);
                System.arraycopy(lArray, 0, lArray2, this.size & this.r, n3);
                int n4 = lArray.length - n3;
                int n5 = n4 >> this.exp;
                for (n2 = 1; n2 <= n5; ++n2) {
                    System.arraycopy(lArray, n3, (long[])this.bufferArrayList.oa[n + n2], 0, this.pageSize);
                    n3 += this.pageSize;
                }
                System.arraycopy(lArray, n3, (long[])this.bufferArrayList.oa[n + n2], 0, n4 & this.r);
            }
            this.size += lArray.length;
            return;
        }
        int n6 = (lArray.length + this.size >> this.exp) + ((lArray.length + this.size & this.r) > 0 ? 1 : 0) - (this.capacity >> this.exp);
        System.arraycopy(lArray, 0, lArray2, this.size & this.r, this.capacity - this.size);
        for (int i = 0; i < n6; ++i) {
            long[] lArray3 = new long[this.pageSize];
            if (i < n6 - 1) {
                System.arraycopy(lArray, this.pageSize * i + this.capacity - this.size, lArray3, 0, this.pageSize);
            } else {
                System.arraycopy(lArray, this.pageSize * i + this.capacity - this.size, lArray3, 0, lArray.length + this.size - this.pageSize * i - this.capacity);
            }
            this.bufferArrayList.add(lArray3);
        }
        this.size += lArray.length;
        this.capacity += n6 * this.pageSize;
    }

    public final void append(long l) {
        if (this.size < this.capacity) {
            ((long[])this.bufferArrayList.oa[this.size >> this.exp])[this.size & this.r] = l;
            ++this.size;
        } else {
            long[] lArray = new long[this.pageSize];
            ++this.size;
            this.capacity += this.pageSize;
            this.bufferArrayList.add(lArray);
            lArray[0] = l;
        }
    }

    public final int getCapacity() {
        return this.capacity;
    }

    public long[] getLongArray(int n, int n2) {
        if (this.size <= 0 || n < 0) {
            throw new IllegalArgumentException();
        }
        if (n + n2 > this.size) {
            throw new IndexOutOfBoundsException();
        }
        long[] lArray = new long[n2];
        int n3 = n >> this.exp;
        int n4 = n + n2 >> this.exp;
        if ((n + n2 & this.r) == 0) {
            --n4;
        }
        if (n3 == n4) {
            System.arraycopy((long[])this.bufferArrayList.oa[n3], n & this.r, lArray, 0, n2);
        } else {
            int n5 = 0;
            for (int i = n3; i <= n4; ++i) {
                long[] lArray2 = (long[])this.bufferArrayList.oa[i];
                if (i == n3) {
                    System.arraycopy(lArray2, n & this.r, lArray, 0, this.pageSize - (n & this.r));
                    n5 += this.pageSize - (n & this.r);
                    continue;
                }
                if (i == n4) {
                    System.arraycopy(lArray2, 0, lArray, n5, n2 - n5);
                    continue;
                }
                System.arraycopy(lArray2, 0, lArray, n5, this.pageSize);
                n5 += this.pageSize;
            }
        }
        return lArray;
    }

    public final int getPageSize() {
        return this.pageSize;
    }

    public final long longAt(int n) {
        int n2 = n >> this.exp;
        int n3 = n & this.r;
        return ((long[])this.bufferArrayList.oa[n2])[n3];
    }

    public final int lower32At(int n) {
        int n2 = n >> this.exp;
        int n3 = n & this.r;
        return (int)((long[])this.bufferArrayList.oa[n2])[n3];
    }

    public final void modifyEntry(int n, long l) {
        ((long[])this.bufferArrayList.oa[n >> this.exp])[n & this.r] = l;
    }

    public final int size() {
        return this.size;
    }

    public long[] toLongArray() {
        if (this.size > 0) {
            int n = this.size;
            long[] lArray = new long[this.size];
            int n2 = 0;
            int n3 = 0;
            while (n > 0) {
                System.arraycopy((long[])this.bufferArrayList.oa[n3], 0, lArray, n2, n < this.pageSize ? n : this.pageSize);
                n -= this.pageSize;
                n2 += this.pageSize;
                ++n3;
            }
            return lArray;
        }
        return null;
    }

    public final int upper32At(int n) {
        int n2 = n >> this.exp;
        int n3 = n & this.r;
        return (int)((((long[])this.bufferArrayList.oa[n2])[n3] & 0xFFFFFFFF00000000L) >> 32);
    }

    public final void clear() {
        this.size = 0;
    }

    public final boolean resize(int n) {
        if (n <= this.capacity && n >= 0) {
            this.size = n;
            return true;
        }
        return false;
    }
}

