/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.apply.support.vo;

import gov.grants.commons.util.GDGEscapeUtil;
import java.net.URLDecoder;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;

public class AttachmentDetails {
    private static final transient Logger log = Logger.getLogger((String)AttachmentDetails.class.getName());
    public static final String ATTACHMENT_NS_URI = "http://apply.grants.gov/system/Attachments-V1.0";
    public static final String FILENAME_ELEMENT_LOCAL_PART = "FileName";
    public static final String MIME_TYPE_ELEMENT_LOCAL_PART = "MimeType";
    public static final String FILE_LOCATION_ELEMENT_LOCAL_PART = "FileLocation";
    public static final String HASH_VALUE_ELEMENT_LOCAL_PART = "HashValue";
    public static final String CID_ATTRIBUTE_LOCAL_PART = "href";
    public static final String HASH_VALUE_ELEMENT = "glob:HashValue";
    public static final String FILENAME_ELEMENT = "att:FileName";
    public static final String FILE_LOCATION_ELEMENT = "att:FileLocation";
    public static final String CID_ATTRIBUTE = "att:href";
    private String contentID;
    private String fileName;
    private String mimeType;
    private String hashValue;
    private String xpathPrefix;
    private String rawFileName;
    private String parentFormName;

    public AttachmentDetails() {
    }

    public AttachmentDetails(String contentID, String fileName, String mimeType, String hashValue, String xpathPrefix) {
        this.contentID = contentID;
        this.fileName = fileName;
        this.mimeType = mimeType;
        this.hashValue = hashValue;
        this.xpathPrefix = xpathPrefix;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public String getFullFileName() {
        StringBuilder sb = new StringBuilder();
        boolean hasPrefix = false;
        if (StringUtils.isNotBlank((String)this.xpathPrefix)) {
            sb.append(this.xpathPrefix);
            hasPrefix = true;
        }
        if (StringUtils.isNotBlank((String)this.fileName)) {
            if (hasPrefix) {
                sb.append("-");
            }
            sb.append(this.fileName);
        }
        return sb.toString();
    }

    public String getFullFileName(String updatedFileName) {
        StringBuilder sb = new StringBuilder();
        boolean hasPrefix = false;
        if (StringUtils.isNotBlank((String)this.xpathPrefix)) {
            sb.append(this.xpathPrefix);
            hasPrefix = true;
        }
        if (StringUtils.isNotBlank((String)updatedFileName)) {
            if (hasPrefix) {
                sb.append("-");
            }
            sb.append(updatedFileName);
        }
        return sb.toString();
    }

    public String getUrlDecodedFileName() throws Exception {
        String value = null;
        try {
            value = GDGEscapeUtil.urlEncodeReservedUrlEncodeChars((String)this.fileName);
            value = URLDecoder.decode(value, "UTF-8");
        }
        catch (Exception e) {
            log.error((Object)e);
            e.printStackTrace();
            throw e;
        }
        return value;
    }

    public String getUrlDecodedContentID() throws Exception {
        String value = null;
        try {
            value = GDGEscapeUtil.urlEncodeReservedUrlEncodeChars((String)this.contentID);
            value = URLDecoder.decode(value, "UTF-8");
        }
        catch (Exception e) {
            log.error((Object)e);
            e.printStackTrace();
            throw e;
        }
        return value;
    }

    public String getContentID() {
        return this.contentID;
    }

    public void setContentID(String contentID) {
        this.contentID = contentID;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getHashValue() {
        return this.hashValue;
    }

    public void setHashValue(String hashValue) {
        this.hashValue = hashValue;
    }

    public String getXpathPrefix() {
        return this.xpathPrefix;
    }

    public void setXpathPrefix(String xpathPrefix) {
        this.xpathPrefix = xpathPrefix;
    }

    public String getParentFormName() {
        return this.parentFormName;
    }

    public void setParentFormName(String parentFormName) {
        this.parentFormName = parentFormName;
    }

    public String getRawFileName() {
        return this.rawFileName;
    }

    public void setRawFileName(String rawFileName) {
        this.rawFileName = rawFileName;
    }
}

