/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.apply.support.bizobj;

import com.ximpleware.AutoPilot;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import com.ximpleware.XMLModifier;
import gov.grants.apply.support.vo.AttachmentDetails;
import gov.grants.apply.support.vo.AttachmentXPathInfo;
import gov.grants.commons.XMLConstants;
import gov.grants.commons.util.VtdXmlUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class VtdXml {
    private static final transient Logger log = Logger.getLogger((String)VtdXml.class.getName());
    public static final String XMLNS_ATTR = "xmlns";
    public static final String XMLNS_PREFIX = "xmlns:";
    public static final String APPLICATION_ELEMENT_LOCAL_PART = "Application";
    public static final String GRANT_APPLICATION_ELEMENT_LOCAL_PART = "GrantApplication";
    public static final String OVERALL_APPLICATION_ELEMENT_LOCAL_PART = "OverallApplication";
    public static final String OVERALL_APPLICATION_ID_ELEMENT_LOCAL_PART = "OverallApplicationID";
    public static final String APPLICATION_PACKAGE_ELEMENT_LOCAL_PART = "ApplicationPackage";
    public static final String SUB_APPLICATION_GROUP_ID_ELEMENT_LOCAL_PART = "SubApplicationGroupID";
    public static final String SUB_APPLICATION_ID_ELEMENT_LOCAL_PART = "SubApplicationID";
    public static final String FORMS_ELEMENT_LOCAL_PART = "Forms";
    public static final String META_MULTI_GRANT_APPLICATION_NS_PREFIX = "mpgrant";
    public static final String META_MULTI_GRANT_APPLICATION_NS_URI = "http://apply.grants.gov/system/MetaMultiGrantApplication";
    public static final String META_GRANT_APPLICATION_NS_PREFIX = "grant";
    public static final String META_GRANT_APPLICATION_NS_URI = "http://apply.grants.gov/system/MetaGrantApplication";
    public static final String XML_SCHEMA_INSTANCE_NS_URL = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XML_SCHEMA_INSTANCE_DEFAULT_NS_PREFIX = "xsi";
    public static final String XML_SCHEMA_INSTANCE_DEFAULT_NS_DECLARATION = "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"";
    public static final String SCHEMA_LOCATION_ATTR_LOCAL_PART = "schemaLocation";
    public static final String SCHEMA_LOCATION_NS_SINGLE_PROJECT = "http://apply.grants.gov/system/MetaGrantApplication";
    public static final String GLOBAL_V1_XMLNS_URI = "http://apply.grants.gov/system/Global-V1.0";
    public static final String ATT_PREFIX_OVERALL = "OverallApplication";
    public static final String ATT_PREFIX_SUB_APPLICATION = "SubApplication";
    public static final String DEFAULT_HASH_ALGORITHM = "SHA-1";
    public static final String SCHEMA_VERSION = "1.0";
    public static final Map<String, String> BASE_FORM_NS_MAP = new HashMap<String, String>();
    public static final String BASE_NS_STR;
    protected String XML_SCHEMA_INSTANCE_BACKUP_NS_PREFIX = new Date().getTime() + "_xsi";
    protected String XML_SCHEMA_INSTANCE_BACKUP_NS_DECLARATION = "xmlns:" + this.XML_SCHEMA_INSTANCE_BACKUP_NS_PREFIX + "=\"" + "http://www.w3.org/2001/XMLSchema-instance" + "\"";
    protected VTDNav vn;
    protected AutoPilot ap = new AutoPilot();
    protected XMLModifier xm = new XMLModifier();
    protected boolean isMultiProject = false;
    protected Map<String, AttachmentDetails> attachmentDetailsMap = new HashMap<String, AttachmentDetails>();

    public byte[] getXmlBytes() throws Exception {
        try {
            return VtdXmlUtil.getXmlBytes((VTDNav)this.vn);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new Exception(e);
        }
    }

    public void addAllNamespaces(AutoPilot ap) {
        try {
            int size = this.vn.getTokenCount();
            Map<String, String> nsMap = this.getXmlNsMap();
            boolean count = false;
            nsMap.putAll(XMLConstants.getCommonXmlNsMap());
            log.debug((Object)("nsMap size: " + nsMap.size()));
            Set<String> nsPrefixes = nsMap.keySet();
            for (String prefix : nsPrefixes) {
                log.debug((Object)("adding namespace: " + prefix + "=" + nsMap.get(prefix)));
                ap.declareXPathNameSpace(prefix, nsMap.get(prefix));
            }
        }
        catch (Exception e) {
            log.error((Object)("Cannot add all namespaces: " + e.getMessage()));
        }
    }

    public Map<String, String> getXmlNsMap() {
        HashMap<String, String> xmlNsMap = new HashMap<String, String>();
        try {
            int size = this.vn.getTokenCount();
            String nsPrefix = null;
            String nsUrl = null;
            String mapNsUrl = null;
            for (int i = 0; i < size; ++i) {
                String token = this.vn.toNormalizedString2(i);
                if (!this.vn.startsWith(i, XMLNS_PREFIX)) continue;
                nsPrefix = token.substring(token.indexOf(":") + 1);
                nsUrl = this.vn.toNormalizedString2(i + 1);
                mapNsUrl = (String)xmlNsMap.get(nsPrefix);
                if (StringUtils.isBlank((String)mapNsUrl)) {
                    log.debug((Object)("add ns: " + nsPrefix + "=" + nsUrl));
                    xmlNsMap.put(nsPrefix, nsUrl);
                    continue;
                }
                if (mapNsUrl.equals(nsUrl)) continue;
            }
        }
        catch (Exception e) {
            log.error((Object)("Cannot add all namespaces: " + e.getMessage()));
        }
        return xmlNsMap;
    }

    public Map<String, String> getXmlNsMap(VTDNav vn, int beginIndex, int endIndex) {
        HashMap<String, String> xmlNsMap = new HashMap<String, String>();
        log.debug((Object)("begin index: " + beginIndex));
        log.debug((Object)("end index: " + endIndex));
        try {
            String nsPrefix = null;
            String nsUrl = null;
            String mapNsUrl = null;
            for (int i = beginIndex; i < endIndex; ++i) {
                String token = vn.toNormalizedString2(i);
                if (!vn.startsWith(i, XMLNS_ATTR)) continue;
                nsPrefix = token.substring(token.indexOf(":") + 1);
                nsUrl = vn.toNormalizedString2(i + 1);
                mapNsUrl = (String)xmlNsMap.get(nsPrefix);
                if (StringUtils.isBlank((String)mapNsUrl)) {
                    log.debug((Object)("add ns: " + nsPrefix + "=" + nsUrl));
                    xmlNsMap.put(nsPrefix, nsUrl);
                    continue;
                }
                if (mapNsUrl.equals(nsUrl)) continue;
                log.debug((Object)(nsPrefix + " [" + mapNsUrl + "] --- [" + nsUrl + "]"));
            }
        }
        catch (Exception e) {
            log.error((Object)("Cannot add all namespaces: " + e.getMessage()));
        }
        return xmlNsMap;
    }

    protected void init(byte[] xmlBytes) throws Exception {
        try {
            if (xmlBytes == null || xmlBytes.length == 0) {
                throw new Exception("XML bytes are blank");
            }
            log.debug((Object)("xml size: " + xmlBytes.length));
            VTDGen vGen = new VTDGen();
            vGen.setDoc(xmlBytes);
            vGen.parse(true);
            this.vn = vGen.getNav();
            log.debug((Object)"loaded xml successfully");
            this.addAllNamespaces(this.ap);
            this.ap.bind(this.vn);
        }
        catch (Exception e) {
            log.error((Object)("Exception parsing xml bytes: " + e.getMessage()));
            throw new Exception(e.getMessage());
        }
    }

    protected String getRawXmlStr() throws Exception {
        String rawXml = null;
        try {
            log.debug((Object)("get raw xml for element: " + this.vn.toNormalizedString2(this.vn.getCurrentIndex()) + " @ index: " + this.vn.getCurrentIndex()));
            long k = this.vn.getElementFragment();
            log.debug((Object)("k: " + k));
            rawXml = this.vn.toRawString((int)k, (int)(k >> 32));
        }
        catch (Exception e) {
            String s = "Exception caught: " + e.getMessage();
            log.error((Object)s);
            throw new Exception(s);
        }
        return rawXml;
    }

    protected String addNamespacesToRoot(String xmlStr) throws Exception {
        String rawXml = null;
        if (StringUtils.isBlank((String)xmlStr)) {
            throw new Exception("XML is blank");
        }
        try {
            byte[] xmlBytes = this.addNamespacesToRoot(xmlStr.getBytes());
            rawXml = IOUtils.toString((byte[])xmlBytes, (String)"UTF-8");
            return rawXml;
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new Exception(e);
        }
    }

    protected byte[] addNamespacesToRoot(byte[] xmlBytes) throws Exception {
        String nsStr = "";
        try {
            if (xmlBytes == null || xmlBytes.length == 0) {
                throw new Exception("XML is blank");
            }
            log.debug((Object)("xml size: " + xmlBytes.length));
            VTDGen vGen = new VTDGen();
            vGen.setDoc(xmlBytes);
            vGen.parse(false);
            VTDNav vNav = vGen.getNav();
            log.debug((Object)"loaded xml successfully");
            log.debug((Object)("root element: " + vNav.toNormalizedString(vNav.getCurrentIndex())));
            log.debug((Object)("root index: " + vNav.getCurrentIndex()));
            int beginIndex = vNav.getCurrentIndex();
            int attrCount = vNav.getAttrCount();
            log.debug((Object)("root attribute count: " + attrCount));
            int endIndex = vNav.getCurrentIndex() + attrCount * 2;
            for (int i = 1; i < endIndex; ++i) {
                log.debug((Object)("element @ " + (vNav.getCurrentIndex() + i) + ": " + vNav.toNormalizedString(vNav.getCurrentIndex() + i)));
            }
            Map<String, String> rootNsMap = this.getXmlNsMap(vNav, beginIndex, endIndex);
            log.debug((Object)("root element ns attrs: " + rootNsMap));
            if (rootNsMap.size() > 0) {
                StringBuilder ns = new StringBuilder();
                Set<Map.Entry<String, String>> entries = BASE_FORM_NS_MAP.entrySet();
                for (Map.Entry<String, String> entry : entries) {
                    if (!rootNsMap.containsKey(entry.getKey())) {
                        ns.append(" xmlns:").append(entry.getKey()).append("=\"").append(entry.getValue()).append("\"");
                        continue;
                    }
                    log.debug((Object)("root ns already has: " + entry.getKey() + "=" + entry.getValue()));
                }
                log.debug((Object)("missing ns attrs: " + ns));
                if (ns.length() > 0) {
                    nsStr = ns.toString();
                }
            } else {
                nsStr = BASE_NS_STR;
            }
            if (StringUtils.isNotBlank((String)nsStr)) {
                log.debug((Object)("adding ns declarations to form root element: " + nsStr));
                vNav.toElement(0);
                XMLModifier xm = new XMLModifier();
                xm.bind(vNav);
                xm.insertAttribute(" " + nsStr);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                xm.output((OutputStream)baos);
                xmlBytes = baos.toByteArray();
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new Exception(e);
        }
        log.info((Object)"returning original form xml");
        return xmlBytes;
    }

    protected boolean initAttachmentDetailsMap() throws Exception {
        String cid = null;
        int count = 0;
        AttachmentDetails attachmentDetails = null;
        try {
            this.resetXmlNav();
            String xpath = "//att:FileLocation";
            log.debug((Object)("xpath: " + xpath));
            this.ap.selectXPath(xpath);
            int i = -1;
            while ((i = this.ap.evalXPath()) > -1) {
                attachmentDetails = new AttachmentDetails();
                log.debug((Object)("--- " + this.vn.toNormalizedString2(this.vn.getCurrentIndex())));
                cid = this.vn.toRawString(this.vn.getAttrValNS("http://apply.grants.gov/system/Attachments-V1.0", "href"));
                log.debug((Object)("cid: " + cid));
                if (this.attachmentDetailsMap.containsKey(cid)) {
                    log.error((Object)("continue --- duplicate cid: " + cid));
                    continue;
                }
                attachmentDetails.setContentID(cid);
                this.vn.toElement(1);
                if (this.vn.toElementNS(2, "http://apply.grants.gov/system/Attachments-V1.0", "MimeType")) {
                    if (this.vn.getText() > -1) {
                        attachmentDetails.setMimeType(this.vn.toNormalizedString2(this.vn.getText()));
                    } else {
                        log.info((Object)"Attachment MimeType element is blank.");
                    }
                } else {
                    throw new Exception("Attachment MimeType element is missing for CID: " + cid);
                }
                this.vn.toElement(1);
                if (this.vn.toElementNS(2, GLOBAL_V1_XMLNS_URI, "HashValue")) {
                    if (this.vn.getText() > -1) {
                        attachmentDetails.setHashValue(this.vn.toNormalizedString2(this.vn.getText()));
                    } else {
                        log.info((Object)"Attachment HashValue element is blank.");
                    }
                } else {
                    throw new Exception("Attachment HashValue element is missing for CID: " + cid);
                }
                this.vn.toElement(1);
                if (this.vn.toElementNS(2, "http://apply.grants.gov/system/Attachments-V1.0", "FileName")) {
                    if (this.vn.getText() > -1) {
                        attachmentDetails.setRawFileName(this.vn.toRawString(this.vn.getText()));
                        attachmentDetails.setFileName(this.vn.toNormalizedString2(this.vn.getText()));
                    } else {
                        log.info((Object)"Attachment FileName element is blank.");
                    }
                } else {
                    throw new Exception("Attachment FileName element is missing for CID: " + cid);
                }
                this.vn.toElement(1);
                this.vn.toElement(2);
                AttachmentXPathInfo attXPathInfo = this.createAttXPathInfo();
                attachmentDetails.setXpathPrefix(attXPathInfo.getXpathPrefix());
                attachmentDetails.setParentFormName(attXPathInfo.getParentFormName());
                log.debug((Object)("adding attachment: " + attachmentDetails));
                this.attachmentDetailsMap.put(cid, attachmentDetails);
                ++count;
            }
        }
        catch (Exception e) {
            String s = "Exception creating attachment details map: " + e.getMessage();
            log.error((Object)s);
            throw new Exception(s);
        }
        log.debug((Object)("att count: " + count));
        return count > 0;
    }

    protected void resetXmlNav() throws Exception {
        try {
            this.vn.toElement(0);
        }
        catch (Exception e) {
            String s = "Exception caught resetting XML navigation to root: " + e.getMessage();
            log.error((Object)s);
            throw new Exception(s);
        }
    }

    protected AttachmentXPathInfo createAttXPathInfo() throws Exception {
        AttachmentXPathInfo attXPathInfo = new AttachmentXPathInfo();
        StringBuilder attXPathPrefix = new StringBuilder();
        try {
            log.debug((Object)("begin element name: " + this.vn.toNormalizedString2(this.vn.getCurrentIndex()) + " @ index " + this.vn.getCurrentIndex()));
            if (this.vn.getText() > -1) {
                log.debug((Object)("begin element value: " + this.vn.toNormalizedString2(this.vn.getText())));
            }
            this.vn.toElement(1);
            boolean prefixComplete = false;
            String fullElementName = null;
            String elementName = null;
            while (!prefixComplete) {
                this.vn.toElement(1);
                fullElementName = this.vn.toNormalizedString2(this.vn.getCurrentIndex());
                elementName = fullElementName.substring(fullElementName.indexOf(":") + 1);
                if (FORMS_ELEMENT_LOCAL_PART.equals(elementName)) {
                    if (this.isMultiProject) {
                        this.vn.toElement(1);
                        this.vn.toElement(5);
                        this.vn.toElement(2);
                        fullElementName = this.vn.toNormalizedString2(this.vn.getCurrentIndex());
                        elementName = fullElementName.substring(fullElementName.indexOf(":") + 1);
                        log.debug((Object)("parent element: " + elementName));
                        attXPathPrefix.insert(0, this.vn.toNormalizedString2(this.vn.getText()) + "-");
                        if (OVERALL_APPLICATION_ID_ELEMENT_LOCAL_PART.equals(elementName)) {
                            attXPathPrefix.insert(0, "OverallApplication-");
                        } else if (SUB_APPLICATION_ID_ELEMENT_LOCAL_PART.equals(elementName)) {
                            this.vn.toElement(1);
                            this.vn.toElement(1);
                            this.vn.toElement(1);
                            this.vn.toElement(2);
                            this.vn.toElement(2);
                            attXPathPrefix.insert(0, this.vn.toNormalizedString2(this.vn.getText()) + "-");
                        }
                    }
                    prefixComplete = true;
                    continue;
                }
                attXPathInfo.setParentFormName(elementName);
                if (attXPathPrefix.length() > 0) {
                    attXPathPrefix.insert(0, elementName + "-");
                    continue;
                }
                attXPathPrefix.insert(0, elementName);
            }
        }
        catch (Exception e) {
            String s = "Exception generating att prefix: " + e.getMessage();
            log.error((Object)s);
            throw new Exception(s);
        }
        attXPathInfo.setXpathPrefix(attXPathPrefix.toString());
        log.debug((Object)("returning att xpath info: " + attXPathInfo));
        return attXPathInfo;
    }

    protected String getElementByXPath(String xpath) throws Exception {
        String retVal = null;
        try {
            this.vn.toElement(0);
            this.ap.bind(this.vn);
            this.ap.selectXPath(xpath);
            int result = this.ap.evalXPath();
            if (result != -1) {
                log.debug((Object)String.format(" XPath element %s returned index: %d ", xpath, result));
                log.debug((Object)("XPath element Text: " + this.vn.toNormalizedString(result)));
                retVal = this.getRawXmlStr();
            }
        }
        catch (Exception e) {
            String s = "Exception getting Element by XPath: " + e.getMessage();
            log.error((Object)s);
            throw new Exception(s);
        }
        return retVal;
    }

    protected static String createBaseNsStr() {
        StringBuilder sb = new StringBuilder();
        Set<Map.Entry<String, String>> entries = BASE_FORM_NS_MAP.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            sb.append(" xmlns:").append(entry.getKey()).append("=\"").append(entry.getValue()).append("\"");
        }
        log.debug((Object)("base ns str: " + sb));
        return sb.toString();
    }

    protected String createAttHashValue(String attFilePath) throws Exception {
        String attHashValue = null;
        try {
            attHashValue = VtdXmlUtil.createAttHashValue((String)attFilePath);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new Exception(e);
        }
        log.debug((Object)("created attachment hash value: " + attHashValue));
        return attHashValue;
    }

    static {
        BASE_FORM_NS_MAP.put("glob", GLOBAL_V1_XMLNS_URI);
        BASE_FORM_NS_MAP.put("globLib", "http://apply.grants.gov/system/GlobalLibrary-V2.0");
        BASE_FORM_NS_MAP.put("att", "http://apply.grants.gov/system/Attachments-V1.0");
        BASE_NS_STR = VtdXml.createBaseNsStr();
    }
}

