/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.apply.support.bizobj;

import com.ximpleware.VTDNav;
import gov.grants.apply.support.bizobj.VtdXml;
import gov.grants.apply.support.vo.AttachmentDetails;
import gov.grants.commons.util.XMLHashUtil;
import org.apache.log4j.Logger;

public class SubmissionXml
extends VtdXml {
    private static final String CLASSNAME = SubmissionXml.class.getName();
    private static final Logger log = Logger.getLogger((String)CLASSNAME);

    public SubmissionXml(byte[] submissionXmlBytes) throws Exception {
        try {
            log.info((Object)"initialize submission xml bytes");
            super.init(submissionXmlBytes);
            this.setMultiProjectFlag();
            log.debug((Object)("isMultiProject: " + this.isMultiProject));
            this.initAttachmentDetailsMap();
        }
        catch (Exception e) {
            log.error((Object)("Exception parsing xml bytes: " + e.getMessage()));
            throw new Exception(e.getMessage());
        }
    }

    public SubmissionXml(VTDNav vNav) throws Exception {
        try {
            if (vNav == null) {
                throw new Exception("VTDNav is null");
            }
            this.vn = vNav;
            this.setMultiProjectFlag();
            log.debug((Object)("isMultiProject: " + this.isMultiProject));
            this.initAttachmentDetailsMap();
        }
        catch (Exception e) {
            log.error((Object)("Exception parsing xml bytes: " + e.getMessage()));
            throw new Exception(e.getMessage());
        }
    }

    public VTDNav getVTDNav() {
        return this.vn;
    }

    public boolean isMultiProject() {
        return this.isMultiProject;
    }

    public String getHeaderXml(boolean removeWhitespaceBetweenTags) throws Exception {
        String xml = null;
        try {
            this.resetXmlNav();
            if (this.isMultiProject) {
                this.vn.toElement(2);
                log.debug((Object)(this.vn.toNormalizedString2(this.vn.getCurrentIndex()) + " @ index: " + this.vn.getCurrentIndex()));
            } else {
                this.vn.toElement(2);
                log.debug((Object)(this.vn.toNormalizedString2(this.vn.getCurrentIndex()) + " @ index: " + this.vn.getCurrentIndex()));
            }
            xml = this.getRawXmlStr();
            if (removeWhitespaceBetweenTags) {
                String regex = ">[\\s]+<";
                xml = xml.replaceAll(regex, "><");
            }
        }
        catch (Exception e) {
            String s = "Exception caught: " + e.getMessage();
            log.error((Object)s);
            throw new Exception(s);
        }
        return xml;
    }

    public String createSubmissionXmlHashValue() throws Exception {
        try {
            String elementNsUri = null;
            String elementLocalPart = null;
            if (this.isMultiProject) {
                elementNsUri = "http://apply.grants.gov/system/MetaMultiGrantApplication";
                elementLocalPart = "ApplicationPackage";
            } else {
                elementNsUri = "http://apply.grants.gov/system/MetaGrantApplication";
                elementLocalPart = "Forms";
            }
            String calculatedHash = XMLHashUtil.createXmlHash((byte[])this.getXmlBytes(), (String)elementNsUri, (String)elementLocalPart);
            log.debug((Object)("returning calculated hash value: " + calculatedHash));
            return calculatedHash;
        }
        catch (Exception e) {
            String s = "Exception caught creating submission xml hash: " + e.getMessage();
            log.error((Object)s);
            throw new Exception(s);
        }
    }

    @Override
    public String createAttHashValue(String attFilePath) throws Exception {
        return super.createAttHashValue(attFilePath);
    }

    public String getSubmittedXmlHashValue() throws Exception {
        log.debug((Object)"get submitted xml hash value");
        String hash = null;
        try {
            this.resetXmlNav();
            if (this.isMultiProject) {
                this.vn.toElement(2);
            }
            this.vn.toElement(2);
            if (this.vn.toElementNS(2, "http://apply.grants.gov/system/Global-V1.0", "HashValue")) {
                log.debug((Object)(this.vn.toNormalizedString2(this.vn.getCurrentIndex()) + " @ index: " + this.vn.getCurrentIndex()));
                if (this.vn.getText() <= -1) {
                    throw new Exception("GrantSubmissionHeader HashValue element is blank.");
                }
                hash = this.vn.toNormalizedString2(this.vn.getText());
            } else {
                throw new Exception("GrantSubmissionHeader HashValue element is missing.");
            }
            log.debug((Object)("GrantSubmissionHeader hash: " + hash));
        }
        catch (Exception e) {
            String s = "Exception caught retrieving submission xml hash value: " + e.getMessage();
            log.error((Object)s);
            throw new Exception(s);
        }
        log.debug((Object)("submitted hash value: " + hash));
        return hash;
    }

    public AttachmentDetails getAttachmentDetailsByCID(String cid) throws Exception {
        if (!this.hasAttachments()) {
            log.info((Object)"no attachments");
            return null;
        }
        log.debug((Object)("get attachment details for cid: " + cid));
        log.debug((Object)("attachmentDetailsMap cid(s): " + this.attachmentDetailsMap.keySet()));
        return (AttachmentDetails)this.attachmentDetailsMap.get(cid);
    }

    public int getFileLocationElementIndexByCid(String cid) throws Exception {
        log.debug((Object)("get FileLocation element index for cid: " + cid));
        int i = -1;
        if (!this.attachmentDetailsMap.containsKey(cid)) {
            log.info((Object)("no attachment with cid: " + cid));
            return i;
        }
        try {
            this.resetXmlNav();
            this.ap.bind(this.vn);
            String xpath = "//att:FileLocation[@att:href]";
            this.ap.selectXPath(xpath);
            log.debug((Object)("evaluate xpath: " + xpath));
            log.debug((Object)("evaluate xpath expr: " + this.ap.getExprString()));
            String hrefAttrValue = null;
            while ((i = this.ap.evalXPath()) != -1) {
                log.debug((Object)(i + " ==> " + this.vn.toRawString(i)));
                hrefAttrValue = this.vn.toRawString(this.vn.getAttrValNS("http://apply.grants.gov/system/Attachments-V1.0", "href"));
                log.debug((Object)("href attribute value: " + hrefAttrValue));
                log.debug((Object)("CID: " + cid));
                if (!cid.equals(hrefAttrValue)) continue;
                log.debug((Object)("found CID match @ index: " + i));
                return i;
            }
        }
        catch (Exception e) {
            String s = "Exception creating AttachmentDetails map: " + e.getMessage();
            log.error((Object)s);
            throw new Exception(s);
        }
        log.debug((Object)("could not find cid: " + i));
        return i;
    }

    public boolean hasAttachments() throws Exception {
        return this.getAttachmentCount() > 0;
    }

    public int getAttachmentCount() throws Exception {
        try {
            this.resetXmlNav();
            this.ap.bind(this.vn);
            String xpath = "//att:FileLocation";
            this.ap.selectXPath(xpath);
            int count = 0;
            while (this.ap.evalXPath() > -1) {
                ++count;
            }
            log.debug((Object)("returning attachment count: " + count));
            return count;
        }
        catch (Exception e) {
            String s = "Exception getting attachment count: " + e.getMessage();
            log.error((Object)s);
            throw new Exception(s);
        }
    }

    private void setMultiProjectFlag() throws Exception {
        try {
            this.resetXmlNav();
            log.debug((Object)("root element: " + this.vn.toNormalizedString2(this.vn.getCurrentIndex())));
            if (!this.vn.endsWith(this.vn.getCurrentIndex(), "GrantApplication")) {
                this.isMultiProject = true;
            }
        }
        catch (Exception e) {
            String s = "Exception caught checking if is a multi-project XML: " + e.getMessage();
            log.error((Object)s);
            throw new Exception(s);
        }
    }
}

