/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.apply.applicant.v2;

import gov.grants.apply.applicant.v2.BaseApplicantClient;
import gov.grants.apply.services.applicantwebservices_v2.ApplicantWebServicesPortType;
import gov.grants.apply.services.applicantwebservices_v2.SubmitApplicationRequest;
import gov.grants.apply.services.applicantwebservices_v2.SubmitApplicationResponse;
import gov.grants.apply.system.grantscommonelements_v1.Attachment;
import gov.grants.commons.util.FileUtil;
import java.io.File;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.MimetypesFileTypeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SubmitApplicationClient
extends BaseApplicantClient {
    private static final String CLASSNAME = SubmitApplicationClient.class.getSimpleName();
    private static final Logger log = Logger.getLogger((String)CLASSNAME);

    public static void main(String[] args) {
        log.debug((Object)("Begin " + CLASSNAME));
        try {
            SubmitApplicationClient client = new SubmitApplicationClient();
            log.debug((Object)("args length: " + args.length));
            client.init(args);
            client.makeServiceCall();
            log.debug((Object)("\n\nSUCCESS: " + CLASSNAME + " successfully completed"));
        }
        catch (Exception e) {
            log.error((Object)("\n\nException: " + e.getMessage()));
        }
    }

    public void makeServiceCall() throws Exception {
        try {
            SubmitApplicationRequest request = new SubmitApplicationRequest();
            String configXml = this.getArgMap().get("config_xml");
            this.loadConfigXmlDoc(configXml);
            this.configVN.toElement(2, CLASSNAME);
            if (this.configVN.toElement(2, "previous-gg-tracking-num")) {
                String prevGGTrackingNum = this.configVN.toNormalizedString(this.configVN.getText());
                log.debug((Object)("previous Grants.Gov Tracking Number: " + prevGGTrackingNum));
                request.setGrantsGovTrackingNumber(prevGGTrackingNum);
                this.configVN.toElement(1);
            } else {
                log.debug((Object)"Optional previous Grants.Gov Tracking Number was not provided on configuration!");
            }
            this.configVN.toElement(2, "submission-dir");
            String submissionDir = this.configVN.toNormalizedString(this.configVN.getText());
            log.debug((Object)("submissionDir: " + submissionDir));
            this.configVN.toElement(1);
            this.configVN.toElement(2, "submission-xml");
            String xmlFileName = this.configVN.toNormalizedString(this.configVN.getText());
            log.debug((Object)("xmlFileName: " + xmlFileName));
            if (StringUtils.isBlank((String)submissionDir) || StringUtils.isBlank((String)xmlFileName)) {
                String s = "submission-dir and submission-xml elements in the config xml cannot be blank";
                log.error((Object)s);
                throw new Exception(s);
            }
            byte[] fileBytes = null;
            String fileName = null;
            String cid = null;
            String contentType = null;
            log.debug((Object)"load attachment(s)");
            File att = null;
            while (this.configVN.toElement(4, "attachment")) {
                this.configVN.toElement(2, "file-name");
                fileName = this.configVN.toNormalizedString2(this.configVN.getText());
                log.debug((Object)("attachment file name: " + fileName));
                att = new File(submissionDir + fileName);
                log.debug((Object)("try to load: " + att.getCanonicalPath()));
                if (!att.exists()) {
                    log.warn((Object)("File does not exist: " + att.getCanonicalPath()));
                    att = new File(fileName);
                    log.debug((Object)("try to load: " + att.getCanonicalPath()));
                    if (!att.exists()) {
                        log.error((Object)("File does not exist: " + att.getCanonicalPath()));
                        throw new Exception("File does not exist: " + att.getCanonicalPath());
                    }
                }
                contentType = new MimetypesFileTypeMap().getContentType(att);
                log.debug((Object)("content type: " + contentType));
                this.configVN.toElement(1);
                this.configVN.toElement(2, "cid");
                cid = this.configVN.toRawString(this.configVN.getText());
                log.debug((Object)("cid: " + cid));
                Attachment attachment = new Attachment();
                attachment.setFileDataHandler(new DataHandler((DataSource)new FileDataSource(submissionDir + fileName)));
                attachment.setFileContentId(cid);
                request.getAttachment().add(attachment);
                this.configVN.toElement(1);
            }
            ApplicantWebServicesPortType port = super.getApplicantPort();
            log.debug((Object)"load submission xml");
            fileBytes = FileUtil.readFile((String)(submissionDir + xmlFileName));
            log.debug((Object)("xml bytes: " + fileBytes.length));
            log.debug((Object)("xml size: " + new String(fileBytes).length()));
            request.setGrantApplicationXML(new String(fileBytes, "UTF-8"));
            SubmitApplicationResponse response = port.submitApplication(request);
            String ggTrackingNum = response.getGrantsGovTrackingNumber();
            String receivedDateTime = SubmitApplicationClient.formatDate(response.getReceivedDateTime().toGregorianCalendar().getTime(), "yyyy-MM-dd HH:mm:ss");
            StringBuilder sb = new StringBuilder();
            sb.append("\n\nGG Tracking Number: ").append(ggTrackingNum);
            sb.append("\nReceived Date/Time: ").append(receivedDateTime);
            sb.append("\n\n");
            log.debug((Object)sb);
        }
        catch (Exception e) {
            log.error((Object)("Exception: " + e.getMessage()));
            e.printStackTrace();
            throw e;
        }
    }
}

