/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.apply.applicant.v2;

import gov.grants.apply.applicant.v2.BaseApplicantClient;
import gov.grants.apply.services.applicantwebservices_v2.ApplicantWebServicesPortType;
import gov.grants.apply.services.applicantwebservices_v2.AuthenticateAORRequest;
import gov.grants.apply.services.applicantwebservices_v2.AuthenticateAORResponse;
import gov.grants.apply.services.applicantwebservices_v2.SubmitApplicationAsThirdPartyRequest;
import gov.grants.apply.services.applicantwebservices_v2.SubmitApplicationAsThirdPartyResponse;
import gov.grants.apply.system.grantscommonelements_v1.Attachment;
import gov.grants.apply.system.grantscommonelements_v1.Token;
import gov.grants.apply.system.grantscommontypes_v1.AORStatusType;
import gov.grants.commons.util.FileUtil;
import java.io.File;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.MimetypesFileTypeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;

public class SubmitApplicationAsThirdPartyClient
extends BaseApplicantClient {
    private static final String CLASSNAME = SubmitApplicationAsThirdPartyClient.class.getSimpleName();
    private static final Logger log = Logger.getLogger((String)CLASSNAME);

    public static void main(String[] args) {
        log.debug((Object)("Begin " + CLASSNAME));
        try {
            SubmitApplicationAsThirdPartyClient client = new SubmitApplicationAsThirdPartyClient();
            log.debug((Object)("args length: " + args.length));
            client.init(args);
            client.makeServiceCall();
            log.debug((Object)("\n\nSUCCESS: " + CLASSNAME + " successfully completed"));
        }
        catch (Exception e) {
            log.error((Object)("\n\nException: " + e.getMessage()));
        }
    }

    public void makeServiceCall() throws Exception {
        try {
            SubmitApplicationAsThirdPartyRequest request = new SubmitApplicationAsThirdPartyRequest();
            String aorUserId = null;
            String aorPassword = null;
            String aorDuns = null;
            Object aorUei = null;
            ApplicantWebServicesPortType port = super.getApplicantPort();
            String configXml = this.getArgMap().get("config_xml");
            this.loadConfigXmlDoc(configXml);
            this.configVN.toElement(2, CLASSNAME);
            log.debug((Object)"prepare authenticateAOR service call");
            if (this.configVN.toElement(2, "aor-user-id")) {
                aorUserId = this.configVN.toNormalizedString2(this.configVN.getText());
                log.debug((Object)("AOR user ID: " + aorUserId));
                this.configVN.toElement(1);
            }
            if (this.configVN.toElement(2, "aor-password")) {
                aorPassword = this.configVN.toNormalizedString2(this.configVN.getText());
                log.debug((Object)("AOR password: " + aorPassword));
                this.configVN.toElement(1);
            }
            if (this.configVN.toElement(2, "aor-duns")) {
                aorDuns = this.configVN.toNormalizedString(this.configVN.getText());
                log.debug((Object)("aorDuns: " + aorDuns));
                this.configVN.toElement(1);
            } else {
                log.debug((Object)"Optional AOR DUNS is not specified!");
            }
            if (this.configVN.toElement(2, "previous-gg-tracking-num")) {
                String prevGGTrackingNum = this.configVN.toNormalizedString(this.configVN.getText());
                log.debug((Object)("previous Grants.Gov Tracking Number: " + prevGGTrackingNum));
                request.setGrantsGovTrackingNumber(prevGGTrackingNum);
                this.configVN.toElement(1);
            } else {
                log.debug((Object)"Optional previous Grants.Gov Tracking Number was not provided on configuration!");
            }
            this.configVN.toElement(2, "submission-dir");
            String submissionDir = this.configVN.toNormalizedString2(this.configVN.getText());
            log.debug((Object)("submission dir: " + submissionDir));
            this.configVN.toElement(1);
            this.configVN.toElement(2, "submission-xml");
            String xmlFileName = this.configVN.toNormalizedString2(this.configVN.getText());
            log.debug((Object)("xmlFileName: " + xmlFileName));
            if (StringUtils.isBlank((String)submissionDir) || StringUtils.isBlank((String)xmlFileName)) {
                String s = "submission-dir and submission-xml elements in the config xml cannot be blank";
                log.error((Object)s);
                throw new Exception(s);
            }
            log.debug((Object)"make AuthenticateAOR service call");
            Token token = this.authenticateAOR(port, aorUserId, aorPassword, aorDuns);
            String aorStatus = token.getAORStatus().toString();
            log.debug((Object)("AOR status: " + aorStatus));
            if (token.getAORStatus() == AORStatusType.UNAUTHORIZED) {
                String s = "### aorUserId [" + aorUserId + "] is " + AORStatusType.UNAUTHORIZED.toString();
                log.error((Object)s);
                throw new Exception(s);
            }
            log.debug((Object)"prepare to submitApplicationAsThirdParty service call");
            request.setToken(token);
            byte[] fileBytes = null;
            String fileName = null;
            String cid = null;
            String contentType = null;
            log.debug((Object)"load attachment(s)");
            File att = null;
            while (this.configVN.toElement(4, "attachment")) {
                this.configVN.toElement(2, "file-name");
                fileName = this.configVN.toNormalizedString2(this.configVN.getText());
                log.debug((Object)("attachment file name: " + fileName));
                att = new File(submissionDir + fileName);
                log.debug((Object)("try to load: " + att.getCanonicalPath()));
                if (!att.exists()) {
                    log.warn((Object)("File does not exist: " + att.getCanonicalPath()));
                    att = new File(fileName);
                    log.debug((Object)("try to load: " + att.getCanonicalPath()));
                    if (!att.exists()) {
                        log.error((Object)("File does not exist: " + att.getCanonicalPath()));
                        throw new Exception("File does not exist: " + att.getCanonicalPath());
                    }
                }
                contentType = new MimetypesFileTypeMap().getContentType(att);
                log.debug((Object)("content type: " + contentType));
                this.configVN.toElement(1);
                this.configVN.toElement(2, "cid");
                cid = this.configVN.toRawString(this.configVN.getText());
                log.debug((Object)("cid: " + cid));
                Attachment attachment = new Attachment();
                attachment.setFileDataHandler(new DataHandler((DataSource)new FileDataSource(submissionDir + fileName)));
                attachment.setFileContentId(cid);
                request.getAttachment().add(attachment);
                this.configVN.toElement(1);
            }
            log.debug((Object)"load submission xml");
            fileBytes = FileUtil.readFile((String)(submissionDir + xmlFileName));
            log.debug((Object)("xml bytes: " + fileBytes.length));
            log.debug((Object)("xml size: " + new String(fileBytes).length()));
            request.setApplicationXML(new String(fileBytes, "UTF-8"));
            SubmitApplicationAsThirdPartyResponse response = port.submitApplicationAsThirdParty(request);
            String ggTrackingNum = response.getGrantsGovTrackingNumber();
            String receivedDateTime = SubmitApplicationAsThirdPartyClient.formatDate(response.getReceivedDateTime().toGregorianCalendar().getTime(), "yyyy-MM-dd HH:mm:ss");
            StringBuilder sb = new StringBuilder();
            sb.append("\n\nGG Tracking Number: ").append(ggTrackingNum);
            sb.append("\nReceived Date/Time: ").append(receivedDateTime);
            sb.append("\n\n");
            log.debug((Object)sb);
        }
        catch (Exception e) {
            log.error((Object)("Exception: " + e.getMessage()));
            e.printStackTrace();
            throw e;
        }
    }

    private Token authenticateAOR(ApplicantWebServicesPortType port, String aorUserId, String aorPassword, String aorDuns) throws Exception {
        Token token = null;
        try {
            AuthenticateAORRequest request = new AuthenticateAORRequest();
            request.setAORUserID(aorUserId);
            request.setAORPassword(aorPassword);
            request.setDUNS(aorDuns);
            AuthenticateAORResponse response = port.authenticateAOR(request);
            token = response.getToken();
        }
        catch (Exception e) {
            String s = "Exception caught authenticating AOR [" + aorUserId + "]: " + e.getMessage();
            log.error((Object)s);
            throw new Exception(s);
        }
        log.debug((Object)("returning token: " + ToStringBuilder.reflectionToString((Object)token)));
        return token;
    }
}

