/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.apply.applicant.v2;

import com.ximpleware.VTDNav;
import com.ximpleware.XMLModifier;
import gov.grants.apply.applicant.v2.BaseApplicantClient;
import gov.grants.apply.support.bizobj.SubmissionXml;
import gov.grants.commons.util.FileUtil;
import gov.grants.commons.util.VtdXmlUtil;
import gov.grants.commons.util.XMLHashUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class PrepareSubmissionXml
extends BaseApplicantClient {
    private static final String CLASSNAME = PrepareSubmissionXml.class.getSimpleName();
    private static final Logger log = Logger.getLogger((String)CLASSNAME);

    public static void main(String[] args) {
        log.debug((Object)("Begin " + CLASSNAME));
        try {
            PrepareSubmissionXml client = new PrepareSubmissionXml();
            log.debug((Object)("args length: " + args.length));
            client.init(args);
            client.prepareXml();
            log.debug((Object)("\n\nSUCCESS: " + CLASSNAME + " successfully completed"));
        }
        catch (Exception e) {
            log.error((Object)("\n\nException: " + e.getMessage()));
        }
    }

    public void prepareXml() throws Exception {
        try {
            String clientName = this.getArgMap().get("client");
            log.debug((Object)("client element name: " + clientName));
            String configXml = this.getArgMap().get("config_xml");
            this.loadConfigXmlDoc(configXml);
            log.debug((Object)("find element: " + clientName));
            this.configVN.toElement(2, clientName);
            this.configVN.toElement(2, "submission-dir");
            String submissionDir = this.configVN.toNormalizedString(this.configVN.getText());
            log.debug((Object)("submissionDir: " + submissionDir));
            this.configVN.toElement(1);
            this.configVN.toElement(2, "submission-xml");
            String xmlFileName = this.configVN.toNormalizedString(this.configVN.getText());
            log.debug((Object)("xmlFileName: " + xmlFileName));
            byte[] fileBytes = null;
            log.debug((Object)"load submission xml");
            fileBytes = FileUtil.readFile((String)(submissionDir + xmlFileName));
            log.debug((Object)("xml bytes: " + fileBytes.length));
            log.debug((Object)("xml size: " + new String(fileBytes).length()));
            this.backupXml(fileBytes, submissionDir + xmlFileName);
            SubmissionXml subXml = new SubmissionXml(fileBytes);
            VTDNav vn = subXml.getVTDNav();
            XMLModifier xm = new XMLModifier();
            log.debug((Object)"bind to VTDNav");
            xm.bind(vn);
            log.debug((Object)"bound successfully");
            String fileName = null;
            String attFilePath = null;
            String attHash = null;
            String cid = null;
            boolean index = false;
            while (this.configVN.toElement(4, "attachment")) {
                this.configVN.toElement(2, "file-name");
                fileName = this.configVN.toNormalizedString2(this.configVN.getText());
                log.debug((Object)("attachment file name: " + fileName));
                attFilePath = submissionDir + fileName;
                log.debug((Object)("attFilePath: " + attFilePath));
                attHash = subXml.createAttHashValue(attFilePath);
                this.configVN.toElement(1);
                this.configVN.toElement(2, "cid");
                cid = this.configVN.toRawString(this.configVN.getText());
                log.debug((Object)("cid: " + cid));
                subXml.getFileLocationElementIndexByCid(cid);
                log.debug((Object)(vn.toNormalizedString(vn.getCurrentIndex()) + " @ index: " + vn.getCurrentIndex()));
                vn.toElement(1);
                vn.toElementNS(2, "http://apply.grants.gov/system/Global-V1.0", "HashValue");
                log.debug((Object)(vn.toNormalizedString(vn.getCurrentIndex()) + " @ index: " + vn.getCurrentIndex()));
                xm.updateToken(vn.getText(), attHash);
                this.configVN.toElement(1);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            xm.output((OutputStream)baos);
            byte[] xmlBytes = baos.toByteArray();
            String xmlHash = this.createSubmissionXmlHashValue(xmlBytes, subXml.isMultiProject());
            vn.toElement(0);
            if (subXml.isMultiProject()) {
                vn.toElement(2);
            }
            vn.toElement(2);
            String headerElement = vn.toNormalizedString(vn.getCurrentIndex());
            log.debug((Object)("header element: " + headerElement));
            log.debug((Object)("header xml: " + VtdXmlUtil.getRawXmlStr((VTDNav)vn)));
            if (headerElement.endsWith("GrantSubmissionHeader")) {
                if (vn.toElementNS(2, "http://apply.grants.gov/system/Global-V1.0", "HashValue")) {
                    log.debug((Object)("hash element: " + vn.toNormalizedString(vn.getCurrentIndex()) + " @ index: " + vn.getCurrentIndex()));
                    if (vn.getText() > -1) {
                        log.debug((Object)("update hash value: " + xmlHash));
                        xm.updateToken(vn.getText(), xmlHash);
                    }
                } else {
                    String s = "HashValue element not found";
                    log.error((Object)s);
                    throw new Exception(s);
                }
            }
            log.debug((Object)("output file: " + xmlFileName));
            xm.output(submissionDir + xmlFileName);
        }
        catch (Exception e) {
            log.error((Object)("Exception: " + e.getMessage()));
            e.printStackTrace();
            throw e;
        }
    }

    private String createSubmissionXmlHashValue(byte[] xmlBytes, boolean isMultiProject) throws Exception {
        try {
            String elementNsUri = null;
            String elementLocalPart = null;
            if (isMultiProject) {
                elementNsUri = "http://apply.grants.gov/system/MetaMultiGrantApplication";
                elementLocalPart = "ApplicationPackage";
            } else {
                elementNsUri = "http://apply.grants.gov/system/MetaGrantApplication";
                elementLocalPart = "Forms";
            }
            String calculatedHash = XMLHashUtil.createXmlHash((byte[])xmlBytes, (String)elementNsUri, (String)elementLocalPart);
            log.debug((Object)("returning calculated hash value: " + calculatedHash));
            return calculatedHash;
        }
        catch (Exception e) {
            String s = "Exception caught creating submission xml hash: " + e.getMessage();
            log.error((Object)s);
            throw new Exception(s);
        }
    }

    private int getElementIndex(VTDNav vNav, String localPart, int beginIndex, int endIndex) throws Exception {
        try {
            if (endIndex < 1) {
                endIndex = vNav.getTokenCount();
            }
            for (int i = beginIndex; i < endIndex; ++i) {
                String token = vNav.toNormalizedString(i);
                if (!vNav.endsWith(i, localPart)) continue;
                log.debug((Object)("token: " + token + " @ index: " + i));
                return i;
            }
            return -1;
        }
        catch (Exception e) {
            String s = "Exception getting element index: " + e.getMessage();
            log.error((Object)s);
            throw new Exception(s);
        }
    }

    private void backupXml(byte[] xmlBytes, String filePath) throws Exception {
        try {
            if (StringUtils.isBlank((String)filePath)) {
                String s = "File path cannot be blank";
                log.error((Object)s);
                throw new Exception(s);
            }
            if (xmlBytes == null || xmlBytes.length == 0) {
                String s = "XML is blank";
                log.error((Object)s);
                throw new Exception(s);
            }
            int index = filePath.lastIndexOf(".");
            String fileExt = filePath.substring(index);
            String filename = filePath.substring(0, index);
            String backupFileName = filename + "_orig" + fileExt;
            log.debug((Object)("backup file name: " + backupFileName));
            FileUtil.bytesToDisk((byte[])xmlBytes, (String)backupFileName);
        }
        catch (Exception e) {
            String s = "Exception caught backing up XML to disk: " + e.getMessage();
            log.error((Object)s);
            throw new Exception(s);
        }
    }
}

