/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.apply.applicant.v2;

import gov.grants.apply.applicant.v2.BaseApplicantClient;
import gov.grants.apply.services.applicantwebservices_v2.ApplicantWebServicesPortType;
import gov.grants.apply.services.applicantwebservices_v2.GetSubmissionListAsThirdPartyRequest;
import gov.grants.apply.services.applicantwebservices_v2.GetSubmissionListAsThirdPartyResponse;
import gov.grants.apply.system.applicantcommonelements_v1.SubmissionDetails;
import gov.grants.apply.system.applicantcommonelements_v1.SubmissionFilter;
import gov.grants.apply.system.applicantcommonelements_v1.SubmissionFilterType;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;

public class GetSubmissionListAsThirdPartyClient
extends BaseApplicantClient {
    private static final String CLASSNAME = GetSubmissionListAsThirdPartyClient.class.getSimpleName();
    private static final Logger log = Logger.getLogger((String)CLASSNAME);

    public static void main(String[] args) {
        log.debug((Object)("Begin " + CLASSNAME));
        try {
            GetSubmissionListAsThirdPartyClient client = new GetSubmissionListAsThirdPartyClient();
            log.debug((Object)("args length: " + args.length));
            client.init(args);
            client.makeServiceCall();
            log.debug((Object)("\n\nSUCCESS: " + CLASSNAME + " successfully completed"));
        }
        catch (Exception e) {
            log.error((Object)("\n\nException: " + e.getMessage()));
        }
    }

    public void makeServiceCall() throws Exception {
        try {
            ApplicantWebServicesPortType port = this.getApplicantPort();
            GetSubmissionListAsThirdPartyRequest request = new GetSubmissionListAsThirdPartyRequest();
            List filters = request.getSubmissionFilter();
            SubmissionFilter filter = null;
            Set<String> argKeys = this.getArgMap().keySet();
            String filterType = null;
            String filterValue = null;
            for (String key : argKeys) {
                log.debug((Object)("key: " + key));
                filterType = (String)FILTER_NAMES.get(key.toLowerCase());
                log.debug((Object)("filter name: " + filterType));
                if (!StringUtils.isNotBlank((String)filterType)) continue;
                filterValue = this.getArgMap().get(key);
                if (StringUtils.isNotBlank((String)filterValue)) {
                    log.debug((Object)("create filter[" + filterType + "]: " + filterValue));
                    filter = new SubmissionFilter();
                    filter.setType(SubmissionFilterType.fromValue((String)filterType));
                    filter.setValue(filterValue);
                    filters.add(filter);
                    continue;
                }
                log.error((Object)("no value for filter name: " + filterType));
            }
            log.debug((Object)("filter count: " + request.getSubmissionFilter().size()));
            for (SubmissionFilter submissionFilter : request.getSubmissionFilter()) {
                log.debug((Object)("\n-filter: " + ToStringBuilder.reflectionToString((Object)submissionFilter)));
            }
            GetSubmissionListAsThirdPartyResponse response = port.getSubmissionListAsThirdParty(request);
            log.debug((Object)("available submission count: " + response.getAvailableApplicationNumber()));
            List list = response.getSubmissionDetails();
            this.printList(list);
            this.printListConcise(list);
            log.debug((Object)("Total Available submission Count: " + response.getAvailableApplicationNumber()));
        }
        catch (Exception e) {
            log.error((Object)("Exception: " + e.getMessage()));
            e.printStackTrace();
            throw e;
        }
    }

    public void printList(List<SubmissionDetails> list) {
        if (list == null || list.size() == 0) {
            log.debug((Object)"Submission list is empty.");
            return;
        }
        log.debug((Object)("Received " + list.size() + " submissions in list"));
        for (SubmissionDetails details : list) {
            log.debug((Object)"\n\n");
            log.debug((Object)ToStringBuilder.reflectionToString((Object)details));
            log.debug((Object)"\n\n");
        }
    }

    public void printListConcise(List<SubmissionDetails> list) {
        if (list == null || list.size() == 0) {
            log.debug((Object)"Submission list is empty.");
            return;
        }
        log.debug((Object)("Received " + list.size() + " submissions in list"));
        StringBuilder sb = new StringBuilder().append("\n");
        int count = 0;
        for (SubmissionDetails details : list) {
            log.debug((Object)("details: " + ToStringBuilder.reflectionToString((Object)details)));
            sb.append("Submission list element ").append(++count).append(": ").append(details.getGrantsGovTrackingNumber()).append("--- PackageID: ").append(details.getPackageID()).append("--- Status: ").append(details.getGrantsGovApplicationStatus()).append("\n");
        }
        log.debug((Object)sb.toString());
    }
}

