/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.apply.applicant.v2;

import gov.grants.apply.applicant.v2.BaseApplicantClient;
import gov.grants.apply.services.applicantwebservices_v2.ApplicantWebServicesPortType;
import gov.grants.apply.services.applicantwebservices_v2.GetOpportunityListRequest;
import gov.grants.apply.services.applicantwebservices_v2.GetOpportunityListResponse;
import gov.grants.apply.system.applicantcommonelements_v1.CFDADetails;
import gov.grants.apply.system.applicantcommonelements_v1.OpportunityDetails;
import gov.grants.apply.system.applicantcommonelements_v1.OpportunityFilter;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;

public class GetOpportunityListClient
extends BaseApplicantClient {
    private static final String CLASSNAME = GetOpportunityListClient.class.getSimpleName();
    private static final Logger log = Logger.getLogger((String)CLASSNAME);

    public static void main(String[] args) {
        log.debug((Object)("Begin " + CLASSNAME));
        try {
            GetOpportunityListClient client = new GetOpportunityListClient();
            log.debug((Object)("args length: " + args.length));
            client.init(args);
            client.makeServiceCall();
            log.debug((Object)("\n\nSUCCESS: " + CLASSNAME + " successfully completed"));
        }
        catch (Exception e) {
            log.error((Object)("\n\nException: " + e.getMessage()));
        }
    }

    public void makeServiceCall() throws Exception {
        try {
            GetOpportunityListResponse response;
            List oppDetailsList;
            String cfdaNum = this.getArgMap().get("cfdanumber");
            log.debug((Object)("Cfda Number: " + cfdaNum));
            String oppNum = this.getArgMap().get("opportunitynumber");
            log.debug((Object)("Opportunity Number: " + oppNum));
            String compId = this.getArgMap().get("competitionid");
            log.debug((Object)("Competition ID: " + compId));
            String pkgId = this.getArgMap().get("packageid");
            log.debug((Object)("Package ID: " + pkgId));
            ApplicantWebServicesPortType port = this.getApplicantPort();
            GetOpportunityListRequest request = new GetOpportunityListRequest();
            if (StringUtils.isNotEmpty((String)pkgId)) {
                request.setPackageID(pkgId);
            }
            if (StringUtils.isNotEmpty((String)cfdaNum) || StringUtils.isNotEmpty((String)compId) || StringUtils.isNotEmpty((String)oppNum)) {
                OpportunityFilter oppFilter = new OpportunityFilter();
                oppFilter.setCFDANumber(cfdaNum);
                oppFilter.setCompetitionID(compId);
                oppFilter.setFundingOpportunityNumber(oppNum);
                request.setOpportunityFilter(oppFilter);
            }
            if ((oppDetailsList = (response = port.getOpportunityList(request)).getOpportunityDetails()) != null && oppDetailsList.size() > 0) {
                StringBuilder sb = new StringBuilder();
                for (OpportunityDetails oppDetails : oppDetailsList) {
                    sb.append("\n");
                    log.debug((Object)ToStringBuilder.reflectionToString((Object)oppDetails));
                    sb.append("\nFunding Opportunity Number: ").append(oppDetails.getFundingOpportunityNumber());
                    byte[] bytes = StringUtils.defaultString((String)oppDetails.getFundingOpportunityTitle()).getBytes("UTF-8");
                    sb.append("\nFunding Opportunity Title: ").append(new String(bytes, "UTF-8"));
                    sb.append("\nPackage ID: ").append(oppDetails.getPackageID());
                    sb.append("\nCompetition ID: ").append(oppDetails.getCompetitionID());
                    sb.append("\nCompetition Title: ").append(oppDetails.getCompetitionTitle());
                    sb.append("\nSchema URL: ").append(oppDetails.getSchemaURL());
                    sb.append("\nInstruction URL: ").append(oppDetails.getInstructionsURL());
                    sb.append("\nOffering Agency: ").append(oppDetails.getOfferingAgency());
                    bytes = StringUtils.defaultString((String)oppDetails.getAgencyContactInfo()).getBytes("UTF-8");
                    sb.append("\nAgency Contact: ").append(new String(bytes, "UTF-8"));
                    sb.append("\nIs Multi-Project: ").append(oppDetails.isIsMultiProject());
                    sb.append("\nOpening Date: ");
                    log.debug((Object)("OpeningDate: " + oppDetails.getOpeningDate()));
                    if (oppDetails.getOpeningDate() != null) {
                        sb.append(GetOpportunityListClient.formatDate(oppDetails.getOpeningDate().toGregorianCalendar().getTime(), "MM/dd/yyyy"));
                    }
                    sb.append("\nClosing Date: ");
                    log.debug((Object)("OpeningDate: " + oppDetails.getOpeningDate()));
                    if (oppDetails.getClosingDate() != null) {
                        sb.append(GetOpportunityListClient.formatDate(oppDetails.getClosingDate().toGregorianCalendar().getTime(), "MM/dd/yyyy"));
                    }
                    if (oppDetails.getCFDADetails() != null && oppDetails.getCFDADetails().size() > 0) {
                        sb.append("\n****Total CFDA Numbers belongs to this opportunity =" + oppDetails.getCFDADetails().size());
                        for (int i = 0; i < oppDetails.getCFDADetails().size(); ++i) {
                            CFDADetails cfda = (CFDADetails)oppDetails.getCFDADetails().get(i);
                            sb.append("\n----------------------------------");
                            sb.append("\n--- CFDA Number: ").append(cfda.getNumber());
                            bytes = StringUtils.defaultString((String)cfda.getTitle()).getBytes("UTF-8");
                            sb.append("\n--- CFDA Title: ").append(new String(bytes, "UTF-8"));
                            sb.append("\n----------------------------------");
                        }
                    } else {
                        sb.append("\n****No CFDA Numbers belongs to this opportunity!");
                    }
                    sb.append("\n**************************************************");
                    sb.append("\n\n");
                    log.debug((Object)sb);
                    sb.setLength(0);
                    log.debug((Object)("Total opportunity count found: " + oppDetailsList.size()));
                }
            } else {
                log.debug((Object)"No opportunities found matching the input filters!");
            }
        }
        catch (Exception e) {
            log.error((Object)("Exception: " + e.getMessage()));
            e.printStackTrace();
            throw e;
        }
    }
}

