/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.apply.applicant.v2;

import com.sun.xml.ws.developer.StreamingDataHandler;
import gov.grants.apply.applicant.v2.BaseApplicantClient;
import gov.grants.apply.services.applicantwebservices_v2.ApplicantWebServicesPortType;
import gov.grants.apply.services.applicantwebservices_v2.GetApplicationZipRequest;
import gov.grants.apply.services.applicantwebservices_v2.GetApplicationZipResponse;
import gov.grants.commons.s2s.util.SoapUtil;
import java.io.File;
import org.apache.log4j.Logger;

public class GetApplicationZipClient
extends BaseApplicantClient {
    private static final String CLASSNAME = GetApplicationZipClient.class.getSimpleName();
    private static final Logger log = Logger.getLogger((String)CLASSNAME);
    private static final String FILE_EXT = ".zip";

    public static void main(String[] args) {
        log.debug((Object)("Begin " + CLASSNAME));
        try {
            GetApplicationZipClient client = new GetApplicationZipClient();
            log.debug((Object)("args length: " + args.length));
            client.init(args);
            client.makeServiceCall();
            log.debug((Object)("\n\nSUCCESS: " + CLASSNAME + " successfully completed"));
        }
        catch (Exception e) {
            log.error((Object)("\n\nTEST FAILED - Exception: " + e.getMessage()));
        }
    }

    public void makeServiceCall() throws Exception {
        try {
            String trackingNum = this.getArgMap().get("gg_tracking_num");
            log.debug((Object)("trackingNum: " + trackingNum));
            String downloadDir = SoapUtil.getProperty((String)"DOWNLOAD_DIR");
            log.debug((Object)("downloadDir: " + downloadDir));
            String appDownloadDir = downloadDir + "/" + trackingNum;
            File dir = new File(appDownloadDir);
            if (!dir.exists() && !dir.mkdirs()) {
                log.error((Object)("Could not create dir: " + appDownloadDir));
                throw new Exception("Could not create dir: " + appDownloadDir);
            }
            log.debug((Object)("created dir: " + appDownloadDir));
            ApplicantWebServicesPortType port = this.getApplicantPort();
            GetApplicationZipRequest request = new GetApplicationZipRequest();
            request.setGrantsGovTrackingNumber(trackingNum);
            log.debug((Object)"Make service call");
            GetApplicationZipResponse response = port.getApplicationZip(request);
            log.debug((Object)"Now Streaming Binary Data of the ZIP file to the Client from the Server");
            File f = new File(appDownloadDir + "/" + trackingNum + FILE_EXT);
            StreamingDataHandler dh = (StreamingDataHandler)response.getFileDataHandler();
            log.debug((Object)"dh.moveTo()");
            dh.moveTo(f);
            log.debug((Object)"dh.close()");
            dh.close();
        }
        catch (Exception e) {
            log.error((Object)("Exception: " + e.getMessage()));
            e.printStackTrace();
            throw e;
        }
    }
}

