/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.apply.applicant.v2;

import gov.grants.apply.applicant.v2.BaseApplicantClient;
import gov.grants.apply.services.applicantwebservices_v2.ApplicantWebServicesPortType;
import gov.grants.apply.services.applicantwebservices_v2.GetApplicationInfoAsThirdPartyRequest;
import gov.grants.apply.services.applicantwebservices_v2.GetApplicationInfoAsThirdPartyResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class GetApplicationInfoAsThirdPartyClient
extends BaseApplicantClient {
    private static final String CLASSNAME = GetApplicationInfoAsThirdPartyClient.class.getSimpleName();
    private static final Logger log = Logger.getLogger((String)CLASSNAME);

    public static void main(String[] args) {
        log.debug((Object)("Begin " + CLASSNAME));
        try {
            GetApplicationInfoAsThirdPartyClient client = new GetApplicationInfoAsThirdPartyClient();
            log.debug((Object)("args length: " + args.length));
            client.init(args);
            client.makeServiceCall();
            log.debug((Object)("\n\nSUCCESS: " + CLASSNAME + " successfully completed"));
        }
        catch (Exception e) {
            log.error((Object)("\n\nException: " + e.getMessage()));
        }
    }

    public void makeServiceCall() throws Exception {
        try {
            String ggTrackingNum = this.getArgMap().get("gg_tracking_num");
            if (StringUtils.isBlank((String)ggTrackingNum)) {
                throw new Exception("gg_tracking_num is missing from command line");
            }
            log.debug((Object)("gg_tracking_num: " + ggTrackingNum));
            ApplicantWebServicesPortType port = this.getApplicantPort();
            log.debug((Object)("port: " + port));
            GetApplicationInfoAsThirdPartyRequest request = new GetApplicationInfoAsThirdPartyRequest();
            request.setGrantsGovTrackingNumber(ggTrackingNum);
            log.debug((Object)"make service call");
            GetApplicationInfoAsThirdPartyResponse response = port.getApplicationInfoAsThirdParty(request);
            log.debug((Object)("Get application info response recieved is: " + response.toString()));
            log.debug((Object)"**********************");
            log.debug((Object)("Tracking Number: " + response.getGrantsGovTrackingNumber()));
            log.debug((Object)("Status detail: " + response.getStatusDetail()));
            log.debug((Object)("Agency Notes: " + response.getAgencyNotes()));
            log.debug((Object)("Agency Tracking Number: " + response.getAgencyTrackingNumber()));
            log.debug((Object)"**********************");
        }
        catch (Exception e) {
            log.error((Object)("Exception: " + e.getMessage()));
            e.printStackTrace();
            throw e;
        }
    }
}

