/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.apply.applicant.v2;

import com.ximpleware.AutoPilot;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import com.ximpleware.XMLModifier;
import gov.grants.apply.applicant.v2.BaseApplicantClient;
import gov.grants.apply.support.bizobj.SubmissionXml;
import gov.grants.commons.s2s.util.GrantApplicationHash;
import gov.grants.commons.util.FileUtil;
import gov.grants.commons.util.XMLHashUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CreateMultiProjectSubmissionXml
extends BaseApplicantClient {
    private static final String CLASSNAME = CreateMultiProjectSubmissionXml.class.getSimpleName();
    private static final Logger log = Logger.getLogger((String)CLASSNAME);
    private static final String MP_SCHEMA_NS_PREFIX = "mpgrant";
    private static final String MP_SCHEMA_NS_URI = "http://apply.grants.gov/system/MetaMultiGrantApplication";
    private static final String SCHEMA_VERSION_ATTR = " glob:schemaVersion=\"1.0\"";
    private static final String APPLICATION_HEADER_ELEMENT_LOCAL_PART = "ApplicationHeader";
    private static final String APPLICATION_HEADER_ELEMENT_NAME = "mpgrant:ApplicationHeader";
    private static final String APPLICATION_PKG_ELEMENT_LOCAL_PART = "ApplicationPackage";
    private static final String APPLICATION_PKG_ELEMENT_NAME = "mpgrant:ApplicationPackage";
    private static final String OVERALL_APPLICATION_HEADER_ELEMENT_LOCAL_PART = "OverallApplicationHeader";
    public static final String SUB_APPLICATION_GROUP_ELEMENT_LOCAL_PART = "SubApplicationGroup";
    public static final String SUB_APPLICATION_GROUP_HEADER_ELEMENT_LOCAL_PART = "SubApplicationGroupHeader";
    public static final String SUB_APPLICATION_GROUP_ID_ELEMENT_LOCAL_PART = "SubApplicationGroupID";
    public static final String SUB_APPLICATION_ELEMENT_LOCAL_PART = "SubApplication";
    public static final String SUB_APPLICATION_HEADER_ELEMENT_LOCAL_PART = "SubApplicationHeader";
    public static final String SUB_APPLICATION_ID_ELEMENT_LOCAL_PART = "SubApplicationID";
    Map<String, String> defaultNsPrefixMap;
    private Map<String, String> schemaImportMap;
    private Map<String, String> schemaNsPrefixMap;
    private static boolean REMOVE_WHITESPACE_BETWEEN_TAGS = false;
    private static final String CID_PREFIX = "cid:";
    private int cidCount = 0;
    private Map<String, String> attCidFileNameMap = new HashMap<String, String>();
    private VTDNav mpVN;
    private VTDNav overallVN;
    private VTDNav sagVN;

    public static void main(String[] args) {
        log.debug((Object)("Begin " + CLASSNAME));
        try {
            CreateMultiProjectSubmissionXml client = new CreateMultiProjectSubmissionXml();
            log.debug((Object)("args length: " + args.length));
            client.init(args);
            client.createMPXml();
            log.debug((Object)("\n\nSUCCESS: " + CLASSNAME + " successfully completed"));
        }
        catch (Exception e) {
            log.error((Object)("\n\nException: " + e.getMessage()));
        }
    }

    public void createMPXml() throws Exception {
        try {
            String configXml = this.getArgMap().get("config_xml");
            this.loadConfigXmlDoc(configXml);
            log.debug((Object)("find element: " + CLASSNAME));
            this.configVN.toElement(2, CLASSNAME);
            this.configVN.toElement(2, "compress-xml");
            log.debug((Object)(this.configVN.toNormalizedString(this.configVN.getCurrentIndex()) + " @ index " + this.configVN.getCurrentIndex()));
            REMOVE_WHITESPACE_BETWEEN_TAGS = Boolean.parseBoolean(this.configVN.toNormalizedString(this.configVN.getText()));
            log.debug((Object)("REMOVE_WHITESPACE_BETWEEN_TAGS: " + REMOVE_WHITESPACE_BETWEEN_TAGS));
            this.configVN.toElement(1);
            this.configVN.toElement(2, "mp-schema-url");
            log.debug((Object)(this.configVN.toNormalizedString(this.configVN.getCurrentIndex()) + " @ index " + this.configVN.getCurrentIndex()));
            String mpSchemaUrl = this.configVN.toNormalizedString(this.configVN.getText());
            log.debug((Object)("mp schema url: " + mpSchemaUrl));
            this.configVN.toElement(1);
            this.configVN.toElement(2, "mp-template-dir");
            log.debug((Object)(this.configVN.toNormalizedString(this.configVN.getCurrentIndex()) + " @ index " + this.configVN.getCurrentIndex()));
            String mpTemplateDir = this.configVN.toNormalizedString(this.configVN.getText());
            log.debug((Object)("mp template dir: " + mpTemplateDir));
            this.parseSchema(mpSchemaUrl, mpTemplateDir);
            this.configVN.toElement(1);
            this.configVN.toElement(2, "mp-template-xml");
            log.debug((Object)(this.configVN.toNormalizedString(this.configVN.getCurrentIndex()) + " @ index " + this.configVN.getCurrentIndex()));
            String mpTemplateXml = this.configVN.toNormalizedString(this.configVN.getText());
            log.debug((Object)("mp template xml: " + mpTemplateXml));
            log.debug((Object)"create mp VTDNav instance");
            this.mpVN = this.loadXmlDoc(mpTemplateDir + mpTemplateXml);
            XMLModifier xmMP = new XMLModifier();
            log.debug((Object)"bind to VTDNav");
            xmMP.bind(this.mpVN);
            log.debug((Object)"bound successfully");
            log.debug((Object)(this.mpVN.toNormalizedString(this.mpVN.getCurrentIndex()) + " @ index " + this.mpVN.getCurrentIndex()));
            xmMP.insertAttribute(this.addRootElementAttributes(mpSchemaUrl));
            log.debug((Object)"load overall xml");
            this.configVN.toElement(1);
            this.configVN.toElement(2, "overall");
            this.configVN.toElement(2, "overall-pkg-id");
            log.debug((Object)(this.configVN.toNormalizedString(this.configVN.getCurrentIndex()) + " @ index " + this.configVN.getCurrentIndex()));
            String overallPkgId = this.configVN.toNormalizedString(this.configVN.getText());
            log.debug((Object)("overall pkg ID: " + overallPkgId));
            this.configVN.toElement(1);
            this.configVN.toElement(2, "submission-dir");
            log.debug((Object)(this.configVN.toNormalizedString(this.configVN.getCurrentIndex()) + " @ index " + this.configVN.getCurrentIndex()));
            String overallSubDir = this.configVN.toNormalizedString(this.configVN.getText());
            log.debug((Object)("overall sub dir: " + overallSubDir));
            this.configVN.toElement(1);
            this.configVN.toElement(2, "submission-xml");
            log.debug((Object)(this.configVN.toNormalizedString(this.configVN.getCurrentIndex()) + " @ index " + this.configVN.getCurrentIndex()));
            String overallSubXml = this.configVN.toNormalizedString(this.configVN.getText());
            log.debug((Object)("overall sub xml: " + overallSubXml));
            this.overallVN = this.loadXmlDoc(overallSubDir + overallSubXml);
            xmMP.insertAfterHead(this.createApplicationHeaderElement(this.overallVN));
            this.commitMPXmlUpdates(xmMP);
            this.mpVN.toElement(2, APPLICATION_HEADER_ELEMENT_NAME);
            log.debug((Object)("MP VTDNav pos:" + this.mpVN.toNormalizedString(this.mpVN.getCurrentIndex()) + " @ index " + this.mpVN.getCurrentIndex()));
            xmMP.insertAfterElement(this.createApplicationPackageElement());
            this.commitMPXmlUpdates(xmMP);
            this.mpVN.toElement(2, APPLICATION_PKG_ELEMENT_NAME);
            log.debug((Object)("MP VTDNav pos:" + this.mpVN.toNormalizedString(this.mpVN.getCurrentIndex()) + " @ index " + this.mpVN.getCurrentIndex()));
            xmMP.insertAfterHead(this.createOverallApplicationElement(this.overallVN, overallPkgId, overallSubDir));
            this.commitMPXmlUpdates(xmMP);
            AutoPilot ap = new AutoPilot(this.configVN);
            String xpath = "//sub-application-group";
            ap.selectXPath(xpath);
            int i = -1;
            String groupName = null;
            String iterations = null;
            String submissionDir = null;
            String submissionXml = null;
            StringBuilder sapXml = new StringBuilder();
            int count = 0;
            while ((i = ap.evalXPath()) > -1) {
                ++count;
                log.debug((Object)(this.configVN.toNormalizedString(this.configVN.getCurrentIndex()) + " @ index " + this.configVN.getCurrentIndex()));
                this.configVN.toElement(2, "group-name");
                groupName = this.configVN.toNormalizedString(this.configVN.getText());
                log.debug((Object)("groupName: " + groupName));
                this.configVN.toElement(1);
                this.configVN.toElement(2, "iterations");
                iterations = this.configVN.toNormalizedString(this.configVN.getText());
                log.debug((Object)("iterations: " + iterations));
                this.configVN.toElement(1);
                this.configVN.toElement(2, "submission-dir");
                submissionDir = this.configVN.toNormalizedString(this.configVN.getText());
                log.debug((Object)("submissionDir: " + submissionDir));
                this.configVN.toElement(1);
                this.configVN.toElement(2, "submission-xml");
                submissionXml = this.configVN.toNormalizedString(this.configVN.getText());
                log.debug((Object)("submissionXml: " + submissionXml));
                this.sagVN = this.loadXmlDoc(submissionDir + submissionXml);
                sapXml.append(this.createSubApplicationElement(groupName, submissionDir, Integer.parseInt(iterations)));
                this.configVN.toElement(1);
            }
            log.debug((Object)"add sub-application elements to MP XML");
            log.debug((Object)("MP VTDNav pos:" + this.mpVN.toNormalizedString(this.mpVN.getCurrentIndex()) + " @ index " + this.mpVN.getCurrentIndex()));
            this.mpVN.toElement(0);
            this.mpVN.toElement(2, APPLICATION_PKG_ELEMENT_NAME);
            this.mpVN.toElement(2);
            log.debug((Object)("MP VTDNav pos:" + this.mpVN.toNormalizedString(this.mpVN.getCurrentIndex()) + " @ index " + this.mpVN.getCurrentIndex()));
            xmMP.insertAfterElement(sapXml.toString());
            log.debug((Object)"commit changes to MP XML");
            this.commitMPXmlUpdates(xmMP);
            this.mpVN = xmMP.outputAndReparse();
            xmMP.bind(this.mpVN);
            this.updateMPXmlHashValue(xmMP);
            log.debug((Object)"===== write Multi-Project XML to disk =====");
            xmMP.output(mpTemplateDir + "mpSubXml.xml");
            this.generateConfig(mpTemplateDir, "mpSubXml.xml");
        }
        catch (Exception e) {
            log.error((Object)("Exception: " + e.getMessage()));
            e.printStackTrace();
            throw e;
        }
    }

    private void generateConfig(String submissionDir, String xmlFileName) throws Exception {
        try {
            StringBuilder attConfigXml = new StringBuilder();
            ArrayList<String> cidList = new ArrayList<String>(this.attCidFileNameMap.keySet());
            Collections.sort(cidList);
            for (String cid : cidList) {
                attConfigXml.append("\n\t\t").append("<attachment>").append("\n\t\t\t").append("<file-name>").append(this.attCidFileNameMap.get(cid)).append("</file-name>").append("\n\t\t\t").append("<cid>").append(cid).append("</cid>").append("\n\t\t").append("</attachment>");
            }
            StringBuilder submitAppXml = new StringBuilder();
            submitAppXml.append("<generated-applicant-config>").append("\n\t").append("<SubmitApplicationClient>").append("\n\t\t").append("<submission-dir>").append(submissionDir).append("</submission-dir>").append("\n\t\t").append("<submission-xml>").append(xmlFileName).append("</submission-xml>").append((CharSequence)attConfigXml).append("\n\t").append("</SubmitApplicationClient>");
            submitAppXml.append("\n\n\t").append("<SubmitApplicationAsThirdPartyClient>").append("\n\t\t").append("<aor-user-id>").append("aorUserId").append("</aor-user-id>").append("\n\t\t").append("<aor-password>").append("aorPassword").append("</aor-password>").append("\n\t\t").append("<submission-dir>").append(submissionDir).append("</submission-dir>").append("\n\t\t").append("<submission-xml>").append(xmlFileName).append("</submission-xml>").append((CharSequence)attConfigXml).append("\n\t").append("</SubmitApplicationAsThirdPartyClient>").append("\n").append("</generated-applicant-config>");
            FileUtil.bytesToDisk((byte[])submitAppXml.toString().getBytes(), (String)(submissionDir + "generated-applicant-config.xml"));
        }
        catch (Exception e) {
            log.error((Object)("Exception: " + e.getMessage()));
            log.error((Object)("Exception cause: " + e.getCause()));
            throw e;
        }
    }

    private void updateMPXmlHashValue(XMLModifier xm) throws Exception {
        block5: {
            try {
                SubmissionXml subXml = new SubmissionXml(this.mpVN);
                String updatedHash = subXml.createSubmissionXmlHashValue();
                log.debug((Object)("updated xml hash value: " + updatedHash));
                String currentHash = subXml.getSubmittedXmlHashValue();
                log.debug((Object)("submitted xml hash value: " + currentHash));
                this.mpVN.toElement(0);
                if (subXml.isMultiProject()) {
                    this.mpVN.toElement(2);
                }
                int beginIndex = this.getElementIndex(this.mpVN, "GrantSubmissionHeader", 0, 0);
                log.debug((Object)("begin index: " + beginIndex));
                int endIndex = this.getElementIndex(this.mpVN, APPLICATION_PKG_ELEMENT_LOCAL_PART, beginIndex, 0);
                log.debug((Object)("end index: " + endIndex));
                String headerElement = this.mpVN.toNormalizedString(beginIndex);
                log.debug((Object)("header element: " + headerElement));
                this.mpVN.toElement(2, headerElement);
                log.debug((Object)(this.mpVN.toNormalizedString(this.mpVN.getCurrentIndex()) + " @ index: " + this.mpVN.getCurrentIndex()));
                int index = this.getElementIndex(this.mpVN, "HashValue", beginIndex, endIndex);
                log.debug((Object)("hash element index: " + index));
                if (index > -1) {
                    this.mpVN.toElement(2, this.mpVN.toNormalizedString(index));
                    log.debug((Object)("hash: " + this.mpVN.toNormalizedString(this.mpVN.getCurrentIndex()) + " @ index: " + this.mpVN.getCurrentIndex()));
                    if (this.mpVN.getText() > -1) {
                        log.debug((Object)("update hash value: " + updatedHash));
                        xm.updateToken(this.mpVN.getText(), updatedHash);
                    }
                    break block5;
                }
                String s = "HashValue element not found";
                log.error((Object)s);
                throw new Exception(s);
            }
            catch (Exception e) {
                log.error((Object)("Exception: " + e.getMessage()));
                log.error((Object)("Exception cause: " + e.getCause()));
                throw e;
            }
        }
    }

    private String createSubApplicationElement(String pkgId, String submissionDir, int iterations) {
        StringBuilder sagNsAttr = new StringBuilder();
        sagNsAttr.append(" xmlns:").append(pkgId).append("=\"").append(this.schemaNsPrefixMap.get("xmlns:" + pkgId)).append("\"");
        StringBuilder sagElement = new StringBuilder();
        log.debug((Object)("sub-application group ID: " + pkgId));
        try {
            sagElement.append("<").append(pkgId).append(":").append(SUB_APPLICATION_GROUP_ELEMENT_LOCAL_PART).append((CharSequence)sagNsAttr).append(">");
            sagElement.append("<").append(pkgId).append(":").append(SUB_APPLICATION_GROUP_HEADER_ELEMENT_LOCAL_PART).append((CharSequence)sagNsAttr).append(">");
            sagElement.append("<").append(pkgId).append(":").append(SUB_APPLICATION_GROUP_ID_ELEMENT_LOCAL_PART).append((CharSequence)sagNsAttr).append(">");
            sagElement.append(pkgId);
            sagElement.append("</").append(pkgId).append(":").append(SUB_APPLICATION_GROUP_ID_ELEMENT_LOCAL_PART).append(">");
            sagElement.append("</").append(pkgId).append(":").append(SUB_APPLICATION_GROUP_HEADER_ELEMENT_LOCAL_PART).append(">");
            for (int i = 1; i <= iterations; ++i) {
                sagElement.append("<").append(pkgId).append(":").append(SUB_APPLICATION_ELEMENT_LOCAL_PART).append((CharSequence)sagNsAttr).append(">");
                sagElement.append("<").append(pkgId).append(":").append(SUB_APPLICATION_HEADER_ELEMENT_LOCAL_PART).append((CharSequence)sagNsAttr).append(">");
                sagElement.append("<").append(pkgId).append(":").append(SUB_APPLICATION_ID_ELEMENT_LOCAL_PART).append((CharSequence)sagNsAttr).append(">");
                sagElement.append(i);
                sagElement.append("</").append(pkgId).append(":").append(SUB_APPLICATION_ID_ELEMENT_LOCAL_PART).append(">");
                sagElement.append("</").append(pkgId).append(":").append(SUB_APPLICATION_HEADER_ELEMENT_LOCAL_PART).append(">");
                this.sagVN.toElement(0);
                long k = this.sagVN.getElementFragment();
                String xml = this.sagVN.toRawString((int)k, (int)(k >> 32));
                sagElement.append(this.modifySingleProjXml(xml, pkgId, submissionDir, REMOVE_WHITESPACE_BETWEEN_TAGS));
                sagElement.append("</").append(pkgId).append(":").append(SUB_APPLICATION_ELEMENT_LOCAL_PART).append(">");
            }
            sagElement.append("</").append(pkgId).append(":").append(SUB_APPLICATION_GROUP_ELEMENT_LOCAL_PART).append(">");
        }
        catch (Exception e) {
            log.error((Object)("Exception: " + e.getMessage()));
            log.error((Object)("Exception cause: " + e.getCause()));
        }
        return sagElement.toString();
    }

    private String createOverallApplicationElement(VTDNav vnOverall, String overallPkgId, String submissionDir) {
        StringBuilder overallNsAttr = new StringBuilder();
        overallNsAttr.append(" xmlns:").append(overallPkgId).append("=\"").append(this.schemaNsPrefixMap.get("xmlns:" + overallPkgId)).append("\"");
        StringBuilder overallElement = new StringBuilder();
        try {
            overallElement.append("<").append(overallPkgId).append(":").append("OverallApplication").append((CharSequence)overallNsAttr).append(">");
            overallElement.append("<").append(overallPkgId).append(":").append(OVERALL_APPLICATION_HEADER_ELEMENT_LOCAL_PART).append((CharSequence)overallNsAttr).append(">");
            overallElement.append("<").append(overallPkgId).append(":").append("OverallApplicationID").append((CharSequence)overallNsAttr).append(">");
            overallElement.append(overallPkgId);
            overallElement.append("</").append(overallPkgId).append(":").append("OverallApplicationID").append(">");
            overallElement.append("</").append(overallPkgId).append(":").append(OVERALL_APPLICATION_HEADER_ELEMENT_LOCAL_PART).append(">");
            vnOverall.toElement(0);
            long k = vnOverall.getElementFragment();
            String xml = vnOverall.toRawString((int)k, (int)(k >> 32));
            overallElement.append(this.modifySingleProjXml(xml, overallPkgId, submissionDir, REMOVE_WHITESPACE_BETWEEN_TAGS));
            overallElement.append("</").append(overallPkgId).append(":").append("OverallApplication").append(">");
        }
        catch (Exception e) {
            log.error((Object)("Exception: " + e.getMessage()));
            log.error((Object)("Exception cause: " + e.getCause()));
        }
        return overallElement.toString();
    }

    private String modifySingleProjXml(String spXml, String updatedNsPrefix, String submissionDir, boolean removeWhitespaceBetweenTags) throws Exception {
        String updatedXml = null;
        try {
            VTDGen vg = new VTDGen();
            vg.setDoc(spXml.getBytes());
            vg.parse(true);
            VTDNav vn = vg.getNav();
            XMLModifier xm = new XMLModifier();
            xm.bind(vn);
            log.debug((Object)"updated XML successfully parsed and bound");
            log.debug((Object)(vn.toNormalizedString(vn.getCurrentIndex()) + " @ index " + vn.getCurrentIndex()));
            vn.toElement(2);
            if (!vn.endsWith(vn.getCurrentIndex(), "GrantSubmissionHeader") || !vn.endsWith(vn.getCurrentIndex(), "Header_2_0")) {
                throw new Exception("GrantSubmissionHeader element is not found");
            }
            log.debug((Object)(vn.toNormalizedString(vn.getCurrentIndex()) + " @ index " + vn.getCurrentIndex()));
            xm.remove();
            vn = xm.outputAndReparse();
            xm.bind(vn);
            this.modifyAttachmentInfo(vn, xm, submissionDir);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            xm.output((OutputStream)baos);
            updatedXml = new String(baos.toByteArray());
            vg.setDoc(updatedXml.getBytes());
            vg.parse(false);
            vn = vg.getNav();
            xm.bind(vn);
            vn.toElement(0);
            log.debug((Object)(vn.toNormalizedString(vn.getCurrentIndex()) + " @ index " + vn.getCurrentIndex()));
            String rootElementName = vn.toNormalizedString(vn.getCurrentIndex());
            log.debug((Object)("rootElementName: " + rootElementName));
            String rootNsPrefix = rootElementName.substring(0, rootElementName.indexOf(":"));
            log.debug((Object)("rootNsPrefix: " + rootNsPrefix));
            int beginIndex = vn.getCurrentIndex() + 1;
            vn.toElement(2);
            int endIndex = vn.getCurrentIndex();
            vn.toElement(1);
            Map<String, String> attrMap = this.getAttributeMap(vn, beginIndex, endIndex);
            vn.toElement(0);
            vn.toElement(2);
            log.debug((Object)(vn.toNormalizedString(vn.getCurrentIndex()) + " @ index " + vn.getCurrentIndex()));
            String formsElementName = vn.toNormalizedString(vn.getCurrentIndex());
            log.debug((Object)("formsElementName: " + formsElementName));
            String updatedFormsElementName = updatedNsPrefix + formsElementName.substring(formsElementName.indexOf(":"));
            log.debug((Object)("updatedFormsElementName: " + updatedFormsElementName));
            xm.updateElementName(updatedFormsElementName);
            vn = xm.outputAndReparse();
            xm.bind(vn);
            vn.toElement(0);
            vn.toElement(2);
            log.debug((Object)("extract 'Forms' element: " + vn.toNormalizedString(vn.getCurrentIndex()) + " @ index " + vn.getCurrentIndex()));
            long k = vn.getElementFragment();
            String formsElement = vn.toRawString((int)k, (int)(k >> 32));
            if (StringUtils.isBlank((String)formsElement)) {
                String s = "Forms element is blank";
                log.error((Object)s);
                throw new Exception(s);
            }
            StringBuilder sb = new StringBuilder();
            sb.append("<").append(updatedNsPrefix).append(":").append("GrantApplication");
            Set<String> attrNames = attrMap.keySet();
            for (String attrName : attrNames) {
                log.debug((Object)("attr name: " + attrName));
                if (attrName.endsWith("schemaLocation") || attrName.endsWith("xsi") || attrName.endsWith(rootNsPrefix)) continue;
                sb.append(" ").append(attrName).append("=\"").append(attrMap.get(attrName)).append("\"");
            }
            sb.append(" xmlns:").append(updatedNsPrefix).append("=\"").append(this.schemaNsPrefixMap.get("xmlns:" + updatedNsPrefix)).append("\"");
            sb.append(">");
            sb.append(formsElement);
            sb.append("</").append(updatedNsPrefix).append(":").append("GrantApplication").append(">");
            updatedXml = sb.toString();
            if (removeWhitespaceBetweenTags) {
                String regex = ">[\\s]+<";
                updatedXml = updatedXml.replaceAll(regex, "><");
            }
        }
        catch (Exception e) {
            log.error((Object)("Exception: " + e.getMessage()));
            log.error((Object)("Exception cause: " + e.getCause()));
            throw e;
        }
        return updatedXml;
    }

    private void modifyAttachmentInfo(VTDNav vn, XMLModifier xm, String attachmentDir) throws Exception {
        log.debug((Object)"modify attachment info");
        try {
            AutoPilot ap = new AutoPilot(vn);
            this.addAllNamespaces(ap, vn);
            String xpath = "//att:FileLocation";
            ap.selectXPath(xpath);
            boolean count = false;
            int i = -1;
            String currentCid = null;
            String updatedCid = null;
            String fileName = null;
            String currentAttHash = null;
            String updatedAttHash = null;
            while ((i = ap.evalXPath()) > -1) {
                ++this.cidCount;
                log.debug((Object)(vn.toNormalizedString(vn.getCurrentIndex()) + " @ index " + vn.getCurrentIndex()));
                currentCid = vn.toNormalizedString(vn.getAttrVal("att:href"));
                log.debug((Object)("current cid: " + currentCid));
                updatedCid = CID_PREFIX + StringUtils.leftPad((String)String.valueOf(this.cidCount), (int)4, (String)"0");
                log.debug((Object)("updated cid: " + updatedCid));
                xm.updateToken(vn.getAttrVal("att:href"), updatedCid);
                vn.toElement(1);
                vn.toElement(2, "att:FileName");
                fileName = vn.toNormalizedString(vn.getText());
                log.debug((Object)("file name: " + fileName));
                this.attCidFileNameMap.put(updatedCid, attachmentDir + fileName);
                vn.toElement(1);
                vn.toElement(2, "glob:HashValue");
                currentAttHash = vn.toNormalizedString(vn.getText());
                log.debug((Object)("current att hash: " + currentAttHash));
                updatedAttHash = this.createAttHashValue(attachmentDir + fileName);
                xm.updateToken(vn.getText(), updatedAttHash);
            }
            log.debug((Object)("attCidFileNameMap: " + this.attCidFileNameMap));
        }
        catch (Exception e) {
            log.error((Object)("Exception: " + e.getMessage()));
            log.error((Object)("Exception cause: " + e.getCause()));
            throw e;
        }
    }

    private void parseSchema(String schemaUrl, String outputDir) throws Exception {
        try {
            URL url = new URL(schemaUrl);
            log.debug((Object)("schema URL: " + url));
            InputStream in = url.openStream();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int BUF_SIZE = 1024;
            byte[] buffer = new byte[1024];
            int bytesRead = -1;
            while ((bytesRead = in.read(buffer)) > -1) {
                out.write(buffer, 0, bytesRead);
            }
            in.close();
            byte[] xsdBytes = out.toByteArray();
            FileUtil.bytesToDisk((byte[])xsdBytes, (String)(outputDir + "mpSchema.xsd"));
            VTDGen vg = new VTDGen();
            vg.setDoc_BR(xsdBytes);
            vg.parse(true);
            VTDNav vn = vg.getNav();
            vn.toElement(0);
            String nsUrl = null;
            String schemaLocation = null;
            this.schemaImportMap = new HashMap<String, String>();
            String importElement = vn.toNormalizedString(this.getElementIndex(vn, "import", vn.getCurrentIndex(), -1));
            log.debug((Object)("importElement: " + importElement));
            AutoPilot ap = new AutoPilot(vn);
            this.addAllNamespaces(ap, vn);
            String xpath = "//" + importElement;
            ap.selectXPath(xpath);
            int i = -1;
            while ((i = ap.evalXPath()) > -1) {
                log.debug((Object)(vn.toNormalizedString(vn.getCurrentIndex()) + " @ index " + vn.getCurrentIndex()));
                nsUrl = vn.toNormalizedString(vn.getAttrVal("namespace"));
                schemaLocation = vn.toNormalizedString(vn.getAttrVal("schemaLocation"));
                log.debug((Object)(nsUrl + " :: " + schemaLocation));
                this.schemaImportMap.put(nsUrl, schemaLocation);
            }
            log.debug((Object)("schemaImportMap: " + this.schemaImportMap));
            this.schemaNsPrefixMap = new HashMap<String, String>();
            vn.toElement(0);
            int beginIndex = vn.getCurrentIndex() + 1;
            vn.toElement(2);
            int endIndex = vn.getCurrentIndex();
            int attrCount = vn.getAttrCount();
            log.debug((Object)("schema attribute count: " + attrCount));
            Map<String, String> m = this.getAttributeMap(vn, beginIndex, endIndex);
            Set<String> nsPrefixes = m.keySet();
            String nsPrefixUrl = null;
            for (String nsPrefix : nsPrefixes) {
                nsUrl = m.get(nsPrefix);
                nsPrefixUrl = this.schemaImportMap.get(nsUrl);
                if (!StringUtils.isNotBlank((String)nsPrefixUrl)) continue;
                log.debug((Object)("adding: " + nsPrefix + " :: " + nsPrefixUrl));
                this.schemaNsPrefixMap.put(nsPrefix, nsUrl);
            }
            log.debug((Object)("nsPrefixMap: " + this.schemaNsPrefixMap));
        }
        catch (Exception e) {
            log.error((Object)("Exception: " + e.getMessage()));
            log.error((Object)("Exception cause: " + e.getCause()));
            throw e;
        }
    }

    public Map<String, String> getAttributeMap(VTDNav vn, int beginIndex, int endIndex) {
        log.debug((Object)("beginIndex: " + beginIndex));
        log.debug((Object)("endIndex: " + endIndex));
        HashMap<String, String> m = new HashMap<String, String>();
        try {
            String nsPrefix = null;
            String nsUrl = null;
            for (int i = beginIndex; i < endIndex; ++i) {
                String token = vn.toNormalizedString(i);
                log.debug((Object)("token: " + token));
                nsPrefix = token;
                nsUrl = vn.toNormalizedString(++i);
                m.put(nsPrefix, nsUrl);
            }
        }
        catch (Exception e) {
            log.error((Object)("Exception getting attributes: " + e.getMessage()));
        }
        log.debug((Object)("returning map: " + m));
        return m;
    }

    public void addAllNamespaces(AutoPilot ap, VTDNav vn) {
        try {
            int size = vn.getTokenCount();
            String nsPrefix = null;
            String nsUrl = null;
            for (int i = 0; i < size; ++i) {
                String token = vn.toNormalizedString(i);
                if (!vn.startsWith(i, "xmlns:")) continue;
                nsPrefix = token.substring(token.indexOf(":") + 1);
                nsUrl = vn.toNormalizedString(i + 1);
                ap.declareXPathNameSpace(nsPrefix, nsUrl);
            }
        }
        catch (Exception e) {
            log.error((Object)("Cannot add all namespaces: " + e.getMessage()));
        }
    }

    private void commitMPXmlUpdates(XMLModifier xm) throws Exception {
        try {
            this.mpVN = xm.outputAndReparse();
            xm.bind(this.mpVN);
        }
        catch (Exception e) {
            log.error((Object)("Exception: " + e.getMessage()));
            log.error((Object)("Exception cause: " + e.getCause()));
            throw e;
        }
    }

    private void commitSAPXmlUpdates(XMLModifier xm) throws Exception {
        try {
            this.sagVN = xm.outputAndReparse();
            xm.bind(this.sagVN);
        }
        catch (Exception e) {
            log.error((Object)("Exception: " + e.getMessage()));
            log.error((Object)("Exception cause: " + e.getCause()));
            throw e;
        }
    }

    private String createApplicationPackageElement() {
        StringBuilder sb = new StringBuilder();
        try {
            sb.append("<").append(MP_SCHEMA_NS_PREFIX).append(":").append(APPLICATION_PKG_ELEMENT_LOCAL_PART).append(">");
            sb.append("</").append(MP_SCHEMA_NS_PREFIX).append(":").append(APPLICATION_PKG_ELEMENT_LOCAL_PART).append(">");
        }
        catch (Exception e) {
            log.error((Object)("Exception: " + e.getMessage()));
            log.error((Object)("Exception cause: " + e.getCause()));
        }
        return sb.toString();
    }

    private String createApplicationHeaderElement(VTDNav vnOverall) {
        StringBuilder sb = new StringBuilder();
        try {
            sb.append("<").append(MP_SCHEMA_NS_PREFIX).append(":").append(APPLICATION_HEADER_ELEMENT_LOCAL_PART).append(SCHEMA_VERSION_ATTR).append(">");
            SubmissionXml subXml = new SubmissionXml(vnOverall);
            String headerXml = subXml.getHeaderXml(REMOVE_WHITESPACE_BETWEEN_TAGS);
            log.debug((Object)("header xml: " + headerXml));
            sb.append(headerXml);
            sb.append("</").append(MP_SCHEMA_NS_PREFIX).append(":").append(APPLICATION_HEADER_ELEMENT_LOCAL_PART).append(">");
        }
        catch (Exception e) {
            log.error((Object)("Exception: " + e.getMessage()));
            log.error((Object)("Exception cause: " + e.getCause()));
        }
        return sb.toString();
    }

    private String addRootElementAttributes(String mpSchemaUrl) {
        if (this.defaultNsPrefixMap == null) {
            log.debug((Object)"initialize defaultNsPrefixMap");
            this.defaultNsPrefixMap = new HashMap<String, String>();
            this.defaultNsPrefixMap.put("xmlns:mpgrant", MP_SCHEMA_NS_URI);
        }
        StringBuilder sb = new StringBuilder();
        try {
            Set<String> nsPrefixes = this.defaultNsPrefixMap.keySet();
            for (String nsPrefix : nsPrefixes) {
                sb.append(" ").append(nsPrefix).append("=\"").append(this.defaultNsPrefixMap.get(nsPrefix)).append("\"");
            }
            nsPrefixes = this.schemaNsPrefixMap.keySet();
            for (String nsPrefix : nsPrefixes) {
                if (!this.defaultNsPrefixMap.containsKey(nsPrefix)) {
                    sb.append(" ").append(nsPrefix).append("=\"").append(this.schemaNsPrefixMap.get(nsPrefix)).append("\"");
                    continue;
                }
                log.debug((Object)("skipping: " + nsPrefix + " :: " + this.schemaNsPrefixMap.get(nsPrefix)));
            }
            sb.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
            sb.append(this.createSchemaLocationAttr(MP_SCHEMA_NS_URI, mpSchemaUrl));
        }
        catch (Exception e) {
            log.error((Object)("Exception caught creating root element attributes: " + e.getMessage()));
            log.error((Object)("Exception cause: " + e.getCause()));
        }
        log.debug((Object)("root element attributes: " + sb));
        return sb.toString();
    }

    private String createSchemaLocationAttr(String schemaNs, String schemaUrl) {
        StringBuilder sb = new StringBuilder();
        sb.append(" xsi:schemaLocation=\"").append(schemaNs).append(" ").append(schemaUrl).append("\"");
        log.debug((Object)("returning schema location attr: " + sb));
        return sb.toString();
    }

    private String createSubmissionXmlHashValue(byte[] xmlBytes, boolean isMultiProject) throws Exception {
        try {
            String elementNsUri = null;
            String elementLocalPart = null;
            if (isMultiProject) {
                elementNsUri = MP_SCHEMA_NS_URI;
                elementLocalPart = APPLICATION_PKG_ELEMENT_LOCAL_PART;
            } else {
                elementNsUri = "http://apply.grants.gov/system/MetaGrantApplication";
                elementLocalPart = "Forms";
            }
            String calculatedHash = XMLHashUtil.createXmlHash((byte[])xmlBytes, (String)elementNsUri, (String)elementLocalPart);
            log.debug((Object)("returning calculated hash value: " + calculatedHash));
            return calculatedHash;
        }
        catch (Exception e) {
            String s = "Exception caught creating submission xml hash: " + e.getMessage();
            log.error((Object)s);
            throw new Exception(s);
        }
    }

    private int getElementIndex(VTDNav vNav, String localPart, int beginIndex, int endIndex) throws Exception {
        try {
            if (endIndex < 1) {
                endIndex = vNav.getTokenCount();
            }
            for (int i = beginIndex; i < endIndex; ++i) {
                String token = vNav.toNormalizedString(i);
                if (!vNav.endsWith(i, localPart)) continue;
                log.debug((Object)("token: " + token + " @ index: " + i));
                return i;
            }
            return -1;
        }
        catch (Exception e) {
            String s = "Exception getting element index: " + e.getMessage();
            log.error((Object)s);
            throw new Exception(s);
        }
    }

    private void backupXml(byte[] xmlBytes, String filePath) throws Exception {
        try {
            if (StringUtils.isBlank((String)filePath)) {
                String s = "File path cannot be blank";
                log.error((Object)s);
                throw new Exception(s);
            }
            if (xmlBytes == null || xmlBytes.length == 0) {
                String s = "XML is blank";
                log.error((Object)s);
                throw new Exception(s);
            }
            int index = filePath.lastIndexOf(".");
            String fileExt = filePath.substring(index);
            String filename = filePath.substring(0, index);
            String backupFileName = filename + "_orig" + fileExt;
            log.debug((Object)("backup file name: " + backupFileName));
            FileUtil.bytesToDisk((byte[])xmlBytes, (String)backupFileName);
        }
        catch (Exception e) {
            String s = "Exception caught backing up XML to disk: " + e.getMessage();
            log.error((Object)s);
            throw new Exception(s);
        }
    }

    public String createAttHashValue(String attFilePath) throws Exception {
        String attHashValue = null;
        try {
            File f = new File(attFilePath);
            if (!f.exists()) {
                String s = "Attachment was not written to disk: " + attFilePath;
                log.error((Object)s);
                throw new Exception(s);
            }
            log.debug((Object)"Create FileInputStream for attachment");
            FileInputStream fis = new FileInputStream(f);
            GrantApplicationHash gAppHash = new GrantApplicationHash();
            attHashValue = gAppHash.computeAttachmentHash((InputStream)fis);
            log.debug((Object)("attachment hash: " + attHashValue));
        }
        catch (Exception e) {
            String s = "Exception caught creating attachment hash: " + e.getMessage();
            log.error((Object)s);
            throw new Exception(s);
        }
        log.debug((Object)("created attachment hash value: " + attHashValue));
        return attHashValue;
    }
}

