/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.apply.applicant.v2;

import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import gov.grants.apply.applicant.v2.JAXWSTestHostnameVerifier;
import gov.grants.apply.services.applicantwebservices_v2.ApplicantWebServicesPortType;
import gov.grants.apply.services.applicantwebservices_v2.ApplicantWebServicesV20;
import gov.grants.commons.s2s.util.SoapUtil;
import gov.grants.commons.util.FileUtil;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.MTOMFeature;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;

public class BaseApplicantClient {
    public static final String MMddyyyy = "MM/dd/yyyy";
    public static final String yyyyMMddHHmmss = "yyyy-MM-dd HH:mm:ss";
    public static SimpleDateFormat SDF;
    protected VTDNav configVN;
    private static final Logger log;
    private Map<String, String> argMap = new HashMap<String, String>();
    private static final String TRUSTSTORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    private static final String TRUSTSTORE = "javax.net.ssl.trustStore";
    private static final String KEYSTORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    private static final String KEYSTORE = "javax.net.ssl.keyStore";
    private static final String CONFIG_PROPERTIES_FILE = "resources/applicant-s2s-config.properties";
    private static String SOAP_URL_PREFIX;
    private static final String SOAP_URL_SUFFIX = "/grantsws-applicant/services/v2/ApplicantWebServicesSoapPort";
    protected static Map<String, String> FILTER_NAMES;

    protected ApplicantWebServicesPortType getApplicantPort() throws Exception {
        log.debug((Object)"create Streaming applicant port");
        ApplicantWebServicesV20 service = new ApplicantWebServicesV20();
        log.debug((Object)("service URL: " + service.getWSDLDocumentLocation()));
        ApplicantWebServicesPortType port = service.getApplicantWebServicesSoapPort(new WebServiceFeature[]{new MTOMFeature(true)});
        BindingProvider bp = (BindingProvider)port;
        bp.getRequestContext().put("javax.xml.ws.service.endpoint.address", SOAP_URL_PREFIX + SOAP_URL_SUFFIX);
        bp.getRequestContext().put("com.sun.xml.ws.transport.http.client.streaming.chunk.size", 8192);
        log.debug((Object)("applicant integration port type: " + port));
        HttpsURLConnection.setDefaultHostnameVerifier(new JAXWSTestHostnameVerifier());
        log.debug((Object)"initialized: JAXWSTestHostnameVerifier");
        return port;
    }

    protected void init(String[] args) {
        try {
            int count = 0;
            String[] argList = null;
            for (String arg : args) {
                if (arg.indexOf("=") > -1) {
                    log.debug((Object)("arg [" + count + "]: " + arg));
                    argList = StringUtils.split((String)arg, (String)"=");
                    this.argMap.put(argList[0], argList[1]);
                }
                ++count;
            }
            log.debug((Object)("arg map keys: " + this.argMap.keySet()));
            log.debug((Object)("arg map: " + this.argMap));
            SOAP_URL_PREFIX = this.argMap.get("url_prefix");
            log.debug((Object)("Setting SOAP URL prefix: " + SOAP_URL_PREFIX));
            if (StringUtils.isBlank((String)SOAP_URL_PREFIX)) {
                log.error((Object)"url_prefix command-line parameter is blank");
            }
            BaseApplicantClient.initFilterNames();
        }
        catch (Exception e) {
            log.error((Object)("Exception caught during initialization: " + e.getMessage()));
        }
    }

    private static void initSoapUtils() {
        try {
            log.info((Object)"init SoapUtil with properties from: resources/applicant-s2s-config.properties");
            SoapUtil.setConfigPropertiesFile((String)CONFIG_PROPERTIES_FILE);
        }
        catch (Exception e) {
            log.error((Object)("Exception caught initializing SoapUtils: " + e.getMessage()));
            e.printStackTrace();
        }
    }

    private static void setSSLProps() {
        try {
            File f = null;
            System.setProperty(KEYSTORE, SoapUtil.getProperty((String)KEYSTORE));
            log.debug((Object)("keystore: " + System.getProperty(KEYSTORE)));
            f = new File(System.getProperty(KEYSTORE));
            if (!f.exists()) {
                log.error((Object)("Cannot find file: " + System.getProperty(KEYSTORE)));
                throw new Exception("Cannot find keystore: " + System.getProperty(KEYSTORE));
            }
            log.info((Object)("Keystore found: " + System.getProperty(KEYSTORE)));
            System.setProperty(KEYSTORE_PASSWORD, SoapUtil.getProperty((String)KEYSTORE_PASSWORD));
            System.setProperty(TRUSTSTORE, SoapUtil.getProperty((String)TRUSTSTORE));
            log.debug((Object)("truststore: " + System.getProperty(TRUSTSTORE)));
            f = new File(System.getProperty(TRUSTSTORE));
            if (!f.exists()) {
                log.error((Object)("Cannot find file: " + System.getProperty(TRUSTSTORE)));
                throw new Exception("Cannot find truststore: " + System.getProperty(TRUSTSTORE));
            }
            log.info((Object)("Truststore found: " + System.getProperty(TRUSTSTORE)));
            System.setProperty(TRUSTSTORE_PASSWORD, SoapUtil.getProperty((String)TRUSTSTORE_PASSWORD));
        }
        catch (Exception e) {
            log.error((Object)("Exception caught setting keystore/truststore properties: " + e.getMessage()));
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static void initFilterNames() {
        FILTER_NAMES = new HashMap<String, String>();
        FILTER_NAMES.put("status", "Status");
        FILTER_NAMES.put("oppid", "OpportunityID");
        FILTER_NAMES.put("cfda", "CFDANumber");
        FILTER_NAMES.put("submissiontitle", "SubmissionTitle");
        FILTER_NAMES.put("grantsgovtrackingnumber", "GrantsGovTrackingNumber");
        FILTER_NAMES.put("packageid", "PackageID");
        FILTER_NAMES.put("cfdanumber", "CFDANumber");
        FILTER_NAMES.put("competitionid", "CompetitionID");
        FILTER_NAMES.put("opportunitynumber", "FundingOpportunityNumber");
        log.debug((Object)("Initialized FILTER_NAMES map: " + FILTER_NAMES));
    }

    public static String formatDate(Date d, String format) {
        try {
            if (SDF == null) {
                log.debug((Object)"initialize SimpleDateFormat");
                SDF = new SimpleDateFormat(format);
            }
            return SDF.format(d);
        }
        catch (Exception e) {
            log.error((Object)("Exceptioin formatting date [" + d + "]: " + e.getMessage()));
            return "";
        }
    }

    public static String formatDate(long date, String format) {
        return BaseApplicantClient.formatDate(new Date(date), format);
    }

    protected boolean loadConfigXmlDoc(String configXmlFilePath) throws Exception {
        try {
            log.debug((Object)("Load XML: " + configXmlFilePath));
            byte[] xmlBytes = FileUtil.readFile((String)configXmlFilePath);
            log.debug((Object)("XML bytes loaded: " + xmlBytes.length));
            VTDGen vGen = new VTDGen();
            vGen.setDoc(xmlBytes);
            vGen.parse(false);
            this.configVN = vGen.getNav();
            return true;
        }
        catch (Exception e) {
            log.error((Object)("Exception loading [" + configXmlFilePath + "]: " + e.getMessage()));
            throw e;
        }
    }

    protected VTDNav loadXmlDoc(String xmlFileName) throws Exception {
        try {
            log.debug((Object)("Load XML: " + xmlFileName));
            byte[] xmlBytes = FileUtil.readFile((String)xmlFileName);
            log.debug((Object)("XML bytes loaded: " + xmlBytes.length));
            VTDGen vGen = new VTDGen();
            vGen.setDoc(xmlBytes);
            vGen.parse(false);
            VTDNav vn = vGen.getNav();
            return vn;
        }
        catch (Exception e) {
            log.error((Object)("Exception loading [" + xmlFileName + "]: " + e.getMessage()));
            throw e;
        }
    }

    public Map<String, String> getArgMap() {
        return this.argMap;
    }

    public void setArgMap(Map<String, String> argMap) {
        this.argMap = argMap;
    }

    static {
        log = Logger.getLogger((String)BaseApplicantClient.class.getName());
        SOAP_URL_PREFIX = null;
        DOMConfigurator config = new DOMConfigurator();
        config.doConfigure(BaseApplicantClient.class.getResourceAsStream("/resources/log4j.xml"), log.getLoggerRepository());
        BaseApplicantClient.initSoapUtils();
        BaseApplicantClient.setSSLProps();
    }
}

