/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.apply.applicant.v2;

import gov.grants.apply.applicant.v2.BaseApplicantClient;
import gov.grants.apply.services.applicantwebservices_v2.ApplicantWebServicesPortType;
import gov.grants.apply.services.applicantwebservices_v2.AuthenticateAORExpandedRequest;
import gov.grants.apply.services.applicantwebservices_v2.AuthenticateAORExpandedResponse;
import gov.grants.apply.system.grantscommonelements_v1.SecurityMessage;
import gov.grants.apply.system.grantscommonelements_v1.TokenInfo;
import gov.grants.apply.system.grantscommontypes_v1.AORStatusType;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AuthenticateAORExpandedClient
extends BaseApplicantClient {
    private static final String CLASSNAME = AuthenticateAORExpandedClient.class.getSimpleName();
    private static final Logger log = Logger.getLogger((String)CLASSNAME);

    public static void main(String[] args) {
        log.debug((Object)("Begin " + CLASSNAME));
        try {
            AuthenticateAORExpandedClient client = new AuthenticateAORExpandedClient();
            log.debug((Object)("args length: " + args.length));
            client.init(args);
            client.makeServiceCall();
            log.debug((Object)("\n\nSUCCESS: " + CLASSNAME + " successfully completed"));
        }
        catch (Exception e) {
            log.error((Object)("\n\nException: " + e.getMessage()));
        }
    }

    public void makeServiceCall() throws Exception {
        try {
            String aorUserId = null;
            String aorPassword = null;
            String aorDuns = null;
            String aorUei = null;
            String configXml = this.getArgMap().get("config_xml");
            this.loadConfigXmlDoc(configXml);
            this.configVN.toElement(2, CLASSNAME);
            if (this.configVN.toElement(2, "aor-user-id")) {
                aorUserId = this.configVN.toNormalizedString(this.configVN.getText());
                log.debug((Object)("aorUserId: " + aorUserId));
                this.configVN.toElement(1);
            }
            if (this.configVN.toElement(2, "aor-password")) {
                aorPassword = this.configVN.toNormalizedString(this.configVN.getText());
                log.debug((Object)("aorPassword: " + aorPassword));
                this.configVN.toElement(1);
            }
            if (this.configVN.toElement(2, "aor-duns")) {
                aorDuns = this.configVN.toNormalizedString(this.configVN.getText());
                log.debug((Object)("aorDuns: " + aorDuns));
                this.configVN.toElement(1);
            } else {
                log.debug((Object)"Optional AOR DUNS is not specified!");
            }
            if (this.configVN.toElement(2, "aor-uei")) {
                aorUei = this.configVN.toNormalizedString(this.configVN.getText());
                log.debug((Object)("aorUei: " + aorUei));
                this.configVN.toElement(1);
            } else {
                log.debug((Object)"Optional AOR UEI is not specified!");
            }
            if (StringUtils.isBlank((String)aorUserId) || StringUtils.isBlank((String)aorPassword)) {
                String s = "aor-user-id and aor-password elements in the config xml cannot be blank";
                log.error((Object)s);
                throw new Exception(s);
            }
            ApplicantWebServicesPortType port = this.getApplicantPort();
            AuthenticateAORExpandedRequest request = new AuthenticateAORExpandedRequest();
            request.setAORUserID(aorUserId);
            request.setAORPassword(aorPassword);
            request.setDUNS(aorDuns);
            request.setUEI(aorUei);
            AuthenticateAORExpandedResponse response = port.authenticateAORExpanded(request);
            StringBuilder sb = new StringBuilder();
            if (response.getAORStatus() == AORStatusType.AUTHORIZED) {
                sb.append("\n\n").append("AuthenticateAORExpandedResponse Information: ").append("\n==========").append("\nAOR Status: " + response.getAORStatus()).append("\nAOR User Full Name: " + response.getAORUserFullName());
                TokenInfo info = response.getTokenInfo();
                if (info != null) {
                    sb.append("\nTokenInfo Information:");
                    sb.append("\n----------");
                    sb.append("\nToken ID: " + info.getTokenID());
                    sb.append("\nToken Expiration Date: " + info.getTokenExpirationDate());
                } else {
                    sb.append("\n\nTokenInfo is blank");
                }
            } else {
                SecurityMessage msg = response.getSecurityMessage();
                if (msg != null) {
                    sb.append("\n\n").append("SECURITY MESSAGE INFO").append("\n=====================").append("\nMessage Code: " + msg.getMessageCode()).append("\nMessage Text: " + msg.getMessageText());
                } else {
                    sb.append("\n\nSecurity message is blank");
                }
            }
            sb.append("\n\n");
            log.debug((Object)sb);
        }
        catch (Exception e) {
            log.error((Object)("Exception: " + e.getMessage()));
            e.printStackTrace();
            throw e;
        }
    }
}

