/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.apply.applicant.v2;

import gov.grants.apply.applicant.v2.BaseApplicantClient;
import gov.grants.apply.services.applicantwebservices_v2.ApplicantWebServicesPortType;
import gov.grants.apply.services.applicantwebservices_v2.AuthenticateAORRequest;
import gov.grants.apply.services.applicantwebservices_v2.AuthenticateAORResponse;
import gov.grants.apply.system.grantscommonelements_v1.SecurityMessage;
import gov.grants.apply.system.grantscommonelements_v1.Token;
import org.apache.log4j.Logger;

public class AuthenticateAORClient
extends BaseApplicantClient {
    private static final String CLASSNAME = AuthenticateAORClient.class.getSimpleName();
    private static final Logger log = Logger.getLogger((String)CLASSNAME);

    public static void main(String[] args) {
        log.debug((Object)("Begin " + CLASSNAME));
        try {
            AuthenticateAORClient client = new AuthenticateAORClient();
            log.debug((Object)("args length: " + args.length));
            client.init(args);
            client.makeServiceCall();
            log.debug((Object)("\n\nSUCCESS: " + CLASSNAME + " successfully completed"));
        }
        catch (Exception e) {
            log.error((Object)("\n\nException: " + e.getMessage()));
        }
    }

    public void makeServiceCall() throws Exception {
        try {
            String aorUserId = null;
            String aorPassword = null;
            String aorDuns = null;
            String configXml = this.getArgMap().get("config_xml");
            this.loadConfigXmlDoc(configXml);
            this.configVN.toElement(2, CLASSNAME);
            if (this.configVN.toElement(2, "aor-user-id")) {
                aorUserId = this.configVN.toNormalizedString(this.configVN.getText());
                log.debug((Object)("aorUserId: " + aorUserId));
                this.configVN.toElement(1);
            }
            if (this.configVN.toElement(2, "aor-password")) {
                aorPassword = this.configVN.toNormalizedString(this.configVN.getText());
                log.debug((Object)("aorPassword: " + aorPassword));
                this.configVN.toElement(1);
            }
            if (this.configVN.toElement(2, "aor-duns")) {
                aorDuns = this.configVN.toNormalizedString(this.configVN.getText());
                log.debug((Object)("aorDuns: " + aorDuns));
                this.configVN.toElement(1);
            } else {
                log.debug((Object)"Optional AOR DUNS is not specified!");
            }
            ApplicantWebServicesPortType port = this.getApplicantPort();
            AuthenticateAORRequest request = new AuthenticateAORRequest();
            request.setAORUserID(aorUserId);
            request.setAORPassword(aorPassword);
            request.setDUNS(aorDuns);
            AuthenticateAORResponse response = port.authenticateAOR(request);
            StringBuilder sb = new StringBuilder();
            Token token = response.getToken();
            if (token != null) {
                sb.append("\n\n").append("Token Information:").append("\n==========").append("\nUser ID: " + token.getUserID()).append("\nToken ID: " + token.getTokenId()).append("\nDUNS: " + token.getDUNS()).append("\nFull Name: " + token.getFullName()).append("\nAOR Status: " + token.getAORStatus()).append("\nToken Expiration: " + token.getTokenExpiration());
            } else {
                sb.append("\n\nToken is blank");
            }
            SecurityMessage msg = response.getSecurityMessage();
            if (msg != null) {
                sb.append("\n\n").append("SECURITY MESSAGE INFO").append("\n=====================").append("\nMessage Code: " + msg.getMessageCode()).append("\nMessage Text: " + msg.getMessageText());
            } else {
                sb.append("\n\nSecurity message is blank");
            }
            sb.append("\n\n");
            log.debug((Object)sb);
        }
        catch (Exception e) {
            log.error((Object)("Exception: " + e.getMessage()));
            e.printStackTrace();
            throw e;
        }
    }
}

