/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.ws.util;

import gov.grants.commons.s2s.util.ByteArrayDataSource;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.handler.MessageContext;
import org.apache.log4j.Logger;

public class ProcessorUtil {
    private static final Logger log = Logger.getLogger((String)ProcessorUtil.class.getName());

    public static DataSource createDataSource(String contentType, String fileName, byte[] bytes) {
        ByteArrayDataSource ds = null;
        if (bytes != null && bytes.length > 0) {
            log.debug((Object)("create ByteArrayDataSource for: " + fileName));
            ds = new ByteArrayDataSource(contentType, fileName, bytes);
        }
        return ds;
    }

    public static DataHandler createDataHandler(String contentType, String fileName, byte[] bytes, String encodingType) {
        DataSource ds = ProcessorUtil.createDataSource(contentType, fileName, bytes);
        DataHandler dh = null;
        if (ds != null) {
            log.debug((Object)("create DataHandler for [" + fileName + "] with encoding type [" + encodingType + "]"));
            dh = new DataHandler(ds);
        }
        return dh;
    }

    public static void addOutboundAttachmentsToMsgCtx(WebServiceContext wsCtx, Map<String, DataHandler> attachmentMap) throws Exception {
        log.debug((Object)("Add outbound attachments to MessageContext: " + attachmentMap));
        try {
            log.debug((Object)("Get handle to message context" + wsCtx.getMessageContext().getClass().getName()));
            MessageContext msgCtx = wsCtx.getMessageContext();
            msgCtx.put((Object)"javax.xml.ws.binding.attachments.outbound", attachmentMap);
        }
        catch (Exception e) {
            log.error((Object)("Exception caught adding attachments to MessageContext: " + e.getMessage()));
            throw e;
        }
    }
}

