/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.web.filter;

import gov.grants.commons.CommonsGlobals;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class URLFilter
implements Filter {
    private static final Logger log = Logger.getLogger((String)URLFilter.class.getName());
    private String invalidChars = null;
    private String defaultReqUri = null;
    private boolean propsLoaded = false;
    private String URL_FILTER_EXCLUDE_PAGES_KEY = "exclude.pages";
    private String excludePagesStr = null;
    private String excludePagesRegex = null;
    private Pattern excludePagesPattern = null;

    public void init(FilterConfig config) throws ServletException {
        try {
            log.info((Object)"Load default filter properties");
            File filterProps = new File(CommonsGlobals.URL_FILTER_PROPERTIES_FILENAME);
            Properties props = null;
            if (filterProps.exists()) {
                props = new Properties();
                props.load(new FileInputStream(filterProps));
                this.invalidChars = props.getProperty("chars.invalid");
                log.debug((Object)("invalidChars=" + this.invalidChars));
                this.excludePagesStr = props.getProperty(this.URL_FILTER_EXCLUDE_PAGES_KEY);
                log.debug((Object)("exclude pages str: " + this.excludePagesStr));
                if (StringUtils.isBlank((String)this.excludePagesStr)) {
                    throw new Exception("Unable to find property: exclude.pages");
                }
                this.initExcludePages();
                this.propsLoaded = true;
            } else {
                log.error((Object)("Could not find URL filter properties: " + CommonsGlobals.URL_FILTER_PROPERTIES_FILENAME));
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            e.printStackTrace();
            throw new ServletException((Throwable)e);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            if (!this.propsLoaded) {
                log.error((Object)("Unable to load default url filter properties, make sure file exists in: " + CommonsGlobals.URL_FILTER_PROPERTIES_FILENAME));
                throw new IOException("Unable to load filter properties, make sure file exists in proper pkg/context/classpath");
            }
            HttpServletRequest req = (HttpServletRequest)request;
            boolean ajax = "XMLHttpRequest".equals(req.getHeader("X-Requested-With"));
            if (ajax) {
                chain.doFilter(request, response);
                return;
            }
            String qryStr = req.getQueryString();
            String reqUri = req.getRequestURI();
            String reqUrl = req.getRequestURL().toString();
            log.debug((Object)("qryStr=" + qryStr));
            log.debug((Object)("reqUri=" + reqUri));
            log.debug((Object)("reqUrl=" + reqUrl));
            String filteredQryStr = null;
            String destination = null;
            String filteredUri = null;
            boolean isRedirect = false;
            if (!this.excludePage(reqUri)) {
                if (StringUtils.isNotBlank((String)reqUri) && !reqUri.equals(filteredUri = reqUri.replaceAll(this.invalidChars, " "))) {
                    reqUri = filteredUri;
                    isRedirect = true;
                }
                if (StringUtils.isNotBlank((String)qryStr)) {
                    log.debug((Object)("Filtering for invalid characters in qryStr=" + qryStr));
                    filteredQryStr = qryStr.replaceAll(this.invalidChars, "&");
                    log.debug((Object)("filteredQryStr=" + filteredQryStr));
                    if (!qryStr.equals(filteredQryStr)) {
                        isRedirect = true;
                        qryStr = filteredQryStr;
                    }
                }
                if (isRedirect) {
                    destination = this.defaultReqUri != null ? this.defaultReqUri : (StringUtils.isNotBlank((String)qryStr) ? reqUri + "?" + qryStr : reqUri);
                    ((HttpServletResponse)response).sendRedirect(destination);
                }
            }
            log.debug((Object)"end doFilter()");
            chain.doFilter(request, response);
        }
        catch (ServletException e) {
            log.error((Object)("ServletException caught:\n" + (Object)((Object)e)));
            e.printStackTrace();
        }
        catch (IOException e) {
            log.error((Object)("IOException caught:\n" + e));
            e.printStackTrace();
        }
    }

    public void destroy() {
        log.debug((Object)("Cleaning up: " + URLFilter.class.getName()));
    }

    private boolean excludePage(String reqUri) {
        Matcher matcher = this.excludePagesPattern.matcher(reqUri);
        if (matcher.find()) {
            log.debug((Object)("match found: " + matcher.group(0)));
            return true;
        }
        return false;
    }

    private void initExcludePages() {
        this.excludePagesRegex = this.createExcludePagesRegex();
        this.excludePagesPattern = Pattern.compile(this.excludePagesRegex);
    }

    private String createExcludePagesRegex() {
        String[] pages;
        log.debug((Object)("create regex from exclude pages: " + this.excludePagesStr));
        int count = 0;
        StringBuilder regex = new StringBuilder();
        regex.append("(");
        for (String s : pages = StringUtils.split((String)this.excludePagesStr, (String)"|")) {
            if (count > 0) {
                regex.append("|");
            }
            regex.append(s);
            ++count;
        }
        regex.append(")");
        log.debug((Object)("exclude pages regex: " + regex));
        return regex.toString();
    }
}

