/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.web;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class WsdlLocationServlet
extends HttpServlet {
    private static final Logger LOG = Logger.getLogger((String)WsdlLocationServlet.class.getName());
    private static final long serialVersionUID = 1234567890L;
    private static String environment;
    private static Properties properties;
    private static Map<String, String> wsdlStrings;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String uri = req.getRequestURI();
        String key = uri.substring(uri.lastIndexOf("/wsdl"));
        String wsdl = wsdlStrings.get(key);
        resp.setContentType("text/xml;charset=UTF-8");
        resp.setCharacterEncoding("UTF-8");
        PrintWriter pw = resp.getWriter();
        pw.print(wsdl);
    }

    public static InputStream getWsdlAsInputStream(String wsdlLocation) {
        String wsdl = wsdlStrings.get(wsdlLocation);
        if (wsdl == null) {
            return null;
        }
        try {
            return new ByteArrayInputStream(wsdl.getBytes("UTF-8"));
        }
        catch (Exception e) {
            String s = "Exception caught getting XML bytes: " + e.getMessage();
            LOG.error((Object)s);
            return new ByteArrayInputStream(wsdl.getBytes());
        }
    }

    public void init() throws ServletException {
        String wsdlFiles;
        super.init();
        environment = System.getProperty("environment", "prod");
        LOG.debug((Object)("running in " + environment));
        if (properties == null) {
            try {
                properties = new Properties();
                properties.load(((Object)((Object)this)).getClass().getResourceAsStream("/application.properties"));
            }
            catch (IOException e) {
                LOG.error((Object)"Exception: can not load application.properties file", (Throwable)e);
            }
        }
        if ((wsdlFiles = properties.getProperty("wsdl.files")) != null) {
            for (String wsdlFile : wsdlFiles.split(",")) {
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(wsdlFile)));
                    String line = null;
                    StringBuilder sb = new StringBuilder();
                    String ls = System.getProperty("line.separator");
                    while ((line = reader.readLine()) != null) {
                        sb.append(line);
                        sb.append(ls);
                    }
                    String wsdl = sb.toString().replaceAll(properties.getProperty("wsdl.root.url.token"), properties.getProperty("wsdl.root.url." + environment));
                    wsdlStrings.put(wsdlFile, wsdl);
                    reader.close();
                }
                catch (IOException e) {
                    LOG.error((Object)("I/O Exception while reading " + wsdlFile + " as input stream."), (Throwable)e);
                }
            }
        }
    }

    static {
        wsdlStrings = new HashMap<String, String>();
    }
}

