/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.web;

import gov.grants.commons.util.ResourceUtils;
import gov.grants.commons.validator.GGGenericValidatorUtil;
import gov.grants.commons.validator.ValidationTestBean;
import java.util.Arrays;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ValidatorInitServlet
extends HttpServlet {
    private static final long serialVersionUID = 123456789L;
    private static final Logger log = Logger.getLogger((String)ValidatorInitServlet.class.getName());
    private static final String CLASSNAME = ValidatorInitServlet.class.getName();

    public void init() throws ServletException {
        log.info((Object)("Initializing: " + CLASSNAME));
        this.initResources();
        this.initValidator();
        log.info((Object)(CLASSNAME + " successfully initialized"));
    }

    public void initResources() throws ServletException {
        log.info((Object)"\n\n** Initialize Message Resources ***\n\n");
        String configResource = this.getInitParameter("configResource");
        log.info((Object)("Loading config resource file:" + configResource));
        ResourceBundle bundle = null;
        if (StringUtils.isNotBlank((String)configResource)) {
            bundle = ResourceBundle.getBundle(configResource);
            ResourceUtils.addConfigResource(bundle);
            log.info((Object)("Test Config Resources:" + ResourceUtils.getConfigResource().getText("test.msg")));
        } else {
            log.info((Object)"Cannot initialize config resources -- 'configResource' param not found in web.xml");
        }
        String textResource = this.getInitParameter("textResource");
        log.info((Object)("Loading text resource file:" + textResource));
        if (StringUtils.isNotBlank((String)textResource)) {
            bundle = ResourceBundle.getBundle(textResource);
            ResourceUtils.addResource(bundle);
            log.info((Object)("Test Text Resources:" + ResourceUtils.getResource().getText("test.msg")));
        } else {
            log.info((Object)"Cannot initialize text resources -- 'textResource' param not found in web.xml");
        }
        log.info((Object)"\n\n** Message Resources Loaded **\n\n");
    }

    public void initValidator() throws ServletException {
        try {
            log.info((Object)"==> Initialize Validator <==");
            String validatorConfigs = this.getInitParameter("validatorConfigs");
            log.info((Object)("==> validatorConfigs=" + validatorConfigs));
            if (StringUtils.isNotBlank((String)validatorConfigs)) {
                String[] validatorConfigList = StringUtils.splitByWholeSeparator((String)validatorConfigs, (String)",");
                log.info((Object)("==> validatorConfigList=" + Arrays.asList(validatorConfigList)));
                GGGenericValidatorUtil.init(validatorConfigList);
                log.info((Object)"--- Test-load validator resources");
                GGGenericValidatorUtil.testInitResources();
                log.info((Object)"\n\n** Validator Resources Initialized **\n\n");
                log.info((Object)"--- Test 'PASS' validation");
                HashMap<String, String> errors = new HashMap<String, String>();
                ValidationTestBean o = new ValidationTestBean("FirstNameTest", "LastNameTest", 2, "01/24/1990");
                GGGenericValidatorUtil.validateBean("ValidationTestBean", o, errors, ResourceUtils.getResource());
                log.info((Object)("--- error map=" + errors));
                if (errors.size() > 0) {
                    log.error((Object)"\n\nErrors found --- Validation is not working\n\n");
                } else {
                    log.info((Object)"\n\nErrors not found --- Validation is working\n\n");
                }
                log.info((Object)"Test 'FAIL' validation");
                o = new ValidationTestBean(null, "", 0, "1/2/1990");
                GGGenericValidatorUtil.validateBean("ValidationTestBean", o, errors, ResourceUtils.getResource());
                log.info((Object)("--- error map=" + errors));
                if (errors.size() > 0) {
                    log.error((Object)"\n\nErrors found --- Validation is working\n\n");
                } else {
                    log.info((Object)"\n\nErrors not found --- Validation is not working\n\n");
                }
            } else {
                log.info((Object)"Validator framework cannot be initialized -- 'validatorConfigs' param not found in web.xml");
            }
            log.info((Object)("\n\n\n********** [ " + CLASSNAME + " STARTED ] **********\n\n"));
        }
        catch (Exception e) {
            log.fatal((Object)("\n\n\n---------- [ " + CLASSNAME + " FAILED with an Exception ] -----------\n\n"));
            log.error((Object)("Exception message=" + e.getMessage()));
            e.printStackTrace();
            throw new ServletException(e.getMessage());
        }
    }

    public void destroy() {
        super.destroy();
        log.info((Object)("\nShutting down [" + CLASSNAME + "]\n"));
    }
}

