/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.web;

import gov.grants.commons.bizobj.SystemConfiguration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SystemConfigurationInitServlet
extends HttpServlet {
    private static final Logger log = Logger.getLogger((String)SystemConfigurationInitServlet.class.getName());
    private static final long serialVersionUID = 1234567890L;
    private static String CLASSNAME = "SystemConfigurationInitServlet";

    public void destroy() {
        super.destroy();
        log.info((Object)("\n** CLEANING UP " + CLASSNAME + " **\n"));
    }

    public String getServletInfo() {
        return "Re-usable gov.grants.commons.util.SystemConfiguration initialization servlet.";
    }

    public void init() throws ServletException {
        try {
            log.info((Object)("\n\n*** INITIALIZING " + CLASSNAME + " ***\n\n"));
            String systemConfigXmlFilename = this.getInitParameter("systemConfigXmlFilename");
            log.info((Object)("==> systemConfigXmlFilename=" + systemConfigXmlFilename));
            if (StringUtils.isBlank((String)systemConfigXmlFilename)) {
                log.error((Object)"'systemConfigXmlFilename' is blank in web.xml");
                throw new ServletException("'systemConfigXmlFilename' is blank in web.xml");
            }
            SystemConfiguration.init(systemConfigXmlFilename);
            log.info((Object)("Property test [FORM_XDP_XML_DIR]=" + SystemConfiguration.getValue("FORM_XDP_XML_DIR")));
            log.info((Object)("\n\n\n********** [ " + CLASSNAME + " STARTED ] **********\n\n"));
        }
        catch (Exception e) {
            log.fatal((Object)("\n\n\n---------- [ " + CLASSNAME + " FAILED with an Exception ] -----------\n\n"));
            log.error((Object)("Exception message=" + e.getMessage()));
            e.printStackTrace();
            throw new ServletException(e.getMessage());
        }
    }
}

