/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.web;

import gov.grants.commons.util.SpringServiceLocator;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SpringInitServlet
extends HttpServlet {
    private static final Logger log = Logger.getLogger((String)SpringInitServlet.class.getName());
    private static final long serialVersionUID = 1234567890L;
    private static String CLASSNAME = SpringInitServlet.class.getSimpleName();

    public void destroy() {
        super.destroy();
        log.info((Object)("\n** CLEANING UP " + CLASSNAME + " **\n"));
    }

    public String getServletInfo() {
        return "Re-usable gov.grants.commons.service.SpringServiceLocator initialization servlet.";
    }

    public void init() throws ServletException {
        try {
            log.info((Object)("\n\n*** INITIALIZING " + CLASSNAME + " ***\n\n"));
            String springCtxList = this.getInitParameter("springCtxList");
            log.info((Object)("==> init-param springCtxList=" + springCtxList));
            if (StringUtils.isBlank((String)springCtxList)) {
                log.info((Object)"==> Initialize SpringServiceLocator from Spring's ContextLoaderListener <==");
                SpringServiceLocator.init(this.getServletContext());
            } else {
                log.info((Object)"==> Initialize SpringServiceLocator from SpringInitServlet init-params <==");
                List<String> ctxList = Arrays.asList(StringUtils.splitByWholeSeparator((String)springCtxList, (String)","));
                log.info((Object)("==> ctxList=" + ctxList));
                SpringServiceLocator.init(ctxList);
            }
            log.info((Object)("Spring Bean Definitions:\n\n" + Arrays.asList(SpringServiceLocator.getBeanDefinitionNames())));
            log.info((Object)("\n\n\n********** [ " + CLASSNAME + " STARTED ] **********\n\n"));
        }
        catch (Exception e) {
            log.fatal((Object)("\n\n\n---------- [ " + CLASSNAME + " FAILED with an Exception ] -----------\n\n"));
            log.error((Object)("Exception message=" + e.getMessage()));
            e.printStackTrace();
            throw new ServletException(e.getMessage());
        }
    }
}

