/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.web;

import gov.grants.commons.jmx.agent.JMXAgent;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;

public class LoggerInitServlet
extends HttpServlet {
    private static final Logger log = Logger.getLogger((String)LoggerInitServlet.class.getName());
    private static final long serialVersionUID = 1234567890L;
    private static String CLASSNAME = "LoggerInitServlet";

    public void destroy() {
        super.destroy();
        log.info((Object)("\n** CLEANING UP " + CLASSNAME + " **\n"));
    }

    public String getServletInfo() {
        return "Re-usable Logger initialization servlet.";
    }

    public void init() throws ServletException {
        try {
            String logfile = this.getInitParameter("logFile");
            if (StringUtils.isNotBlank((String)logfile)) {
                System.out.println("Logfile from web.xml param=" + logfile);
                System.out.println("Setting system property log.file=" + logfile);
                System.setProperty("log.file", logfile);
            } else {
                System.out.println("WARNING: Log file is not set in web.xml");
            }
            System.out.println("Get log4j config file from web.xml");
            String log4jConfig = this.getInitParameter("log4jConfig");
            System.out.println("Log4j config=" + log4jConfig);
            if (StringUtils.isNotBlank((String)log4jConfig)) {
                System.out.println(":: Configuring DOMConfigurator ::");
                DOMConfigurator.configure((String)log4jConfig);
                System.out.println(":: Successfully configured DOMConfigurator ::");
                log.info((Object)"\n\n** Logger CONFIGURED SUCCESSFULLY **\n\n");
            } else {
                log.warn((Object)"Log4j config file not set in web.xml");
            }
            log.info((Object)("\n\n\n********** [ " + CLASSNAME + " STARTED ] **********\n\n"));
            JMXAgent.getDefault(this.getServletContext().getServletContextName());
            log.info((Object)"\n\n\n********** [ Log4jAdmin JMX started ] ************\n\n");
        }
        catch (Exception e) {
            log.fatal((Object)("\n\n\n---------- [ " + CLASSNAME + " FAILED with an Exception ] -----------\n\n"));
            e.printStackTrace();
            throw new ServletException(e.getMessage());
        }
    }
}

