/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.web;

import gov.grants.commons.daemon.Heartbeat;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class HeartbeatInitServlet
extends HttpServlet {
    private static final Logger log = Logger.getLogger((String)HeartbeatInitServlet.class.getName());
    private static final long serialVersionUID = 1234567890L;
    private static String CLASSNAME = "HeartbeatInitServlet";
    private Heartbeat task = null;

    public void destroy() {
        super.destroy();
        log.info((Object)("\n** CLEANING UP " + CLASSNAME + " **\n"));
        if (this.task != null) {
            this.task.stop();
        }
    }

    public String getServletInfo() {
        return "Heartbeat init servlet";
    }

    public void init() throws ServletException {
        try {
            String timeInterval = this.getInitParameter("timeInterval");
            if (StringUtils.isNotBlank((String)timeInterval)) {
                log.info((Object)("Time interval in milliseconds=" + timeInterval));
                log.info((Object)"Setting time interval in heartbeat task");
                this.task = new Heartbeat(timeInterval);
            } else {
                log.warn((Object)"No time interval specified --- using default time interval");
                this.task = new Heartbeat();
            }
            log.info((Object)"Start heartbeat ...");
            new Thread(this.task).start();
            log.info((Object)("\n\n\n********** [ " + CLASSNAME + " STARTED ] **********\n\n"));
        }
        catch (Exception e) {
            log.fatal((Object)("\n\n\n---------- [ " + CLASSNAME + " FAILED with an Exception ] -----------\n\n"));
            e.printStackTrace();
            throw new ServletException(e.getMessage());
        }
    }
}

