/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.vo;

import gov.grants.commons.bizobj.Activity;
import gov.grants.commons.type.GGUserType;
import gov.grants.commons.type.OrgWorkspaceDisplayFlagType;
import gov.grants.commons.type.PrivilegeType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.log4j.Logger;

public class GGSSOUserProfile
implements Serializable {
    private static final transient Logger log = Logger.getLogger((String)GGSSOUserProfile.class.getName());
    private static final long serialVersionUID = 1L;
    private long id;
    private String name;
    private String agencyCode;
    private String duns;
    private String samUei;
    private boolean isHidden = false;
    private boolean isDeleted = false;
    private GGUserType type;
    private List<String> roles = new ArrayList<String>();
    private List<Activity> activities = new ArrayList<Activity>();
    private boolean mpinValidated = false;
    private boolean canManageWorkspace = false;
    private boolean canCreateWorkspace = false;
    private boolean isIndvApplicantType = false;
    private boolean isEBizType = false;
    private boolean isOrgApplicantType = false;
    private int typeId = -1;
    private String orgWorkspaceDisplayFlag = OrgWorkspaceDisplayFlagType.ALL_ORG_WORKSPACES.key();
    private Set<PrivilegeType> privilegeTypes = new HashSet<PrivilegeType>();

    public GGSSOUserProfile() {
    }

    public GGSSOUserProfile(long userProfileId, String profileName, GGUserType ggUserType, Set<PrivilegeType> privilegeTypes) {
        this.id = userProfileId;
        this.name = profileName;
        this.type = ggUserType;
        this.privilegeTypes = privilegeTypes;
        this.initJsonValues();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public boolean isApplicantProfile() {
        return StringUtils.isNotBlank((CharSequence)this.duns);
    }

    public boolean isGrantorProfile() {
        return StringUtils.isNotBlank((CharSequence)this.agencyCode);
    }

    public boolean isVisible() {
        return !this.isHidden;
    }

    public boolean canManageWorkspace() {
        return this.hasAnyPrivilege(PrivilegeType.CREATE_WS, PrivilegeType.OWN_WS);
    }

    public boolean canCreateWorkspace() {
        return this.hasPrivilege(PrivilegeType.CREATE_WS);
    }

    public boolean hasExpandedAORAccess() {
        return this.hasAnyPrivilege(PrivilegeType.MANAGE_PARTICIPANTS_ORG_WS, PrivilegeType.PARTICIPANT_ACTIVITIES_ORG_WS, PrivilegeType.SUBMIT_APPLICATIONS_ORG);
    }

    public boolean isEBiz() {
        return GGUserType.EBIZ == this.type;
    }

    public boolean isIndvApplicant() {
        return GGUserType.APPLICANT_INDV == this.type;
    }

    public boolean isOrgApplicant() {
        return GGUserType.APPLICANT_ORG == this.type;
    }

    public boolean isWorkspacePartner() {
        return GGUserType.WORKSPACE_PARTNER == this.type;
    }

    public void initJsonValues() {
        this.canManageWorkspace = this.canManageWorkspace();
        this.canCreateWorkspace = this.canCreateWorkspace();
        this.isIndvApplicantType = this.isIndvApplicant();
        this.isEBizType = this.isEBiz();
        this.isOrgApplicantType = this.isOrgApplicant();
        this.typeId = this.type.id();
    }

    public Map<String, Activity> getActivityMap() {
        HashMap<String, Activity> m = new HashMap<String, Activity>();
        for (Activity a : this.activities) {
            m.put(a.getActivityID(), a);
        }
        return m;
    }

    public boolean canViewAllOrgWorkspaces() {
        OrgWorkspaceDisplayFlagType type = OrgWorkspaceDisplayFlagType.fromKey(this.orgWorkspaceDisplayFlag);
        log.debug((Object)("org workspace display flag type: " + (Object)((Object)type)));
        return type == OrgWorkspaceDisplayFlagType.ALL_ORG_WORKSPACES;
    }

    public boolean hasPrivilege(PrivilegeType privilegeType) {
        return this.privilegeTypes.contains((Object)privilegeType);
    }

    public boolean hasAnyPrivilege(PrivilegeType ... privilegeTypes) {
        return this.hasPrivileges(false, privilegeTypes);
    }

    public boolean hasAllPrivileges(PrivilegeType ... privilegeTypes) {
        return this.hasPrivileges(true, privilegeTypes);
    }

    public boolean hasPrivileges(boolean hasAllPrivileges, PrivilegeType ... privilegeTypes) {
        if (hasAllPrivileges) {
            if (this.privilegeTypes.containsAll(Arrays.asList(privilegeTypes))) {
                return true;
            }
        } else {
            for (PrivilegeType type : privilegeTypes) {
                if (!this.privilegeTypes.contains((Object)type)) continue;
                return true;
            }
        }
        return false;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAgencyCode() {
        return this.agencyCode;
    }

    public void setAgencyCode(String agencyCode) {
        this.agencyCode = agencyCode;
    }

    public String getDuns() {
        return this.duns;
    }

    public void setDuns(String duns) {
        this.duns = duns;
    }

    public String getSamUei() {
        return this.samUei;
    }

    public void setSamUei(String samUei) {
        this.samUei = samUei;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public void setHidden(boolean isHidden) {
        this.isHidden = isHidden;
    }

    public GGUserType getType() {
        return this.type;
    }

    public void setType(GGUserType type) {
        this.type = type;
        if (type != null) {
            this.typeId = type.id();
        }
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public void setDeleted(boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public List<Activity> getActivities() {
        return this.activities;
    }

    public void setActivities(List<Activity> activities) {
        this.activities = activities;
    }

    public boolean isMpinValidated() {
        return this.mpinValidated;
    }

    public void setMpinValidated(boolean mpinValidated) {
        this.mpinValidated = mpinValidated;
    }

    public String getOrgWorkspaceDisplayFlag() {
        return this.orgWorkspaceDisplayFlag;
    }

    public void setOrgWorkspaceDisplayFlag(String orgWorkspaceDisplayFlag) {
        this.orgWorkspaceDisplayFlag = orgWorkspaceDisplayFlag;
    }

    public Set<PrivilegeType> getPrivilegeTypes() {
        return this.privilegeTypes;
    }

    public void setPrivilegeTypes(Set<PrivilegeType> privilegeTypes) {
        this.privilegeTypes = privilegeTypes;
    }

    public static class GGSSOUserProfileComparator
    implements Comparator<GGSSOUserProfile> {
        @Override
        public int compare(GGSSOUserProfile p1, GGSSOUserProfile p2) {
            return p1.getName().compareToIgnoreCase(p2.getName());
        }
    }
}

