/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.validator.validwhen;

import gov.grants.commons.validator.validwhen.ValidWhenLexer;
import gov.grants.commons.validator.validwhen.ValidWhenParser;
import java.io.StringReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.util.ValidatorUtils;

public class ValidWhen {
    private static final Log log = LogFactory.getLog((String)ValidWhen.class.getName());

    private static boolean isString(Object obj) {
        return obj == null ? true : String.class.isInstance(obj);
    }

    public static boolean validateValidWhen(Object bean, ValidatorAction va, Field field, Validator validator) {
        log.debug((Object)("field.getKey()=" + field.getKey()));
        Object form = validator.getParameterValue("java.lang.Object");
        String value = null;
        boolean valid = false;
        int index = -1;
        if (field.isIndexed()) {
            String key = field.getKey();
            int leftBracket = key.indexOf("[");
            int rightBracket = key.indexOf("]");
            if (leftBracket > -1 && rightBracket > -1) {
                index = Integer.parseInt(key.substring(leftBracket + 1, rightBracket));
            }
        }
        value = ValidWhen.isString(bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        log.debug((Object)("value=" + value));
        String test = field.getVarValue("test");
        if (test == null) {
            String msg = "ValidWhen Error 'test' parameter is missing for field ' " + field.getKey() + "'";
            log.error((Object)msg);
            return false;
        }
        ValidWhenLexer lexer = null;
        try {
            lexer = new ValidWhenLexer(new StringReader(test));
        }
        catch (Exception ex) {
            String msg = "ValidWhenLexer Error for field ' " + field.getKey() + "' - " + ex;
            log.error((Object)msg);
            log.debug((Object)msg, (Throwable)ex);
            return false;
        }
        ValidWhenParser parser = null;
        try {
            parser = new ValidWhenParser(lexer);
        }
        catch (Exception ex) {
            String msg = "ValidWhenParser Error for field ' " + field.getKey() + "' - " + ex;
            log.error((Object)msg);
            log.debug((Object)msg, (Throwable)ex);
            return false;
        }
        parser.setForm(form);
        parser.setIndex(index);
        parser.setValue(value);
        try {
            parser.expression();
            valid = parser.getResult();
        }
        catch (Exception ex) {
            String msg = "ValidWhen Error for field ' " + field.getKey() + "' - " + ex;
            log.error((Object)msg);
            log.debug((Object)msg, (Throwable)ex);
            return false;
        }
        if (!valid) {
            log.error((Object)"=====> NOT VALID <=====");
            return false;
        }
        return true;
    }
}

