/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.validator;

import gov.grants.commons.bizobj.SystemConfiguration;
import gov.grants.commons.util.ResourceLocator;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.Arg;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorResources;
import org.apache.log4j.Logger;

public class GGValidatorUtil
implements Serializable {
    static final Logger log = Logger.getLogger((String)GGValidatorUtil.class.getName());
    private static final long serialVersionUID = 1L;
    protected static String[] configs = null;
    protected static String configFilePath = null;
    protected static ValidatorResources resources = null;

    protected GGValidatorUtil() {
    }

    protected static void initValidatorUtil(String[] configArray, String filePath) {
        configs = configArray;
        configFilePath = filePath;
    }

    protected static void initValidatorUtil(String[] configArray) {
        configs = configArray;
    }

    public static void testInitResources() {
        try {
            log.debug((Object)"** TEST LOADING RESOURCES **");
            GGValidatorUtil.initResources();
        }
        catch (Exception e) {
            log.error((Object)"ERROR THROWN WHILE TEST LOADING RESOURCES");
        }
    }

    public static String getSystemConfigurationValue(String key) {
        log.debug((Object)("key: " + key));
        if (StringUtils.isBlank((CharSequence)key)) {
            log.warn((Object)"key is blank -- cannot retrieve SystemConfiguration value");
        }
        if (key.startsWith("#SystemConfiguration#")) {
            key = key.substring(21);
        }
        log.debug((Object)("load message from SystemConfiguration for key: " + key));
        return SystemConfiguration.getString(key);
    }

    protected static ValidatorResources initResources() throws Exception {
        String value = null;
        int count = configs.length;
        InputStream is = null;
        InputStream[] resources = new InputStream[count];
        ValidatorResources valRes = null;
        String filePath = null;
        ResourceLocator resLocator = new ResourceLocator();
        try {
            log.info((Object)"** INITIALIZE CONFIG(S) **");
            for (int i = 0; i < count; ++i) {
                value = configs[i].trim();
                log.debug((Object)("Searching for:" + value));
                try {
                    resLocator.init(value);
                    is = resLocator.getInputStream();
                }
                catch (Exception e) {
                    log.error((Object)"will try to load resource from config file path");
                    is = null;
                }
                log.debug((Object)("==> is=" + is));
                if (is == null) {
                    log.info((Object)("Unable to find [" + value + "] in classpath"));
                    filePath = configFilePath + value;
                    log.info((Object)("Searching for:" + filePath));
                    FileInputStream fis = new FileInputStream(filePath);
                    is = new BufferedInputStream(fis);
                }
                if (is == null) {
                    log.error((Object)("CANNOT INITIALIZE [" + value + "] :: INPUT STREAM NULL **\n\n"));
                    throw new Exception("CANNOT INITIALIZE [" + value + "] :: INPUT STREAM NULL **\n\n");
                }
                log.debug((Object)("Store resource=" + value));
                resources[i] = is;
            }
            log.debug((Object)("Initialize all resources=" + resources));
            valRes = new ValidatorResources(resources);
            log.info((Object)"** VALIDATOR CONFIG(S) INITIALIZED **");
        }
        catch (Exception e) {
            log.error((Object)("ERROR :: Exception=" + e));
            e.printStackTrace();
        }
        return valRes;
    }

    protected static void replacePlaceholderArg(Field field, String argKey, String newKey) {
        log.debug((Object)("==> newKey=" + newKey));
        log.debug((Object)("==> argKey=" + argKey));
        Arg arg = new Arg();
        if (GGValidatorUtil.isPlaceholderArg(field.getArg(0))) {
            log.debug((Object)"checking 0");
            arg = field.getArg(0);
            arg.setKey(newKey);
            arg.setName(argKey);
            field.addArg(arg);
        } else if (GGValidatorUtil.isPlaceholderArg(field.getArg(1))) {
            log.debug((Object)"checking 1");
            arg = field.getArg(1);
            arg.setKey(newKey);
            field.addArg(arg);
        } else if (GGValidatorUtil.isPlaceholderArg(field.getArg(2))) {
            log.debug((Object)"checking 2");
            arg = field.getArg(2);
            arg.setKey(newKey);
            field.addArg(arg);
        } else if (GGValidatorUtil.isPlaceholderArg(field.getArg(3))) {
            log.debug((Object)"checking 3");
            arg = field.getArg(3);
            arg.setKey(newKey);
            field.addArg(arg);
        }
        log.debug((Object)"returning");
    }

    protected static boolean isPlaceholderArg(Arg arg) {
        log.debug((Object)("==> arg=" + arg));
        if (arg != null) {
            String key = arg.getKey();
            log.debug((Object)("==> key=" + key));
            return key.indexOf("VALIDATOR_ARG_PLACEHOLDER") >= 0;
        }
        return false;
    }

    protected static void displayFieldArgs(Field field, ValidatorAction va) {
        String vaName = va.getName();
        Arg[] args = field.getArgs(vaName);
        if (args == null) {
            return;
        }
        int argsSize = args.length;
        for (int i = 0; i < argsSize; ++i) {
            log.debug((Object)("==> field.msg" + i + "=" + field.getMsg(vaName)));
            log.debug((Object)("==> field.arg" + i + "=" + field.getArg(vaName, i)));
        }
    }
}

