/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.validator;

import gov.grants.commons.bizobj.SystemConfiguration;
import gov.grants.commons.util.XSSUtil;
import gov.grants.commons.validator.GGValidatorUtil;
import java.io.Serializable;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.GenericTypeValidator;
import org.apache.commons.validator.GenericValidator;
import org.apache.commons.validator.util.ValidatorUtils;
import org.apache.log4j.Logger;

public class GGValidator
implements Serializable {
    static final Logger log = Logger.getLogger((String)GGValidator.class.getName());
    private static final long serialVersionUID = 1L;
    public static final int UID_MAX_LENGTH = 25;

    public static boolean validateFloatIfPresent(Object bean, Field field) {
        String value = GGValidator.getBeanValue(bean, field);
        Float result = null;
        try {
            if (StringUtils.isNotBlank((CharSequence)value) && (result = GenericTypeValidator.formatFloat((String)value)) == null) {
                log.debug((Object)("FLOAT validation for field.getKey() = " + field.getKey() + " failed"));
                return false;
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            log.debug((Object)("FLOAT validation for field.getKey() = " + field.getKey() + " failed"));
            return false;
        }
        return true;
    }

    public static boolean validateIntegerIfPresent(Object bean, Field field) {
        String value = GGValidator.getBeanValue(bean, field);
        Integer result = null;
        try {
            if (StringUtils.isNotBlank((CharSequence)value) && (result = GenericTypeValidator.formatInt((String)value)) == null) {
                log.debug((Object)("INTEGER validation for field.getKey() = " + field.getKey() + " failed"));
                return false;
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            log.debug((Object)("INTEGER validation for field.getKey() = " + field.getKey() + " failed"));
            return false;
        }
        return true;
    }

    public static boolean validateDateIfPresent(Object bean, Field field) {
        String value = GGValidator.getBeanValue(bean, field);
        Date result = null;
        try {
            if (StringUtils.isNotBlank((CharSequence)value) && (result = GenericTypeValidator.formatDate((String)value, null)) == null) {
                log.debug((Object)("DATE validation for field.getKey() = " + field.getKey() + " failed"));
                return false;
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            log.debug((Object)("DATE validation for field.getKey() = " + field.getKey() + " failed"));
            return false;
        }
        return true;
    }

    public static boolean validateNumericRangeIfPresent(Object bean, Field field) {
        String value = GGValidator.getBeanValue(bean, field);
        log.debug((Object)("==> value=[" + value + "]"));
        String sMin = field.getVarValue("min");
        String sMax = field.getVarValue("max");
        if (StringUtils.isNotBlank((CharSequence)value)) {
            try {
                float fValue = Float.parseFloat(value);
                float min = Float.parseFloat(sMin);
                float max = Float.parseFloat(sMax);
                if (fValue < min || fValue > max) {
                    log.debug((Object)("NUMERIC RANGE validation for field.getKey() = " + field.getKey() + " failed"));
                    return false;
                }
            }
            catch (Exception e) {
                log.debug((Object)("NUMERIC RANGE validation for field.getKey() = " + field.getKey() + " failed"));
                return false;
            }
        }
        return true;
    }

    public static boolean validateAlpha(Object bean, Field field) {
        String value = GGValidator.getBeanValue(bean, field);
        return !StringUtils.isNotBlank((CharSequence)value) || StringUtils.isAlpha((CharSequence)value);
    }

    public static boolean validateAlphaSpace(Object bean, Field field) {
        String value = GGValidator.getBeanValue(bean, field);
        return !StringUtils.isNotBlank((CharSequence)value) || StringUtils.isAlphaSpace((CharSequence)value);
    }

    public static boolean validateAlphaNumeric(Object bean, Field field) {
        String value = GGValidator.getBeanValue(bean, field);
        return !StringUtils.isNotBlank((CharSequence)value) || StringUtils.isAlphanumeric((CharSequence)value);
    }

    public static boolean validateAlphaNumericSpace(Object bean, Field field) {
        String value = GGValidator.getBeanValue(bean, field);
        return !StringUtils.isNotBlank((CharSequence)value) || StringUtils.isAlphanumericSpace((CharSequence)value);
    }

    public static boolean validateAlphaNumericSpecialChars(Object bean, Field field) {
        String specialChars;
        String temp;
        String value = GGValidator.getBeanValue(bean, field);
        return !StringUtils.isNotBlank((CharSequence)value) || StringUtils.isAlphanumericSpace((CharSequence)(temp = value.replaceAll(specialChars = SystemConfiguration.getString("VALIDATOR_SPECIAL_CHARS_REGEX"), "Z")));
    }

    public static boolean validateNumeric(Object bean, Field field) {
        String value = GGValidator.getBeanValue(bean, field);
        return !StringUtils.isNotBlank((CharSequence)value) || StringUtils.isNumeric((CharSequence)value);
    }

    public static boolean validateNoWhiteChars(Object bean, Field field) {
        String value = GGValidator.getBeanValue(bean, field);
        return !StringUtils.isNotBlank((CharSequence)value) || !StringUtils.containsWhitespace((CharSequence)value);
    }

    public static boolean validateNotAllNumeric(Object bean, Field field) {
        String value = GGValidator.getBeanValue(bean, field);
        return !StringUtils.isNotBlank((CharSequence)value) || !StringUtils.isNumeric((CharSequence)value);
    }

    public static boolean validateNumericSpace(Object bean, Field field) {
        String value = GGValidator.getBeanValue(bean, field);
        return !StringUtils.isNotBlank((CharSequence)value) || StringUtils.isNumericSpace((CharSequence)value);
    }

    public static boolean xssCheck(Object bean, Field field) {
        String value = GGValidator.getBeanValue(bean, field);
        log.debug((Object)("value: " + value));
        boolean isValid = false;
        try {
            isValid = XSSUtil.isXssSafe(value);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            log.debug((Object)("xss validation for field.getKey() = " + field.getKey() + " failed"));
        }
        log.debug((Object)("returning valid=" + isValid));
        return isValid;
    }

    public static boolean uidCheck(Object bean, Field field) {
        if (bean == null || field == null) {
            return false;
        }
        String value = GGValidator.getBeanValue(bean, field);
        log.debug((Object)("value: " + value));
        if (value.length() > 25) {
            return false;
        }
        boolean isValid = false;
        try {
            isValid = XSSUtil.isValidMatch(value, "^[a-zA-Z0-9_@?.-]+$");
            isValid = isValid && !GenericValidator.matchRegexp((String)value, (String)"^\\d{9}.*");
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            log.debug((Object)("xss validation for field.getKey() = " + field.getKey() + " failed"));
        }
        log.debug((Object)("returning valid=" + isValid));
        return isValid;
    }

    public static boolean validateFundingOppNumber(Object bean, Field field) {
        String value = GGValidator.getBeanValue(bean, field);
        log.debug((Object)("bean property: " + field.getProperty()));
        log.debug((Object)("bean value: " + value));
        if (StringUtils.isBlank((CharSequence)value)) {
            return true;
        }
        String regex = SystemConfiguration.getString("VALIDATOR_FUNDING_OPP_NUM_REGEX");
        log.error((Object)("opp number regex: " + regex));
        if (StringUtils.isBlank((CharSequence)regex)) {
            log.error((Object)"VALIDATOR_FUNDING_OPP_NUM_REGEX is missing from system configuration - return true");
            return true;
        }
        boolean isValid = false;
        try {
            Pattern p = Pattern.compile(regex);
            Matcher m = p.matcher(value);
            isValid = m.matches();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            log.debug((Object)("Funding opportunity number validation for field.getKey() = " + field.getKey() + " failed"));
        }
        log.debug((Object)("returning is valid: " + isValid));
        return isValid;
    }

    public static boolean validateCFDA(Object bean, Field field) {
        String value = GGValidator.getBeanValue(bean, field);
        log.debug((Object)("bean property: " + field.getProperty()));
        log.debug((Object)("bean value: " + value));
        if (StringUtils.isBlank((CharSequence)value)) {
            return true;
        }
        String regex = SystemConfiguration.getString("VALIDATOR_CFDA_REGEX");
        log.error((Object)("cfda regex: " + regex));
        if (StringUtils.isBlank((CharSequence)regex)) {
            log.error((Object)"VALIDATOR_CFDA_REGEX is missing from system configuration - return true");
            return true;
        }
        boolean isValid = false;
        try {
            Pattern p = Pattern.compile(regex);
            Matcher m = p.matcher(value);
            isValid = m.matches();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            log.debug((Object)("CFDA validation for field.getKey() = " + field.getKey() + " failed"));
        }
        log.debug((Object)("returning is valid: " + isValid));
        return isValid;
    }

    public static boolean validateAllowableSpecialChars(Object bean, Field field) {
        String temp;
        String regex = field.getVarValue("regex");
        log.debug((Object)("regex: " + regex));
        if (StringUtils.isBlank((CharSequence)regex)) {
            log.error((Object)"regex value is blank --- validation failed!");
            return false;
        }
        if (regex.startsWith("#SystemConfiguration#")) {
            regex = GGValidatorUtil.getSystemConfigurationValue(regex);
        }
        log.debug((Object)("final regex: " + regex));
        String value = GGValidator.getBeanValue(bean, field);
        return !StringUtils.isNotBlank((CharSequence)value) || StringUtils.isAlphanumericSpace((CharSequence)(temp = value.replaceAll(regex, "Z")));
    }

    private static String getBeanValue(Object bean, Field field) {
        String value = null;
        value = String.class.isInstance(bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        return value;
    }

    public static boolean validateForSpecialChars(String inputString, String specialChars) {
        String temp;
        return !StringUtils.isNotBlank((CharSequence)inputString) || StringUtils.isAlphanumericSpace((CharSequence)(temp = inputString.replaceAll(specialChars, "Z")));
    }

    public static boolean validateForSpecialChars(String inputString) {
        String specialChars = SystemConfiguration.getString("VALIDATOR_SPECIAL_CHARS_REGEX");
        return GGValidator.validateForSpecialChars(inputString, specialChars);
    }
}

