/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.validator;

import gov.grants.commons.util.TextResources;
import gov.grants.commons.validator.GGValidatorUtil;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.validator.Arg;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Form;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorResult;
import org.apache.commons.validator.ValidatorResults;
import org.apache.log4j.Logger;

public class GGJsfValidatorUtil
extends GGValidatorUtil
implements Serializable {
    static final Logger log = Logger.getLogger((String)GGJsfValidatorUtil.class.getName());
    private static final long serialVersionUID = 1L;

    private GGJsfValidatorUtil() {
    }

    public static void init(String[] configArray, String filePath) {
        GGJsfValidatorUtil.initValidatorUtil(configArray, filePath);
    }

    public static void init(String[] configArray) {
        GGJsfValidatorUtil.initValidatorUtil(configArray);
    }

    public static boolean validateBean(String beanAlias, Object bean, Map<String, String> errors, HttpServletRequest request, String objectName, TextResources txtResources) {
        log.debug((Object)"** BEGIN VALIDATING BEAN **");
        Field field = null;
        Field fieldClone = null;
        Form form = null;
        ValidatorAction action = null;
        ValidatorResults results = null;
        ValidatorResult result = null;
        Set propertyNames = null;
        Iterator actionNames = null;
        String actionName = null;
        String propertyName2 = null;
        String errorsKey = null;
        boolean success = true;
        String fieldKey = null;
        String msgKey = null;
        try {
            if (resources == null) {
                log.debug((Object)"** INITIALIZING RESOURCES **");
                resources = GGJsfValidatorUtil.initResources();
            }
            Validator validator = new Validator(resources, beanAlias);
            validator.setParameter("java.lang.Object", bean);
            validator.setParameter("javax.servlet.http.HttpServletRequest", (Object)request);
            log.debug((Object)"** RUN VALIDATION AGAINST BEAN **");
            results = validator.validate();
            log.debug((Object)"** GET FORM FROM CURRENT LOCALE AND BEAN **");
            form = resources.getForm(Locale.getDefault(), beanAlias);
            propertyNames = results.getPropertyNames();
            for (String propertyName2 : propertyNames) {
                log.debug((Object)("Property Name: " + propertyName2));
                field = form.getField(propertyName2);
                result = results.getValidatorResult(propertyName2);
                actionNames = result.getActions();
                while (actionNames.hasNext()) {
                    actionName = (String)actionNames.next();
                    log.debug((Object)("==> actionName=" + actionName));
                    action = resources.getValidatorAction(actionName);
                    GGJsfValidatorUtil.displayFieldArgs(field, action);
                    if (objectName != null) {
                        fieldClone = (Field)field.clone();
                        log.debug((Object)("==>fieldClone=" + fieldClone));
                        GGJsfValidatorUtil.displayFieldArgs(fieldClone, action);
                        GGJsfValidatorUtil.replacePlaceholderArg(fieldClone, action.getName(), objectName);
                    }
                    log.debug((Object)(propertyName2 + "[" + actionName + "] (" + (result.isValid(actionName) ? "PASSED" : "FAILED") + ")"));
                    if (!result.isValid(actionName)) {
                        success = false;
                        fieldKey = field.getKey();
                        log.debug((Object)("==>fieldKey=" + fieldKey));
                        if (fieldKey != null && !errors.containsKey(fieldKey)) {
                            if (objectName != null) {
                                errorsKey = objectName + "." + fieldClone.getProperty();
                                log.debug((Object)("==> errorsKey=" + errorsKey));
                                msgKey = fieldClone.getMsg(actionName);
                                errors.put(errorsKey, txtResources.getText(msgKey, GGJsfValidatorUtil.getArgMessages(txtResources, fieldClone.getArgs(actionName))));
                            } else {
                                msgKey = field.getMsg(actionName);
                                errors.put(fieldKey, txtResources.getText(msgKey, GGJsfValidatorUtil.getArgMessages(txtResources, field.getArgs(actionName))));
                            }
                        }
                    }
                    log.debug((Object)"** RESETTING FIELD CLONE **");
                    fieldClone = null;
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("ERROR :: Exception=" + e));
            e.printStackTrace();
        }
        if (success) {
            log.debug((Object)"** BEAN VALIDATION SUCCESSFUL **");
        } else {
            log.debug((Object)"**  BEAN VALIDATION FAILED **");
        }
        return true;
    }

    private static Object[] getArgMessages(TextResources resources, Arg[] args) {
        log.debug((Object)("args=" + args));
        if (args == null) {
            return null;
        }
        int argsSize = args.length;
        Object[] argMsgs = new Object[argsSize];
        Arg arg = null;
        for (int i = 0; i < argsSize; ++i) {
            arg = args[i];
            log.debug((Object)("arg = " + arg));
            if (arg == null) {
                log.warn((Object)("ARG[" + i + "] IS NULL"));
                continue;
            }
            log.debug((Object)("arg.isResource=" + arg.isResource()));
            argMsgs[i] = arg.isResource() ? resources.getText(arg.getKey()) : arg.getKey();
            log.debug((Object)("argMsgs[" + i + "]=" + argMsgs[i]));
        }
        return argMsgs;
    }
}

