/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.validator;

import gov.grants.commons.util.TextResources;
import gov.grants.commons.validator.GGValidatorUtil;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.validator.Arg;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Form;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorResult;
import org.apache.commons.validator.ValidatorResults;
import org.apache.log4j.Logger;

public class GGGenericValidatorUtil
extends GGValidatorUtil
implements Serializable {
    static final Logger log = Logger.getLogger((String)GGGenericValidatorUtil.class.getName());
    private static final long serialVersionUID = 1L;

    private GGGenericValidatorUtil() {
    }

    public static void init(String[] configArray, String filePath) {
        GGGenericValidatorUtil.initValidatorUtil(configArray, filePath);
    }

    public static void init(String[] configArray) {
        GGGenericValidatorUtil.initValidatorUtil(configArray);
    }

    public static boolean validateBean(String beanAlias, Object bean, Map<String, String> errors, TextResources txtResources) {
        log.debug((Object)"** BEGIN VALIDATING BEAN **");
        Form form = null;
        ValidatorAction action = null;
        ValidatorResults results = null;
        ValidatorResult result = null;
        Object propertyNames = null;
        Iterator actionNames = null;
        String actionName = null;
        boolean success = true;
        String fieldKey = null;
        String msgKey = null;
        try {
            if (resources == null) {
                log.debug((Object)"** INITIALIZING RESOURCES **");
                resources = GGGenericValidatorUtil.initResources();
            }
            Validator validator = new Validator(resources, beanAlias);
            validator.setParameter("java.lang.Object", bean);
            log.debug((Object)"** RUN VALIDATION AGAINST BEAN **");
            results = validator.validate();
            log.debug((Object)"** GET FORM FROM CURRENT LOCALE AND BEAN **");
            form = resources.getForm(Locale.getDefault(), beanAlias);
            if (form == null) {
                String msg = "Unable to find config to validate: " + beanAlias;
                log.error((Object)msg);
                throw new Exception(msg);
            }
            for (Field field : form.getFields()) {
                String propertyName = field.getProperty();
                if (!results.getPropertyNames().contains(field.getProperty())) continue;
                result = results.getValidatorResult(propertyName);
                actionNames = result.getActions();
                while (actionNames.hasNext()) {
                    actionName = (String)actionNames.next();
                    action = resources.getValidatorAction(actionName);
                    GGGenericValidatorUtil.displayFieldArgs(field, action);
                    log.debug((Object)("result for: property=" + propertyName + " --- action=" + actionName + " (" + (result.isValid(actionName) ? "PASSED" : "FAILED") + ")"));
                    if (result.isValid(actionName)) continue;
                    success = false;
                    fieldKey = field.getKey();
                    log.debug((Object)("==>fieldKey=" + fieldKey));
                    if (fieldKey == null || errors.containsKey(fieldKey)) continue;
                    msgKey = field.getMsg(actionName);
                    errors.put(fieldKey, txtResources.getText(msgKey, GGGenericValidatorUtil.getArgMessages(txtResources, field.getArgs(actionName))));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            e.printStackTrace();
            errors.put("validation-exception", "Unable to perform data validation: " + e.getMessage());
        }
        if (success) {
            log.debug((Object)"** BEAN VALIDATION SUCCESSFUL **");
        } else {
            log.debug((Object)"**  BEAN VALIDATION FAILED **");
        }
        return success;
    }

    public static boolean validateBean(String beanAlias, Object bean) throws Exception {
        log.debug((Object)"** BEGIN VALIDATING BEAN **");
        Form form = null;
        ValidatorAction action = null;
        ValidatorResults results = null;
        ValidatorResult result = null;
        Iterator actionNames = null;
        String actionName = null;
        boolean success = true;
        String fieldKey = null;
        try {
            if (resources == null) {
                log.debug((Object)"** INITIALIZING RESOURCES **");
                resources = GGGenericValidatorUtil.initResources();
            }
            Validator validator = new Validator(resources, beanAlias);
            validator.setParameter("java.lang.Object", bean);
            log.debug((Object)"** RUN VALIDATION AGAINST BEAN **");
            results = validator.validate();
            log.debug((Object)"** GET FORM FROM CURRENT LOCALE AND BEAN **");
            form = resources.getForm(Locale.getDefault(), beanAlias);
            if (form == null) {
                String msg = "Unable to find config to validate: " + beanAlias;
                log.error((Object)msg);
                throw new Exception(msg);
            }
            for (Field field : form.getFields()) {
                String propertyName = field.getProperty();
                if (!results.getPropertyNames().contains(field.getProperty())) continue;
                result = results.getValidatorResult(propertyName);
                actionNames = result.getActions();
                while (actionNames.hasNext()) {
                    actionName = (String)actionNames.next();
                    action = resources.getValidatorAction(actionName);
                    GGGenericValidatorUtil.displayFieldArgs(field, action);
                    log.debug((Object)("result for: property=" + propertyName + " --- action=" + actionName + " (" + (result.isValid(actionName) ? "PASSED" : "FAILED") + ")"));
                    if (result.isValid(actionName)) continue;
                    success = false;
                    fieldKey = field.getKey();
                    log.debug((Object)("==>fieldKey=" + fieldKey));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            e.printStackTrace();
            throw e;
        }
        if (success) {
            log.debug((Object)"** BEAN VALIDATION SUCCESSFUL **");
        } else {
            log.debug((Object)"**  BEAN VALIDATION FAILED **");
        }
        return success;
    }

    private static Object[] getArgMessages(TextResources resources, Arg[] args) {
        log.debug((Object)("args: " + args));
        if (args == null) {
            return null;
        }
        int argsSize = args.length;
        Object[] argMsgs = new Object[argsSize];
        Arg arg = null;
        String key = null;
        for (int i = 0; i < argsSize; ++i) {
            arg = args[i];
            log.debug((Object)("arg: " + arg));
            if (arg == null) {
                log.warn((Object)("ARG[" + i + "] IS NULL"));
                continue;
            }
            log.debug((Object)("arg.isResource=" + arg.isResource()));
            if (arg.isResource()) {
                key = arg.getKey();
                log.debug((Object)("resource key: " + key));
                argMsgs[i] = key.startsWith("#SystemConfiguration#") ? GGGenericValidatorUtil.getSystemConfigurationValue(key) : resources.getText(key);
            } else {
                argMsgs[i] = arg.getKey();
            }
            log.debug((Object)("argMsgs[" + i + "]=" + argMsgs[i]));
        }
        return argMsgs;
    }
}

