/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.validator;

import gov.grants.commons.validator.GGValidatorUtil;
import java.io.Serializable;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.GenericTypeValidator;
import org.apache.commons.validator.GenericValidator;
import org.apache.commons.validator.UrlValidator;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.util.ValidatorUtils;
import org.apache.log4j.Logger;

public class GGFieldChecks
implements Serializable {
    private static final Logger LOG = Logger.getLogger((String)GGFieldChecks.class.getName());
    private static final long serialVersionUID = 1L;
    public static final String FIELD_TEST_NULL = "NULL";
    public static final String FIELD_TEST_NOTNULL = "NOTNULL";
    public static final String FIELD_TEST_EQUAL = "EQUAL";

    public static boolean validateRequired(Object bean, Field field) {
        String value = null;
        value = GGFieldChecks.isString(bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        LOG.debug((Object)("bean property: " + field.getProperty()));
        LOG.debug((Object)("bean value: " + value));
        boolean hasValue = StringUtils.isNotBlank((String)value);
        LOG.debug((Object)("hasValue: " + hasValue));
        return hasValue;
    }

    public static boolean validateRequiredIf(Object bean, Field field, Validator validator) {
        Object form = validator.getParameterValue("java.lang.Object");
        String value = null;
        boolean required = false;
        value = GGFieldChecks.isString(bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        int i = 0;
        String fieldJoin = "AND";
        if (!GenericValidator.isBlankOrNull((String)field.getVarValue("fieldJoin"))) {
            fieldJoin = field.getVarValue("fieldJoin");
        }
        if (fieldJoin.equalsIgnoreCase("AND")) {
            required = true;
        }
        while (!GenericValidator.isBlankOrNull((String)field.getVarValue("field[" + i + "]"))) {
            String key;
            String dependProp = field.getVarValue("field[" + i + "]");
            String dependTest = field.getVarValue("fieldTest[" + i + "]");
            String dependTestValue = field.getVarValue("fieldValue[" + i + "]");
            String dependIndexed = field.getVarValue("fieldIndexed[" + i + "]");
            if (dependIndexed == null) {
                dependIndexed = "false";
            }
            String dependVal = null;
            boolean thisRequired = false;
            if (field.isIndexed() && dependIndexed.equalsIgnoreCase("true") && (key = field.getKey()).indexOf("[") > -1 && key.indexOf("]") > -1) {
                String ind = key.substring(0, key.indexOf(".") + 1);
                dependProp = ind + dependProp;
            }
            dependVal = ValidatorUtils.getValueAsString((Object)form, (String)dependProp);
            if (dependTest.equals(FIELD_TEST_NULL)) {
                thisRequired = dependVal == null || dependVal.length() <= 0;
            }
            if (dependTest.equals(FIELD_TEST_NOTNULL)) {
                thisRequired = dependVal != null && dependVal.length() > 0;
            }
            if (dependTest.equals(FIELD_TEST_EQUAL)) {
                thisRequired = dependTestValue.equalsIgnoreCase(dependVal);
            }
            required = fieldJoin.equalsIgnoreCase("AND") ? required && thisRequired : required || thisRequired;
            ++i;
        }
        if (required) {
            return !GenericValidator.isBlankOrNull((String)value);
        }
        return true;
    }

    public static boolean validateMaskMatch(Object bean, Field field) {
        String mask = field.getVarValue("mask");
        LOG.debug((Object)("regex: " + mask));
        if (StringUtils.isBlank((String)mask)) {
            LOG.error((Object)"mask is blank --- validation failed!");
            return false;
        }
        if (mask.startsWith("#SystemConfiguration#")) {
            mask = GGValidatorUtil.getSystemConfigurationValue(mask);
        }
        LOG.debug((Object)("final regex: " + mask));
        String value = null;
        value = GGFieldChecks.isString(bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        LOG.debug((Object)("bean value: " + value));
        try {
            if (StringUtils.isNotBlank((String)value)) {
                Pattern p = Pattern.compile(mask);
                Matcher matcher = p.matcher(value);
                boolean isValid = matcher.matches();
                LOG.debug((Object)("returning isValid: " + isValid));
                return isValid;
            }
            return true;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return true;
        }
    }

    protected static boolean validateMaskFindValid(Object bean, Field field) {
        return GGFieldChecks.validateMaskFind(bean, field);
    }

    protected static boolean validateMaskFindInvalid(Object bean, Field field) {
        return !GGFieldChecks.validateMaskFind(bean, field);
    }

    public static Object validateByte(Object bean, Field field) {
        Byte result = null;
        String value = null;
        value = GGFieldChecks.isString(bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (GenericValidator.isBlankOrNull((String)value)) {
            return Boolean.TRUE;
        }
        result = GenericTypeValidator.formatByte((String)value);
        if (result == null) {
            return Boolean.FALSE;
        }
        return result;
    }

    public static Object validateShort(Object bean, Field field) {
        Short result = null;
        String value = null;
        value = GGFieldChecks.isString(bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (GenericValidator.isBlankOrNull((String)value)) {
            return Boolean.TRUE;
        }
        result = GenericTypeValidator.formatShort((String)value);
        if (result == null) {
            return Boolean.FALSE;
        }
        return result;
    }

    public static Object validateInteger(Object bean, Field field) {
        Integer result = null;
        String value = null;
        value = GGFieldChecks.isString(bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (GenericValidator.isBlankOrNull((String)value)) {
            return Boolean.TRUE;
        }
        result = GenericTypeValidator.formatInt((String)value);
        if (result == null) {
            return Boolean.FALSE;
        }
        return result;
    }

    public static Object validateLong(Object bean, Field field) {
        Long result = null;
        String value = null;
        value = GGFieldChecks.isString(bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (GenericValidator.isBlankOrNull((String)value)) {
            return Boolean.TRUE;
        }
        result = GenericTypeValidator.formatLong((String)value);
        if (result == null) {
            return Boolean.FALSE;
        }
        return result;
    }

    public static Object validateFloat(Object bean, Field field) {
        Float result = null;
        String value = null;
        value = GGFieldChecks.isString(bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (GenericValidator.isBlankOrNull((String)value)) {
            return Boolean.TRUE;
        }
        result = GenericTypeValidator.formatFloat((String)value);
        if (result == null) {
            return Boolean.FALSE;
        }
        return result;
    }

    public static Object validateDouble(Object bean, Field field) {
        Double result = null;
        String value = null;
        value = GGFieldChecks.isString(bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (GenericValidator.isBlankOrNull((String)value)) {
            return Boolean.TRUE;
        }
        result = GenericTypeValidator.formatDouble((String)value);
        if (result == null) {
            return Boolean.FALSE;
        }
        return result;
    }

    public static Object validateDate(Object bean, Field field, Locale locale) {
        Date result = null;
        String value = null;
        value = GGFieldChecks.isString(bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        String datePattern = field.getVarValue("datePattern");
        String datePatternStrict = field.getVarValue("datePatternStrict");
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (GenericValidator.isBlankOrNull((String)value)) {
            return Boolean.TRUE;
        }
        try {
            result = StringUtils.isNotBlank((String)datePattern) ? GenericTypeValidator.formatDate((String)value, (String)datePattern, (boolean)false) : (StringUtils.isNotBlank((String)datePatternStrict) ? GenericTypeValidator.formatDate((String)value, (String)datePatternStrict, (boolean)true) : GenericTypeValidator.formatDate((String)value, (Locale)locale));
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        if (result == null) {
            return Boolean.FALSE;
        }
        return result;
    }

    public static boolean validateIntRange(Object bean, Field field) {
        String value = null;
        value = GGFieldChecks.isString(bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (!GenericValidator.isBlankOrNull((String)value)) {
            try {
                int intValue = Integer.parseInt(value);
                int min = Integer.parseInt(field.getVarValue("min"));
                int max = Integer.parseInt(field.getVarValue("max"));
                if (!GenericValidator.isInRange((int)intValue, (int)min, (int)max)) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public static boolean validateDoubleRange(Object bean, Field field) {
        String value = null;
        value = GGFieldChecks.isString(bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (!GenericValidator.isBlankOrNull((String)value)) {
            try {
                double doubleValue = Double.parseDouble(value);
                double min = Double.parseDouble(field.getVarValue("min"));
                double max = Double.parseDouble(field.getVarValue("max"));
                if (!GenericValidator.isInRange((double)doubleValue, (double)min, (double)max)) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public static boolean validateFloatRange(Object bean, Field field) {
        String value = null;
        value = GGFieldChecks.isString(bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (!GenericValidator.isBlankOrNull((String)value)) {
            try {
                float floatValue = Float.parseFloat(value);
                float min = Float.parseFloat(field.getVarValue("min"));
                float max = Float.parseFloat(field.getVarValue("max"));
                if (!GenericValidator.isInRange((float)floatValue, (float)min, (float)max)) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public static Object validateCreditCard(Object bean, Field field) {
        Long result = null;
        String value = null;
        value = GGFieldChecks.isString(bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (GenericValidator.isBlankOrNull((String)value)) {
            return Boolean.TRUE;
        }
        result = GenericTypeValidator.formatCreditCard((String)value);
        if (result == null) {
            return Boolean.FALSE;
        }
        return result;
    }

    public static boolean validateEmail(Object bean, Field field) {
        String value = null;
        value = GGFieldChecks.isString(bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        return GenericValidator.isBlankOrNull((String)value) || GenericValidator.isEmail((String)value);
    }

    public static boolean validateMaxLength(Object bean, Field field) {
        String value = null;
        value = GGFieldChecks.isString(bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (value != null) {
            try {
                int max = Integer.parseInt(field.getVarValue("maxlength"));
                if (!GenericValidator.maxLength((String)value, (int)max)) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public static boolean validateMinLength(Object bean, Field field) {
        String value = null;
        value = GGFieldChecks.isString(bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (!GenericValidator.isBlankOrNull((String)value)) {
            try {
                int min = Integer.parseInt(field.getVarValue("minlength"));
                if (!GenericValidator.minLength((String)value, (int)min)) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public static boolean validateUrl(Object bean, Field field) {
        UrlValidator urlValidator;
        String schemesVar;
        int options;
        String value = null;
        value = GGFieldChecks.isString(bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if (StringUtils.isBlank((String)value)) {
            return true;
        }
        boolean allowallschemes = "true".equalsIgnoreCase(field.getVarValue("allowallschemes"));
        int n = options = allowallschemes ? 1 : 0;
        if ("true".equalsIgnoreCase(field.getVarValue("allow2slashes"))) {
            options += 2;
        }
        if ("true".equalsIgnoreCase(field.getVarValue("nofragments"))) {
            options += 4;
        }
        String string = schemesVar = allowallschemes ? null : field.getVarValue("schemes");
        if (options == 0 && schemesVar == null) {
            return GenericValidator.isUrl((String)value);
        }
        String[] schemes = null;
        if (schemesVar != null) {
            StringTokenizer st = new StringTokenizer(schemesVar, ",");
            schemes = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                schemes[i++] = st.nextToken().trim();
            }
        }
        return (urlValidator = new UrlValidator(schemes, options)).isValid(value);
    }

    protected static boolean isString(Object o) {
        return o == null ? true : String.class.isInstance(o);
    }

    protected static boolean validateMaskFind(Object bean, Field field) {
        boolean found = false;
        String mask = field.getVarValue("mask");
        LOG.debug((Object)("regex: " + mask));
        if (StringUtils.isBlank((String)mask)) {
            LOG.error((Object)"mask is blank --- validation failed!");
            return false;
        }
        if (mask.startsWith("#SystemConfiguration#")) {
            mask = GGValidatorUtil.getSystemConfigurationValue(mask);
        }
        LOG.debug((Object)("final regex: " + mask));
        String value = null;
        value = GGFieldChecks.isString(bean) ? (String)bean : ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        LOG.debug((Object)("bean value: " + value));
        try {
            if (StringUtils.isNotBlank((String)value)) {
                Pattern p = Pattern.compile(mask);
                Matcher matcher = p.matcher(value);
                found = matcher.find();
                LOG.debug((Object)("found: " + found));
            } else {
                LOG.debug((Object)"value is blank");
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return found;
    }
}

