/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.util;

import gov.grants.commons.bizobj.ZipFileEntry;
import gov.grants.commons.bizobj.ZipPkg;
import gov.grants.commons.util.Timer;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.UnsupportedZipFeatureException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.log4j.Logger;

public class ZipUtil {
    private static final Logger log = Logger.getLogger((String)ZipUtil.class.getName());

    public static ZipArchiveOutputStream createZipFile(String outFileName) {
        ZipArchiveOutputStream out = null;
        try {
            out = ZipUtil.createZipFile(new FileOutputStream(outFileName));
        }
        catch (Exception e) {
            log.error((Object)("Exception creating ZipOutputStream: " + e.getMessage()));
        }
        return out;
    }

    public static ZipArchiveOutputStream createZipFile(OutputStream os) {
        ZipArchiveOutputStream out = null;
        try {
            out = new ZipArchiveOutputStream(os);
        }
        catch (Exception e) {
            log.error((Object)("Exception creating ZipOutputStream: " + e.getMessage()));
        }
        return out;
    }

    public static ZipArchiveOutputStream generateZipFile(String fileName, byte[] b, ZipArchiveOutputStream out) {
        log.debug((Object)("create zip file: " + fileName));
        try {
            out.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(fileName));
            int len = b.length;
            out.write(b, 0, len);
            out.closeArchiveEntry();
        }
        catch (IOException e) {
            log.error((Object)("Exception in generate ZipFile: " + e.getMessage()));
        }
        log.debug((Object)"zip file created successfully");
        return out;
    }

    public static ZipArchiveOutputStream generateZipFile(String fileName, FileInputStream in, ZipArchiveOutputStream out) {
        log.debug((Object)("create zip file: " + fileName));
        byte[] b = new byte[1024];
        try {
            int i;
            out.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(fileName));
            while ((i = in.read(b)) > 0) {
                out.write(b, 0, i);
            }
            out.closeArchiveEntry();
        }
        catch (Exception e) {
            log.error((Object)("Exception in generate ZipFile: " + e.getMessage()));
        }
        log.debug((Object)"create zip file successfully");
        return out;
    }

    public static void closeZip(ZipArchiveOutputStream out) {
        try {
            out.close();
        }
        catch (IOException e) {
            log.error((Object)("Exception closing zip: " + e.getMessage()));
        }
    }

    public static boolean createZipToDisk(ZipPkg zipPkg, boolean addManifest) {
        try {
            log.debug((Object)("Create zip: " + zipPkg.getZipFilePath()));
            Timer timer = new Timer();
            timer.start();
            FileInputStream fis = null;
            ZipArchiveOutputStream zos = new ZipArchiveOutputStream((OutputStream)new FileOutputStream(zipPkg.getZipFilePath()));
            zos.setEncoding("Cp437");
            zos.setFallbackToUTF8(true);
            zos.setUseLanguageEncodingFlag(true);
            zos.setCreateUnicodeExtraFields(ZipArchiveOutputStream.UnicodeExtraFieldPolicy.NOT_ENCODEABLE);
            log.debug((Object)"ZipArchiveOutputStream created");
            byte[] buf = new byte[1024];
            int count = 0;
            List<ZipFileEntry> entryList = zipPkg.getZipEntries();
            log.debug((Object)("zip entries: " + entryList));
            for (ZipFileEntry entry : entryList) {
                int i;
                log.debug((Object)(">>> adding: " + entry.getFilePath()));
                if (entry.hasFileBytes()) {
                    log.info((Object)("zip entry contains bytes: " + entry.getFileSize()));
                    if (!ZipUtil.addBytesToZip(entry.getZipEntry(), entry.getFileBytes(), zos)) continue;
                    ++count;
                    continue;
                }
                log.info((Object)("reading zip entry from disk: " + entry.getFilePath()));
                fis = new FileInputStream(entry.getFilePath());
                log.debug((Object)("file size: " + fis.available()));
                if (entry.calculateFileSize()) {
                    entry.setFileSize(fis.available());
                }
                zos.putArchiveEntry((ArchiveEntry)entry.getZipEntry());
                while ((i = fis.read(buf)) > 0) {
                    zos.write(buf, 0, i);
                }
                zos.closeArchiveEntry();
                ++count;
            }
            if (addManifest) {
                zipPkg.addManifest(zos);
            }
            zos.flush();
            zos.close();
            timer.stop();
            log.debug((Object)("file count: " + count));
            log.debug((Object)("time: " + timer.toMilliseconds() + "ms"));
        }
        catch (UnsupportedZipFeatureException e) {
            log.error((Object)("ZipException caught creating zip: " + e.getMessage()));
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            log.error((Object)("IOException caught creating zip: " + e.getMessage()));
            e.printStackTrace();
            return false;
        }
        catch (Exception e) {
            log.error((Object)("Exception caught creating zip: " + e.getMessage()));
            e.printStackTrace();
            return false;
        }
        log.info((Object)"Zip file created and written to disk successfully");
        return true;
    }

    public static boolean addBytesToZip(ZipArchiveEntry entry, byte[] entryBytes, ZipArchiveOutputStream zos) {
        if (entryBytes == null || entryBytes.length == 0) {
            log.warn((Object)"zip entry bytes is null or empty --- not adding to zip");
            return false;
        }
        try {
            log.debug((Object)("Adding [" + entry.getName() + "] with bytes: " + entryBytes.length));
            zos.putArchiveEntry((ArchiveEntry)entry);
            int len = entryBytes.length;
            zos.write(entryBytes, 0, len);
            zos.closeArchiveEntry();
        }
        catch (IOException e) {
            log.error((Object)("IOException caught adding entry bytes to zip: " + e.getMessage()));
            return false;
        }
        catch (Exception e) {
            log.error((Object)("Exception caught adding entry bytes to zip: " + e.getMessage()));
            return false;
        }
        return true;
    }
}

