/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.util;

import gov.grants.commons.bizobj.SystemConfiguration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class XSSUtil {
    private static final Logger log = Logger.getLogger((String)XSSUtil.class.getName());
    private static final String S2S_VALIDATOR_XSS_TAGS = "<script";

    private XSSUtil() {
    }

    public static boolean isMhtmlXssSafe(String value) {
        boolean isValid = true;
        try {
            String regex = null;
            regex = SystemConfiguration.getString("VALIDATOR_MHTML_XSS_INVALID_CHARS_REGEX");
            isValid = XSSUtil.isValidValue(value, regex);
        }
        catch (Exception e) {
            log.error((Object)("failed validation -- Exception: " + e.getMessage()));
            isValid = false;
        }
        log.debug((Object)("is valid: " + isValid));
        return isValid;
    }

    public static boolean isS2SXssSafe(String value) {
        boolean isValid = true;
        try {
            log.debug((Object)"check for xss tags");
            String xssRegex = S2S_VALIDATOR_XSS_TAGS;
            log.debug((Object)("S2S xss tags: " + xssRegex));
            String[] tags = StringUtils.split((String)xssRegex, (String)",");
            String xssTagRegex = null;
            xssTagRegex = XSSUtil.createTagRegex(tags);
            log.debug((Object)("S2S xss tag regex: " + xssTagRegex));
            isValid = XSSUtil.isValidValue(value, xssTagRegex);
        }
        catch (Exception e) {
            log.error((Object)("failed validation -- Exception: " + e.getMessage()));
            isValid = false;
        }
        log.debug((Object)("is valid: " + isValid));
        return isValid;
    }

    public static boolean isXssSafe(String value) {
        boolean isValid = true;
        try {
            log.debug((Object)"check for xss tags");
            String xssRegex = SystemConfiguration.getString("VALIDATOR_XSS_TAGS");
            log.debug((Object)("xss tags: " + xssRegex));
            String[] tags = StringUtils.split((String)xssRegex, (String)",");
            String xssTagRegex = null;
            xssTagRegex = XSSUtil.createTagRegex(tags);
            log.debug((Object)("xss tag regex: " + xssTagRegex));
            isValid = XSSUtil.isValidValue(value, xssTagRegex);
            if (isValid) {
                log.debug((Object)"check for JS events");
                xssRegex = SystemConfiguration.getString("VALIDATOR_JS_EVENT_REGEX");
                log.debug((Object)("JS events regex: " + xssRegex));
                isValid = XSSUtil.isValidValue(value, xssRegex);
            }
        }
        catch (Exception e) {
            log.error((Object)("failed validation -- Exception: " + e.getMessage()));
            isValid = false;
        }
        log.debug((Object)("is valid: " + isValid));
        return isValid;
    }

    public static boolean isValidValue(String value, String regex) throws Exception {
        boolean isValid;
        block10: {
            log.debug((Object)("validate value: " + value));
            log.debug((Object)("validation regex: " + regex));
            if (StringUtils.isBlank((CharSequence)value)) {
                return true;
            }
            if (StringUtils.isBlank((CharSequence)regex)) {
                log.error((Object)"regex is blank");
                throw new Exception("Validation regex is required");
            }
            isValid = true;
            try {
                Pattern specialCharsPattern = Pattern.compile(regex);
                Matcher specialCharsMatcher = null;
                specialCharsMatcher = specialCharsPattern.matcher(value.toLowerCase());
                if (!specialCharsMatcher.find()) {
                    log.debug((Object)"test with URL decoder");
                    String decodedStr = XSSUtil.urlDecode(value, true);
                    log.debug((Object)("URL decodedStr to check: " + decodedStr));
                    specialCharsMatcher = specialCharsPattern.matcher(decodedStr);
                    if (!specialCharsMatcher.find()) {
                        int strLength = value.length();
                        log.debug((Object)("str length even: " + (strLength % 2 == 0)));
                        String hexRegex = "^[0-9a-fA-F]+$";
                        Pattern hexPattern = Pattern.compile(hexRegex);
                        Matcher hexMatcher = hexPattern.matcher(value);
                        if (hexMatcher.matches() && strLength % 2 == 0) {
                            log.debug((Object)"test with hex decoder");
                            try {
                                decodedStr = new String(Hex.decodeHex((char[])value.toCharArray()));
                                log.debug((Object)("orig HEX decodedStr: " + decodedStr));
                                decodedStr = decodedStr.toLowerCase();
                                log.debug((Object)("HEX decodedStr to check: " + decodedStr));
                                specialCharsMatcher = specialCharsPattern.matcher(decodedStr);
                                if (specialCharsMatcher.find()) {
                                    log.error((Object)("xss caught: " + specialCharsMatcher.group()));
                                    isValid = false;
                                }
                                break block10;
                            }
                            catch (Exception e) {
                                log.error((Object)("hex decode exception: " + e.getMessage()));
                            }
                            break block10;
                        }
                        log.debug((Object)"not a hex string");
                        break block10;
                    }
                    log.error((Object)("xss caught: " + specialCharsMatcher.group()));
                    isValid = false;
                    break block10;
                }
                log.error((Object)("xss caught: " + specialCharsMatcher.group()));
                isValid = false;
            }
            catch (Exception e) {
                log.error((Object)("return valid=true --- Exception: " + e.getMessage()));
            }
        }
        log.debug((Object)("returning valid=" + isValid));
        return isValid;
    }

    public static String urlDecode(String value, boolean toLowerCase) {
        log.debug((Object)("URL decode: " + value));
        try {
            URLCodec urlCodec = new URLCodec("UTF-8");
            String decodedStr = urlCodec.decode(value);
            log.debug((Object)("orig URL decodedStr: " + decodedStr));
            return decodedStr;
        }
        catch (Exception e) {
            log.error((Object)("url decoding exception: " + e.getMessage()));
            log.info((Object)"returning original value");
            return value;
        }
    }

    public static boolean isValidMatch(String value, String regex) {
        boolean isValid = false;
        Pattern mask = Pattern.compile(regex);
        Matcher matcher = mask.matcher(value);
        if (matcher.matches()) {
            isValid = true;
        }
        return isValid;
    }

    private static String createTagRegex(String[] tags) {
        log.debug((Object)"create tag regex");
        String regex = null;
        try {
            StringBuilder regexSb = new StringBuilder();
            String regexSuffix = "[ '\"\\+(\\000)(\\x00)(%00)]*";
            int tagCount = 0;
            for (String tag : tags) {
                char[] chars = tag.toCharArray();
                if (tagCount > 0) {
                    regexSb.append("|");
                }
                regexSb.append("(");
                for (char c : chars) {
                    if (c == '>') {
                        regexSb.append(c);
                        continue;
                    }
                    regexSb.append(c).append(regexSuffix);
                }
                regexSb.append(")");
                ++tagCount;
            }
            regex = regexSb.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        log.debug((Object)("return regex: " + regex));
        return regex;
    }

    public static boolean isValidJsonpCallback(String value) {
        boolean isValid = false;
        try {
            String regex = null;
            regex = SystemConfiguration.getString("VALID_JSONP_CALLBACK_REGEX");
            isValid = XSSUtil.isValidMatch(value, regex);
        }
        catch (Exception e) {
            log.error((Object)("failed validation -- Exception: " + e.getMessage()));
        }
        log.debug((Object)("is valid: " + isValid));
        return isValid;
    }

    public static String escapeXSS(String s) {
        try {
            return StringEscapeUtils.escapeHtml4((String)s);
        }
        catch (Exception e) {
            log.error((Object)e);
            return s;
        }
    }
}

