/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class XMLValidatorLegacy {
    private static final String CLASSNAME = XMLValidatorLegacy.class.getSimpleName();
    private static final Logger log = Logger.getLogger((String)CLASSNAME);

    private XMLValidatorLegacy() {
    }

    public static boolean validate(byte[] xmlBytes, String schemaUrl) throws Exception {
        if (xmlBytes == null || xmlBytes.length == 0) {
            log.error((Object)"xml bytes is null/empty");
            return false;
        }
        if (StringUtils.isBlank((String)schemaUrl)) {
            log.error((Object)"Schema URL is blank");
            return false;
        }
        ByteArrayInputStream bais = null;
        URL url = null;
        try {
            log.debug((Object)"create ByteArrayInputStream for xml bytes");
            bais = new ByteArrayInputStream(xmlBytes);
            log.debug((Object)("create URL for schema URL: " + schemaUrl));
            url = new URL(schemaUrl);
        }
        catch (Exception e) {
            String s = "Exception creating input stream for xml bytes: " + e.getMessage();
            log.error((Object)s);
            throw new Exception(s);
        }
        return XMLValidatorLegacy.validate(bais, url);
    }

    public static boolean validate(InputStream xmlInputStream, URL schemaUrl) throws Exception {
        log.debug((Object)"Lookup a factory for the W3C XML Schema language");
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        log.debug((Object)"Compile the schema");
        log.debug((Object)("Schema URL: " + schemaUrl));
        Schema schema = null;
        try {
            log.debug((Object)("create schema obj for: " + schemaUrl));
            schema = factory.newSchema(schemaUrl);
        }
        catch (Exception e) {
            String s = "Exception caught creating schema object: " + e.getMessage();
            log.error((Object)s);
            throw new Exception(s);
        }
        log.debug((Object)"Get a validator from the schema");
        Validator validator = schema.newValidator();
        log.debug((Object)"Parse the xml input stream");
        StreamSource source = new StreamSource(xmlInputStream);
        try {
            log.debug((Object)"Validate document");
            validator.validate(source);
            log.debug((Object)"XML is valid");
            return true;
        }
        catch (Exception e) {
            String s = "Schema validation error(s): " + e.getMessage();
            log.error((Object)s);
            throw new Exception(s);
        }
    }
}

