/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.util;

import gov.grants.commons.util.GrantsErrorHandler;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class XMLValidator {
    private static final String CLASSNAME = XMLValidator.class.getSimpleName();
    private static final Logger log = Logger.getLogger((String)CLASSNAME);

    private XMLValidator() {
    }

    public static boolean isValidXml(byte[] xmlBytes, String schemaUrl, GrantsErrorHandler errorHandler) throws Exception {
        if (xmlBytes == null || xmlBytes.length == 0) {
            log.error((Object)"xml bytes is null/empty");
            return false;
        }
        if (StringUtils.isBlank((String)schemaUrl)) {
            log.error((Object)"Schema URL is blank");
            return false;
        }
        ByteArrayInputStream bais = null;
        URL url = null;
        try {
            log.debug((Object)"create ByteArrayInputStream for xml bytes");
            bais = new ByteArrayInputStream(xmlBytes);
            log.debug((Object)("create URL for schema URL: " + schemaUrl));
            url = new URL(schemaUrl);
        }
        catch (Exception e) {
            String s = "Exception creating input stream for xml bytes: " + e.getMessage();
            log.error((Object)s);
            throw new Exception(s);
        }
        return XMLValidator.isValidXml(bais, url, errorHandler);
    }

    public static boolean isValidXml(InputStream xmlInputStream, URL schemaUrl, GrantsErrorHandler errorHandler) throws Exception {
        boolean isValid = false;
        if (errorHandler == null) {
            log.info((Object)"error handler was null, created error handler");
            errorHandler = new GrantsErrorHandler();
        }
        log.debug((Object)"Lookup a factory for the W3C XML Schema language");
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        log.debug((Object)"Compile the schema");
        log.debug((Object)("Schema URL: " + schemaUrl));
        Schema schema = null;
        try {
            log.debug((Object)("create schema obj for: " + schemaUrl));
            schema = factory.newSchema(schemaUrl);
        }
        catch (Exception e) {
            String s = "Exception caught creating schema object: " + e.getMessage();
            log.error((Object)s);
            throw new Exception(s);
        }
        log.debug((Object)"Get a validator from the schema");
        Validator validator = schema.newValidator();
        if (errorHandler != null) {
            log.debug((Object)"set error handler");
            validator.setErrorHandler(errorHandler);
        }
        log.debug((Object)"Parse the xml input stream");
        StreamSource source = new StreamSource(xmlInputStream);
        try {
            log.debug((Object)"Validate document");
            validator.validate(source);
            log.debug((Object)"validation ran successfully");
            isValid = !errorHandler.hasErrors();
            log.debug((Object)("xml is valid: " + isValid));
        }
        catch (Exception e) {
            String s = "Schema validation error(s): " + e.getMessage();
            log.error((Object)s);
            throw new Exception(s);
        }
        return isValid;
    }
}

