/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.apache.xml.security.Init;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLUtil {
    private static final Logger log = Logger.getLogger((String)XMLUtil.class.getName());
    private static String COMPACT_XML_XSL = null;

    private XMLUtil() {
    }

    public static Document createDoc(InputStream xml) throws Exception {
        Document doc = null;
        try {
            if (xml == null || xml.available() < 1) {
                log.error((Object)"XML stream is null");
                return null;
            }
            SAXReader reader = new SAXReader();
            log.debug((Object)"Create XML doc from InputStream");
            doc = reader.read(xml);
        }
        catch (Exception e) {
            log.error((Object)("Exception caught reading XML input stream:" + e.getMessage()));
            throw e;
        }
        return doc;
    }

    public static Document createDoc(String xml) throws Exception {
        Document doc = null;
        try {
            if (StringUtils.isBlank((String)xml)) {
                log.error((Object)"XML is blank.");
                return null;
            }
            log.debug((Object)"Reading XML string");
            doc = DocumentHelper.parseText((String)xml);
        }
        catch (Exception e) {
            log.error((Object)("Exception caught reading XML input stream:" + e.getMessage()));
            throw e;
        }
        return doc;
    }

    public static Document createDoc(byte[] xmlBytes) throws Exception {
        ByteArrayInputStream bis;
        try {
            bis = new ByteArrayInputStream(xmlBytes);
        }
        catch (Exception e) {
            log.error((Object)("Exception caught creating input stream from bytes:" + e.getMessage()));
            throw e;
        }
        return XMLUtil.createDoc(bis);
    }

    public static byte[] canonicalizeXml(byte[] xmlBytes) throws Exception {
        try {
            Canonicalizer canonicalizer = Canonicalizer.getInstance((String)"http://www.w3.org/2001/10/xml-exc-c14n#");
            return canonicalizer.canonicalize(xmlBytes);
        }
        catch (InvalidCanonicalizerException e) {
            throw new Exception("Unable to Canonicalize Submitted forms with the chosen canonicalization method due to InvalidCanonicalizerException: " + e.getMessage(), e);
        }
        catch (CanonicalizationException e) {
            throw new Exception("Unable to Canonicalize Submitted forms due to CanonicalizationException: " + e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            throw new Exception("Unable to Canonicalize Submitted forms due to ParserConfigurationException: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new Exception("Unable to Canonicalize Submitted forms due to IOException: " + e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new Exception("Unable to Canonicalize Submitted forms due to SAXException: " + e.getMessage(), e);
        }
    }

    public static List<Element> getElements(InputStream xml, String xpath) {
        ArrayList<Element> elements = new ArrayList<Element>();
        try {
            if (StringUtils.isBlank((String)xpath)) {
                log.info((Object)"xpath is blank");
                return elements;
            }
            Document xmlDoc = XMLUtil.createDoc(xml);
            return XMLUtil.getElements(xmlDoc, xpath);
        }
        catch (Exception e) {
            log.error((Object)("Exception caught:" + e.getMessage()));
            return elements;
        }
    }

    public static String getFirstValue(InputStream xml, String xpath) {
        String value = null;
        try {
            if (StringUtils.isBlank((String)xpath)) {
                log.info((Object)"xpath is blank");
                return null;
            }
            Document xmlDoc = XMLUtil.createDoc(xml);
            return XMLUtil.getFirstValue(xmlDoc, xpath);
        }
        catch (Exception e) {
            log.error((Object)("Exception caught:" + e.getMessage()));
            return value;
        }
    }

    public static String getFirstValue(Document xmlDoc, String xpath) {
        String value = null;
        try {
            if (StringUtils.isBlank((String)xpath)) {
                log.info((Object)"xpath is blank");
                return null;
            }
            XPath xpathXpr = DocumentHelper.createXPath((String)xpath);
            Element root = xmlDoc.getRootElement();
            String rootName = root.getName();
            log.debug((Object)("root element name=" + rootName));
            Node selected = xpathXpr.selectSingleNode((Object)root);
            if (selected == null) {
                log.error((Object)("Returned null for Xpath=" + xpath));
                return null;
            }
            value = selected.getText();
            log.debug((Object)("Returning Xpath value=" + value));
            return value;
        }
        catch (Exception e) {
            log.error((Object)("Exception caught:" + e.getMessage()));
            return value;
        }
    }

    public static List<Element> getElements(Document xmlDoc, String xpath) {
        List<Object> nodeList = new ArrayList<Element>();
        try {
            if (StringUtils.isBlank((String)xpath)) {
                log.info((Object)"xpath is blank");
                return null;
            }
            log.debug((Object)("Create xpath for expression:" + xpath));
            XPath xpathXpr = DocumentHelper.createXPath((String)xpath);
            Element root = xmlDoc.getRootElement();
            String rootName = root.getName();
            log.debug((Object)("root element name=" + rootName));
            nodeList = xpathXpr.selectNodes((Object)root);
            if (nodeList.size() == 0) {
                log.error((Object)("Returned null for Xpath=" + xpath));
                return nodeList;
            }
            log.debug((Object)("Returning [" + nodeList.size() + "] elements"));
        }
        catch (Exception e) {
            log.error((Object)("Exception caught:" + e.getMessage()));
        }
        return nodeList;
    }

    public static boolean validateXml(InputStream xmlStream) throws SAXParseException, SAXException, Exception {
        boolean status = true;
        String factoryImpl = System.getProperty("javax.xml.parsers.SAXParserFactory");
        log.debug((Object)("factoryImpl: " + factoryImpl));
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(true);
        factory.setFeature("http://xml.org/sax/features/validation", true);
        factory.setFeature("http://apache.org/xml/features/validation/schema", true);
        factory.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
        SAXParser parser = factory.newSAXParser();
        parser.parse(xmlStream, new DefaultHandler(){

            @Override
            public void error(SAXParseException e) throws SAXException {
                boolean status = false;
                throw e;
            }
        });
        return status;
    }

    public static String prettyPrintXmlToStr(String xmlStr, boolean omitProlog) throws Exception {
        return XMLUtil.prettyPrintXmlToStr(xmlStr.getBytes(), omitProlog);
    }

    public static String prettyPrintXmlToStr(byte[] xmlBytes, boolean omitProlog) throws Exception {
        try {
            log.debug((Object)("xml bytes: " + xmlBytes.length));
            Transformer tx = XMLUtil.createTransformer(omitProlog);
            ByteArrayInputStream bais = new ByteArrayInputStream(xmlBytes);
            StreamSource source = new StreamSource(bais);
            StringWriter out = new StringWriter();
            tx.transform(source, new StreamResult(out));
            return ((Object)out).toString();
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
    }

    public static byte[] prettyPrintXmlToBytes(byte[] xmlBytes, boolean omitProlog) throws Exception {
        try {
            log.debug((Object)("xml bytes: " + xmlBytes.length));
            Transformer tx = XMLUtil.createTransformer(omitProlog);
            ByteArrayInputStream bais = new ByteArrayInputStream(xmlBytes);
            StreamSource source = new StreamSource(bais);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            tx.transform(source, new StreamResult(baos));
            return baos.toByteArray();
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
    }

    public static Transformer createTransformer(boolean omitProlog) throws Exception {
        try {
            Transformer tx = TransformerFactory.newInstance().newTransformer();
            tx.setOutputProperty("indent", "yes");
            tx.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            if (omitProlog) {
                tx.setOutputProperty("omit-xml-declaration", "yes");
            }
            return tx;
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
    }

    public static byte[] removePrettyPrint(File xmlFile) throws Exception {
        String msg = null;
        try {
            log.debug((Object)("remove pretty print from xml: " + xmlFile.getAbsolutePath()));
            if (!xmlFile.exists()) {
                msg = xmlFile.getAbsolutePath() + " does not exist";
                log.error((Object)msg);
                throw new Exception(msg);
            }
            String s = FileUtils.readFileToString((File)xmlFile);
            return XMLUtil.removePrettyPrint(s);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
    }

    public static byte[] removePrettyPrint(String xmlStr) throws Exception {
        Object msg = null;
        String updatedXml = null;
        try {
            log.debug((Object)StringEscapeUtils.escapeJava((String)xmlStr));
            String regex = null;
            regex = "[\\s]+(\\<[^/])";
            updatedXml = xmlStr.replaceAll(regex, "$1");
            regex = "(\\</[a-zA-Z0-9-_\\.:]+\\>)[\\s]+";
            updatedXml = updatedXml.replaceAll(regex, "$1");
            regex = "(/\\>)[\\s]+";
            updatedXml = updatedXml.replaceAll(regex, "$1");
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
        return updatedXml.getBytes();
    }

    private static void init() {
        log.info((Object)"XML Security Init -- Initializing Apache XML Security API");
        Init.init();
        log.info((Object)"Finished initializing Apache XML Security API");
    }

    private static String createXslXml() {
        if (StringUtils.isBlank((String)COMPACT_XML_XSL)) {
            COMPACT_XML_XSL = "<?xml version=\"1.0\"?><xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"><xsl:output indent=\"no\" /><xsl:strip-space elements=\"*\"/><xsl:template match=\"@*|node()\"><xsl:copy><xsl:apply-templates select=\"@*|node()\"/></xsl:copy></xsl:template></xsl:stylesheet>";
        }
        return COMPACT_XML_XSL;
    }

    static {
        XMLUtil.init();
    }
}

