/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.util;

import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.apache.xml.security.Init;
import org.apache.xml.security.algorithms.MessageDigestAlgorithm;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.utils.Base64;
import org.apache.xml.security.utils.DigesterOutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLHashUtil {
    private static final Logger log = Logger.getLogger((String)XMLHashUtil.class.getName());

    private XMLHashUtil() {
    }

    public static String createXmlHash(byte[] xmlBytes, String elementNsUri, String elementLocalPart) throws Exception {
        String hash = null;
        Document doc = null;
        try (ByteArrayInputStream bais = null;){
            bais = new ByteArrayInputStream(xmlBytes);
            DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
            dfactory.setNamespaceAware(true);
            doc = dfactory.newDocumentBuilder().parse(bais);
            log.debug((Object)("doc: " + doc));
        }
        NodeList nodes = doc.getElementsByTagNameNS(elementNsUri, elementLocalPart);
        int count = nodes.getLength();
        log.debug((Object)("nodes count: " + count));
        if (count == 0) {
            String s = "Could not locate the element '" + elementLocalPart + "' with the namespace URI: " + elementNsUri;
            log.error((Object)s);
            throw new Exception(s);
        }
        Node nodeToHash = nodes.item(0);
        hash = XMLHashUtil.createXmlHash(doc, nodeToHash);
        return hash;
    }

    public static String createXmlHash(Document doc, Node nodeToHash) throws Exception {
        DigesterOutputStream digesterOS = null;
        byte[] hashBytes = null;
        String hash = null;
        try {
            log.debug((Object)("node to hash local name: " + nodeToHash.getLocalName()));
            log.debug((Object)("node to hash name: " + nodeToHash.getNodeName()));
            try {
                digesterOS = new DigesterOutputStream(MessageDigestAlgorithm.getInstance((Document)doc, (String)"http://www.w3.org/2000/09/xmldsig#sha1"));
                log.debug((Object)"created DigesterOutputStream");
                Canonicalizer canonicalizer = Canonicalizer.getInstance((String)"http://www.w3.org/2001/10/xml-exc-c14n#");
                log.debug((Object)("created Canonicalizer: " + canonicalizer));
                canonicalizer.setWriter((OutputStream)digesterOS);
                log.debug((Object)"canonicalize node to hash");
                canonicalizer.canonicalizeSubtree(nodeToHash);
                log.debug((Object)"create node hash");
                hashBytes = digesterOS.getDigestValue();
                log.debug((Object)("hash length: " + hashBytes.length));
            }
            catch (Exception e) {
                log.debug((Object)("exception type: " + e.getClass().getName()));
                String s = "Exception creating hash bytes: " + e.getMessage();
                log.error((Object)s);
                throw new Exception(s);
            }
            finally {
                try {
                    digesterOS.close();
                }
                catch (Exception e) {
                    log.warn((Object)("Ignoring exception caught closing DigesterOutputStream: " + e.getMessage()));
                }
            }
            hash = Base64.encode((byte[])hashBytes);
        }
        catch (Exception e) {
            String s = "Exception creating xml hash:\n" + e.getMessage();
            log.error((Object)s);
            throw e;
        }
        log.debug((Object)("returning hash: " + hash));
        return hash;
    }

    private static void init() {
        log.info((Object)"XML Security Init -- Initializing Apache XML Security API");
        Init.init();
        log.info((Object)"Finished initializing Apache XML Security API");
    }

    static {
        XMLHashUtil.init();
    }
}

