/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;

public class XMLBeansUtil {
    private static final Logger log = Logger.getLogger((String)XMLBeansUtil.class.getName());

    private XMLBeansUtil() {
    }

    public static XmlOptions getXMLBeansXmlOptions(boolean indent) {
        XmlOptions opts = new XmlOptions();
        opts.setSaveOuter();
        if (indent) {
            opts.setSavePrettyPrint().setSavePrettyPrintIndent(4);
        }
        return opts;
    }

    public static void validateXml(XmlObject xmlObj) throws Exception {
        ArrayList<XmlError> errors = new ArrayList<XmlError>();
        boolean isValid = XMLBeansUtil.validateXml(xmlObj, errors);
        log.debug((Object)("is xml valid: " + isValid));
        if (errors.size() > 0) {
            log.error((Object)("XML validation errors found: " + errors));
            String errorMsg = XMLBeansUtil.formatErrors(errors);
            throw new Exception("XMLValidation errors found: " + errorMsg);
        }
    }

    public static boolean validateXml(XmlObject xmlObj, List<XmlError> errors) throws Exception {
        try {
            XmlOptions opts = new XmlOptions();
            opts.setLoadLineNumbers();
            opts.setErrorListener(errors);
            boolean valid = xmlObj.validate(opts);
            log.debug((Object)("is valid: " + valid));
            log.debug((Object)("errors: " + errors));
            return valid;
        }
        catch (Exception e) {
            log.error((Object)("Exception caught validating XML: " + e.getMessage()));
            throw e;
        }
    }

    public static String formatErrors(List<XmlError> errors) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (errors == null || errors.isEmpty()) {
            log.warn((Object)"errors list is empty, returning empty string");
            return sb.toString();
        }
        int count = 1;
        try {
            for (XmlError error : errors) {
                log.debug((Object)("line: " + error.getLine()));
                log.debug((Object)("error msg: " + error.getMessage()));
                if (count > 1) {
                    sb.append("; \n");
                }
                sb.append("error (").append(count).append(") at ").append("line ").append(error.getLine()).append(": ").append(error.getMessage());
                ++count;
            }
        }
        catch (Exception e) {
            log.error((Object)("Exception caught formatting error message: " + e.getMessage()));
            throw new Exception("Exception caught formatting error message: " + e.getMessage());
        }
        log.debug((Object)("returning formatted error message: " + sb));
        return sb.toString();
    }
}

