/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.util;

import com.ximpleware.AutoPilot;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import com.ximpleware.XMLModifier;
import gov.grants.commons.XMLConstants;
import gov.grants.commons.s2s.util.GrantApplicationHash;
import gov.grants.commons.util.FileUtil;
import gov.grants.commons.vo.Counter;
import gov.grants.commons.vo.EmptyOptElementConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.log4j.Logger;

public class VtdXmlUtil {
    private static final Logger log = Logger.getLogger((String)VtdXmlUtil.class.getName());
    public static final String XMLNS_ATTR = "xmlns";
    public static final String XMLNS_PREFIX = "xmlns:";
    private static final List<String> IGNORED_ELEMENTS = new ArrayList<String>();
    private static boolean REMOVE_EMPTY_OPT_ELEMENTS = false;
    private static final String EMPTY_OPT_ELEMENTS_CONFIG = "/Products_Grants_gov/conf/SystemData/empty-opt-elements-config.xml";
    private static VTDNav OPT_VN = null;
    private static AutoPilot OPT_AP = null;
    private static String EMPTY_ATT_ELEMENTS_CONFIG = "/Products_Grants_gov/conf/SystemData/empty-att-elements.properties";
    private static Properties EMPTY_ATT_ELEMENTS_PROPS = new Properties();

    public static VTDNav createVTDNav(byte[] xmlBytes, boolean namespaceAware) throws Exception {
        VTDNav vn = null;
        try {
            if (xmlBytes == null || xmlBytes.length == 0) {
                throw new Exception("XML bytes are blank");
            }
            log.debug((Object)("xml size: " + xmlBytes.length));
            VTDGen vGen = new VTDGen();
            vGen.setDoc(xmlBytes);
            vGen.parse(namespaceAware);
            vn = vGen.getNav();
            log.debug((Object)"loaded xml successfully");
        }
        catch (Exception e) {
            log.error((Object)("Exception parsing xml bytes: " + e.getMessage()));
            throw e;
        }
        return vn;
    }

    public static VTDNav createVTDNav(byte[] xmlBytes, boolean namespaceAware, AutoPilot ap) throws Exception {
        VTDNav vn = null;
        try {
            vn = VtdXmlUtil.createVTDNav(xmlBytes, namespaceAware);
            VtdXmlUtil.addAllNamespaces(vn, ap);
            ap.bind(vn);
        }
        catch (Exception e) {
            log.error((Object)("Exception parsing xml bytes: " + e.getMessage()));
            throw e;
        }
        return vn;
    }

    public static VTDNav createVTDNavFromHttpUrl(String url, boolean namespaceAware) {
        VTDNav vn = null;
        try {
            VTDGen vg = new VTDGen();
            boolean parsed = vg.parseHttpUrl(url, namespaceAware);
            log.debug((Object)("parsed: " + parsed));
            if (!parsed) {
                log.error((Object)"Could not parse url result");
                return null;
            }
            vn = vg.getNav();
            log.debug((Object)("vn: " + vn));
            log.debug((Object)(vn.toNormalizedString2(vn.getCurrentIndex()) + " @ index: " + vn.getCurrentIndex()));
        }
        catch (Exception e) {
            log.error((Object)("Exception: " + e.getMessage()));
            e.printStackTrace();
        }
        return vn;
    }

    public static void addAllNamespaces(VTDNav vn, AutoPilot ap) {
        try {
            int size = vn.getTokenCount();
            Map<String, String> nsMap = VtdXmlUtil.getXmlNsMap(vn);
            boolean count = false;
            nsMap.putAll(XMLConstants.getCommonXmlNsMap());
            log.debug((Object)("nsMap size: " + nsMap.size()));
            Set<String> nsPrefixes = nsMap.keySet();
            for (String prefix : nsPrefixes) {
                log.debug((Object)("adding namespace: " + prefix + "=" + nsMap.get(prefix)));
                ap.declareXPathNameSpace(prefix, nsMap.get(prefix));
            }
        }
        catch (Exception e) {
            log.error((Object)("Cannot add all namespaces: " + e.getMessage()));
        }
    }

    public static Map<String, String> getXmlNsMap(VTDNav vn) {
        HashMap<String, String> xmlNsMap = new HashMap<String, String>();
        try {
            int size = vn.getTokenCount();
            String nsPrefix = null;
            String nsUrl = null;
            String mapNsUrl = null;
            String token = null;
            for (int i = 0; i < size; ++i) {
                token = vn.toNormalizedString2(i);
                if (!vn.startsWith(i, XMLNS_PREFIX)) continue;
                nsPrefix = token.substring(token.indexOf(":") + 1);
                nsUrl = vn.toNormalizedString2(i + 1);
                mapNsUrl = (String)xmlNsMap.get(nsPrefix);
                if (StringUtils.isBlank((String)mapNsUrl)) {
                    log.debug((Object)("add ns: " + nsPrefix + "=" + nsUrl));
                    xmlNsMap.put(nsPrefix, nsUrl);
                    continue;
                }
                if (mapNsUrl.equals(nsUrl)) continue;
            }
        }
        catch (Exception e) {
            log.error((Object)("Cannot add all namespaces: " + e.getMessage()));
        }
        return xmlNsMap;
    }

    public static Map<String, String> getXmlNsMap(VTDNav vn, int beginIndex, int endIndex) {
        HashMap<String, String> xmlNsMap = new HashMap<String, String>();
        log.debug((Object)("begin index: " + beginIndex));
        log.debug((Object)("end index: " + endIndex));
        try {
            String nsPrefix = null;
            String nsUrl = null;
            String mapNsUrl = null;
            String token = null;
            for (int i = beginIndex; i < endIndex; ++i) {
                token = vn.toNormalizedString2(i);
                if (!vn.startsWith(i, XMLNS_ATTR)) continue;
                nsPrefix = token.substring(token.indexOf(":") + 1);
                nsUrl = vn.toNormalizedString2(i + 1);
                mapNsUrl = (String)xmlNsMap.get(nsPrefix);
                if (StringUtils.isBlank((String)mapNsUrl)) {
                    log.debug((Object)("add ns: " + nsPrefix + "=" + nsUrl));
                    xmlNsMap.put(nsPrefix, nsUrl);
                    continue;
                }
                if (mapNsUrl.equals(nsUrl)) continue;
                log.debug((Object)(nsPrefix + " [" + mapNsUrl + "] --- [" + nsUrl + "]"));
            }
        }
        catch (Exception e) {
            log.error((Object)("Cannot add all namespaces: " + e.getMessage()));
        }
        return xmlNsMap;
    }

    public static Map<String, String> getXmlNsMapForCurrentElement(VTDNav vn, AutoPilot ap) {
        HashMap<String, String> xmlNsMap = new HashMap<String, String>();
        try {
            String attrName = null;
            String nsPrefix = null;
            String nsUrl = null;
            String mapNsUrl = null;
            ap.selectAttr("*");
            int i = -1;
            while ((i = ap.iterateAttr()) != -1) {
                attrName = vn.toNormalizedString(vn.getCurrentIndex());
                log.debug((Object)("attr name: " + attrName));
                if (!attrName.startsWith(XMLNS_ATTR)) continue;
                nsPrefix = attrName.substring(attrName.indexOf(":") + 1);
                nsUrl = vn.toNormalizedString(vn.getCurrentIndex() + 1);
                mapNsUrl = (String)xmlNsMap.get(nsPrefix);
                if (StringUtils.isBlank((String)mapNsUrl)) {
                    log.debug((Object)("add ns: " + nsPrefix + "=" + nsUrl));
                    xmlNsMap.put(nsPrefix, nsUrl);
                    continue;
                }
                if (mapNsUrl.equals(nsUrl)) continue;
                log.debug((Object)(nsPrefix + " [" + mapNsUrl + "] --- [" + nsUrl + "]"));
            }
        }
        catch (Exception e) {
            log.error((Object)("Cannot add all namespaces: " + e.getMessage()));
        }
        return xmlNsMap;
    }

    public static void writeToDisk(VTDNav vn, String filePath) {
        try {
            log.debug((Object)"save results XML to disk");
            FileUtil.bytesToDisk(VtdXmlUtil.getRawXmlStr(vn).getBytes(), filePath);
            log.debug((Object)"saved XML to disk");
        }
        catch (Exception e) {
            log.error((Object)("Exception: " + e.getMessage()));
            e.printStackTrace();
        }
    }

    public static String getRawXmlStr(VTDNav vn) throws Exception {
        String rawXml = null;
        try {
            log.debug((Object)("get raw xml for element: " + vn.toNormalizedString2(vn.getCurrentIndex()) + " @ index: " + vn.getCurrentIndex()));
            long k = vn.getElementFragment();
            log.debug((Object)("k: " + k));
            rawXml = vn.toRawString((int)k, (int)(k >> 32));
        }
        catch (Exception e) {
            String s = "Exception caught: " + e.getMessage();
            log.error((Object)s);
            throw new Exception(s);
        }
        return rawXml;
    }

    public static byte[] getXmlBytes(VTDNav vn) throws Exception {
        byte[] xmlBytes = null;
        try {
            vn.toElement(0);
            xmlBytes = vn.getXML().getBytes();
            log.debug((Object)("xml byte size: " + xmlBytes.length));
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
        return xmlBytes;
    }

    public static byte[] getXmlBytesWithoutProlog(VTDNav vn) throws Exception {
        byte[] xmlBytes = null;
        try {
            vn.toElement(0);
            String xml = VtdXmlUtil.getRawXmlStr(vn);
            xmlBytes = xml.getBytes();
            log.debug((Object)("xml byte size: " + xmlBytes.length));
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
        return xmlBytes;
    }

    public static String createAttHashValue(String attFilePath) throws Exception {
        String attHashValue = null;
        try {
            File f = new File(attFilePath);
            if (!f.exists()) {
                String s = "Attachment was not written to disk: " + attFilePath;
                log.error((Object)s);
                throw new Exception(s);
            }
            log.debug((Object)"Create FileInputStream for attachment");
            FileInputStream fis = new FileInputStream(f);
            GrantApplicationHash gAppHash = new GrantApplicationHash();
            attHashValue = gAppHash.computeAttachmentHash(fis);
            log.debug((Object)("attachment hash: " + attHashValue));
        }
        catch (Exception e) {
            String s = "Exception caught creating attachment hash: " + e.getMessage();
            log.error((Object)s);
            throw e;
        }
        log.debug((Object)("created attachment hash value: " + attHashValue));
        return attHashValue;
    }

    public static String removeEmptyElements(String xml) throws Exception {
        try {
            if (StringUtils.isBlank((String)xml)) {
                log.error((Object)"XML is blank");
                return xml;
            }
            log.debug((Object)("xml str length: " + xml.length()));
            byte[] xmlBytes = xml.getBytes();
            log.debug((Object)("xml bytes: " + xmlBytes.length));
            log.debug((Object)("xml \n" + new String(xmlBytes)));
            xmlBytes = VtdXmlUtil.removeEmptyElements(xmlBytes);
            log.debug((Object)("updated xml bytes: " + xmlBytes.length));
            return new String(xmlBytes, "UTF-8");
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
    }

    public static byte[] removeEmptyElements(byte[] xmlBytes) throws Exception {
        String errorMsg = null;
        byte[] updatedXmlBytes = null;
        Counter removeElementCount = new Counter(0);
        Counter recursiveCount = new Counter(0);
        try {
            VTDNav vn = VtdXmlUtil.createVTDNav(xmlBytes, true);
            XMLModifier xm = new XMLModifier();
            xm.bind(vn);
            AutoPilot ap = new AutoPilot();
            ap.bind(vn);
            VtdXmlUtil.addAllNamespaces(vn, ap);
            log.debug((Object)("orig vn: " + vn));
            vn = VtdXmlUtil.removeEmptyElements(vn, xm, ap, removeElementCount, recursiveCount);
            log.debug((Object)("updated vn: " + vn));
            log.debug((Object)("completed - current element: " + vn.toNormalizedString(vn.getCurrentIndex())));
            vn.toElement(0);
            if (REMOVE_EMPTY_OPT_ELEMENTS) {
                log.info((Object)"check for empty optional elements");
                xm.bind(vn);
                ap.bind(vn);
                boolean updated = VtdXmlUtil.removeEmptyOptElements(vn, xm, ap);
                log.info((Object)("removed empty optional elements: " + updated));
                if (updated) {
                    log.info((Object)"check for empty elements after removing empty optional elements");
                    vn = xm.outputAndReparse();
                    xm.bind(vn);
                    ap.bind(vn);
                    vn = VtdXmlUtil.removeEmptyElements(vn, xm, ap, removeElementCount, recursiveCount);
                }
            }
            updatedXmlBytes = VtdXmlUtil.getXmlBytesWithoutProlog(vn);
            log.debug((Object)("updated xml bytes: " + updatedXmlBytes.length));
            log.debug((Object)("final removed element count: " + removeElementCount.getCurrentValue()));
            log.debug((Object)("final recursive count: " + recursiveCount.getCurrentValue()));
        }
        catch (Exception e) {
            e.printStackTrace();
            errorMsg = "Exception removing empty elements: " + ExceptionUtils.getRootCauseMessage((Throwable)e);
            log.error((Object)errorMsg);
            throw e;
        }
        return updatedXmlBytes;
    }

    private static VTDNav removeEmptyElements(VTDNav vn, XMLModifier xm, AutoPilot ap, Counter removeElementCount, Counter recursiveCount) throws Exception {
        String errorMsg = null;
        boolean updated = false;
        String elementName = null;
        recursiveCount.increase();
        try {
            vn.toElement(0);
            String xpath = "//*";
            ap.selectXPath(xpath);
            int i = -1;
            int count = 0;
            int textIndex = -1;
            boolean isEmpty = false;
            while ((i = ap.evalXPath()) != -1) {
                elementName = vn.toNormalizedString(i);
                if (i == 1) {
                    log.info((Object)"skip root element");
                    continue;
                }
                if (IGNORED_ELEMENTS.contains(elementName)) continue;
                textIndex = vn.getText();
                log.debug((Object)(i + " > " + elementName + " >> " + vn.getText()));
                isEmpty = textIndex > -1 ? vn.toRawString(textIndex).length() == 0 : true;
                if (!vn.toElement(2) && isEmpty) {
                    log.debug((Object)("remove element: " + vn.toNormalizedString(vn.getCurrentIndex())));
                    xm.remove();
                    removeElementCount.increase();
                    updated = true;
                } else {
                    vn.toElement(1);
                }
                ++count;
            }
            log.debug((Object)("total element count: " + count));
            log.debug((Object)("current removed element count: " + removeElementCount));
            log.debug((Object)("current recursive count: " + recursiveCount));
            vn = xm.outputAndReparse();
            if (updated) {
                log.debug((Object)"process again");
                xm.bind(vn);
                ap.bind(vn);
                vn = VtdXmlUtil.removeEmptyElements(vn, xm, ap, removeElementCount, recursiveCount);
            }
            return vn;
        }
        catch (Exception e) {
            errorMsg = elementName + " causing exception removing empty elements: " + ExceptionUtils.getRootCauseMessage((Throwable)e);
            log.error((Object)errorMsg);
            e.printStackTrace();
            throw e;
        }
    }

    private static boolean removeEmptyOptElements(VTDNav vn, XMLModifier xm, AutoPilot ap) throws Exception {
        boolean updated = false;
        boolean found = false;
        try {
            vn.toElement(0);
            String rootElement = vn.toNormalizedString(vn.getCurrentIndex());
            log.debug((Object)("root element: " + rootElement + " @ index: " + vn.getCurrentIndex()));
            Map<String, EmptyOptElementConfig> m = VtdXmlUtil.getEmptyOptElementXpaths(rootElement);
            if (m.isEmpty()) {
                return false;
            }
            log.debug((Object)("map size: " + m.size()));
            log.debug((Object)("map keys: " + m.keySet()));
            EmptyOptElementConfig config = null;
            String xpath = null;
            List<String> childElements = null;
            String key = null;
            int i = -1;
            for (Map.Entry<String, EmptyOptElementConfig> entry : m.entrySet()) {
                key = entry.getKey();
                log.debug((Object)("opt element: " + key));
                config = entry.getValue();
                xpath = config.getXpath();
                childElements = config.getChildElements();
                log.debug((Object)("check xpath: " + xpath));
                ap.selectXPath(xpath);
                while ((i = ap.evalXPath()) != -1) {
                    log.debug((Object)("check element: " + vn.toNormalizedString(vn.getCurrentIndex()) + " @ " + vn.getCurrentIndex()));
                    for (String child : childElements) {
                        log.debug((Object)("check child: " + child));
                        if (!vn.toElement(2, child)) continue;
                        found = true;
                        vn.toElement(1);
                        break;
                    }
                    log.debug((Object)("found: " + found));
                    if (!found) {
                        log.debug((Object)("remove element: " + vn.toNormalizedString(vn.getCurrentIndex()) + " @ " + vn.getCurrentIndex()));
                        xm.remove();
                        updated = true;
                    }
                    log.debug((Object)"reset 'found' flag");
                    found = false;
                }
            }
            log.debug((Object)("updated: " + updated));
            return updated;
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
    }

    private static Map<String, EmptyOptElementConfig> getEmptyOptElementXpaths(String rootElement) {
        HashMap<String, EmptyOptElementConfig> m = new HashMap<String, EmptyOptElementConfig>();
        try {
            String xpath = null;
            String childElementsStr = null;
            ArrayList<String> childElements = null;
            EmptyOptElementConfig config = null;
            String xpathPrefix = "/empty-opt-elements/" + rootElement;
            String keyXpath = xpathPrefix + "/*";
            log.debug((Object)("key xpath: " + keyXpath));
            OPT_AP.selectXPath(keyXpath);
            int i = -1;
            String key = null;
            while ((i = OPT_AP.evalXPath()) != -1) {
                childElements = new ArrayList<String>();
                key = OPT_VN.toNormalizedString(OPT_VN.getCurrentIndex());
                log.debug((Object)("key: " + key));
                OPT_VN.toElement(2, "xpath");
                xpath = OPT_VN.toNormalizedString(OPT_VN.getText());
                log.debug((Object)("parent element xpath: " + xpath));
                OPT_VN.toElement(4, "children");
                childElementsStr = OPT_VN.toNormalizedString(OPT_VN.getText());
                log.debug((Object)("child elements str: " + childElementsStr));
                childElements.addAll(Arrays.asList(childElementsStr.split(", *")));
                log.debug((Object)("child elements: " + childElements));
                log.debug((Object)("child elements count: " + childElements.size()));
                config = new EmptyOptElementConfig(xpath, childElements);
                OPT_VN.toElement(1);
                m.put(key, config);
            }
        }
        catch (Exception e) {
            log.error((Object)("no optional elements for " + rootElement + ": " + e));
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initEmptyOptElementsConfig() {
        log.info((Object)"\n\n\n*** initialize empty optional elements config ***\n\n");
        String filePath = EMPTY_OPT_ELEMENTS_CONFIG;
        FileInputStream input = null;
        try {
            File f = new File(filePath);
            log.info((Object)("config file exists: " + f.exists()));
            if (f.exists()) {
                input = new FileInputStream(f);
                byte[] configBytes = IOUtils.toByteArray((InputStream)input);
                OPT_VN = VtdXmlUtil.createVTDNav(configBytes, true);
                OPT_AP = new AutoPilot(OPT_VN);
                VtdXmlUtil.addAllNamespaces(OPT_VN, OPT_AP);
                log.debug((Object)("root element: " + OPT_VN.toNormalizedString(OPT_VN.getCurrentIndex())));
                String enabledAttr = "enabled";
                if (OPT_VN.hasAttr(enabledAttr)) {
                    log.info((Object)(enabledAttr + " attribute found"));
                    String enabled = OPT_VN.toNormalizedString(OPT_VN.getAttrVal(enabledAttr));
                    log.debug((Object)("remove empty optional elements enabled: " + enabled));
                    REMOVE_EMPTY_OPT_ELEMENTS = "Y".equals(enabled.toUpperCase());
                    log.info((Object)("remove empty opt elements: " + REMOVE_EMPTY_OPT_ELEMENTS));
                } else {
                    log.info((Object)(enabledAttr + " attribute is not available, default to 'false'"));
                }
            } else {
                throw new Exception(filePath + " does not exist");
            }
            log.info((Object)"\n\n\n*** empty optional elements config initialized ***\n\n");
            IOUtils.closeQuietly((InputStream)input);
        }
        catch (Exception e) {
            log.error((Object)e);
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly(input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initEmptyAttElementsProps() {
        log.info((Object)"\n\n\n*** initialize empty att elements properties ***\n\n");
        String filePath = EMPTY_ATT_ELEMENTS_CONFIG;
        FileInputStream input = null;
        try {
            File f = new File(filePath);
            log.info((Object)("props file exists: " + f.exists()));
            if (f.exists()) {
                String[] elements;
                input = new FileInputStream(f);
                EMPTY_ATT_ELEMENTS_PROPS.load(input);
                log.info((Object)("props loaded msg: " + EMPTY_ATT_ELEMENTS_PROPS.getProperty("test")));
                String ignoreAttElements = EMPTY_ATT_ELEMENTS_PROPS.getProperty("ignore-att-elements");
                log.info((Object)("initialize ignore att elements: " + ignoreAttElements));
                for (String s : elements = StringUtils.split((String)ignoreAttElements, (String)",")) {
                    IGNORED_ELEMENTS.add(s.trim());
                }
            } else {
                throw new Exception(filePath + " does not exist");
            }
            log.info((Object)("ignore att elements intialized: " + IGNORED_ELEMENTS));
            EMPTY_ATT_ELEMENTS_PROPS.remove("ignore-att-elements");
            log.info((Object)"\n\n\n*** empty att elements props initialized ***\n\n");
            IOUtils.closeQuietly((InputStream)input);
        }
        catch (Exception e) {
            log.error((Object)e);
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly(input);
        }
    }

    public static String extractNsUri(VTDNav vn) throws Exception {
        try {
            AutoPilot ap = new AutoPilot(vn);
            return VtdXmlUtil.extractNsUri(ap);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
    }

    public static String extractNsUri(AutoPilot ap) throws Exception {
        try {
            ap.selectXPath("namespace-uri(.)");
            String nsUri = ap.evalXPathToString();
            log.debug((Object)("namespace uri: " + nsUri));
            return nsUri;
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
    }

    public static byte[] removeEmptyAttElements(byte[] xmlBytes) throws Exception {
        String errorMsg = null;
        byte[] updatedXmlBytes = null;
        boolean remove = false;
        String elementName = null;
        int additionalAncestorCount = 0;
        try {
            VTDNav vn = VtdXmlUtil.createVTDNav(xmlBytes, true);
            AutoPilot ap = new AutoPilot();
            ap.bind(vn);
            XMLModifier xm = new XMLModifier();
            xm.bind(vn);
            VtdXmlUtil.addAllNamespaces(vn, ap);
            String rootElement = vn.toNormalizedString(vn.getCurrentIndex());
            log.debug((Object)("root element: " + rootElement + " @ index: " + vn.getCurrentIndex()));
            String xpath = "//att:FileName";
            int i = -1;
            log.debug((Object)("check xpath: " + xpath));
            ap.selectXPath(xpath);
            int textIndex = -1;
            String value = null;
            int count = 0;
            while ((i = ap.evalXPath()) != -1) {
                remove = false;
                value = null;
                log.debug((Object)("check element: " + vn.toNormalizedString(vn.getCurrentIndex()) + " @ " + vn.getCurrentIndex()));
                textIndex = vn.getText();
                log.debug((Object)("text index: " + textIndex));
                if (textIndex == -1) {
                    log.debug((Object)"empty element");
                    remove = true;
                } else {
                    value = vn.toNormalizedString2(vn.getText());
                    log.debug((Object)("text value: " + value));
                    if (StringUtils.isBlank((String)value)) {
                        remove = true;
                    }
                }
                log.debug((Object)("remove: " + remove));
                if (!remove) continue;
                vn.toElement(1);
                elementName = vn.toNormalizedString(vn.getCurrentIndex());
                log.debug((Object)("att parent element: " + elementName + " @ " + vn.getCurrentIndex()));
                log.debug((Object)("remove children for: " + elementName + " @ " + vn.getCurrentIndex()));
                additionalAncestorCount = 0;
                if (EMPTY_ATT_ELEMENTS_PROPS.containsKey(elementName)) {
                    log.debug((Object)("additional ancestor count: " + additionalAncestorCount));
                    for (additionalAncestorCount = NumberUtils.toInt((String)EMPTY_ATT_ELEMENTS_PROPS.getProperty(elementName)); additionalAncestorCount > 0; --additionalAncestorCount) {
                        vn.toElement(1);
                    }
                }
                xm.remove();
                ++count;
            }
            log.info((Object)("number of att elements removed: " + count));
            if (count > 0) {
                vn = xm.outputAndReparse();
                updatedXmlBytes = VtdXmlUtil.getXmlBytesWithoutProlog(vn);
                log.debug((Object)("updated xml bytes: " + updatedXmlBytes.length));
                return updatedXmlBytes;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            errorMsg = "Exception removing empty elements: " + ExceptionUtils.getRootCauseMessage((Throwable)e);
            log.error((Object)errorMsg);
            throw e;
        }
        log.info((Object)"returning original xml bytes");
        return xmlBytes;
    }

    public static byte[] removeAllTextValues(byte[] xmlBytes) throws Exception {
        String xpath = null;
        xpath = "//*[text()='match-str']";
        xpath = "//*[text()]";
        try {
            VTDNav vn = VtdXmlUtil.createVTDNav(xmlBytes, true);
            AutoPilot ap = new AutoPilot();
            ap.bind(vn);
            XMLModifier xm = new XMLModifier();
            xm.bind(vn);
            String rootElement = vn.toNormalizedString(vn.getCurrentIndex());
            log.debug((Object)("root element: " + rootElement + " @ index: " + vn.getCurrentIndex()));
            ap.selectXPath(xpath);
            int index = -1;
            while ((index = ap.evalXPath()) != -1) {
                xm.updateToken(vn.getText(), "");
            }
            vn = xm.outputAndReparse();
            byte[] updatedXmlBytes = VtdXmlUtil.getXmlBytesWithoutProlog(vn);
            log.debug((Object)("updated xml bytes: " + updatedXmlBytes.length));
            return updatedXmlBytes;
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
    }

    public static byte[] removeAllComments(byte[] xmlBytes) throws Exception {
        String xpath = null;
        xpath = "//comment()";
        try {
            VTDNav vn = VtdXmlUtil.createVTDNav(xmlBytes, true);
            AutoPilot ap = new AutoPilot();
            ap.bind(vn);
            XMLModifier xm = new XMLModifier();
            xm.bind(vn);
            ap.selectXPath(xpath);
            int index = -1;
            while ((index = ap.evalXPath()) != -1) {
                xm.remove();
            }
            vn = xm.outputAndReparse();
            byte[] updatedXmlBytes = VtdXmlUtil.getXmlBytesWithoutProlog(vn);
            log.debug((Object)("updated xml bytes: " + updatedXmlBytes.length));
            return updatedXmlBytes;
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
    }

    static {
        VtdXmlUtil.initEmptyAttElementsProps();
        VtdXmlUtil.initEmptyOptElementsConfig();
    }
}

