/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.util;

import gov.grants.commons.util.XSSUtil;
import gov.grants.commons.validation.XssCheckException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class URLUtil {
    private static final Logger LOG = Logger.getLogger((String)URLUtil.class.getName());

    public static String xssCheck(String url, String value) throws XssCheckException {
        if (StringUtils.isNotBlank((CharSequence)value) && !XSSUtil.isXssSafe(value)) {
            LOG.error((Object)("XssCheckException: possible XSS in URL: " + url));
            LOG.error((Object)("XssCheckException: possible XSS in URL value: " + value));
            throw new XssCheckException(url, value);
        }
        return value;
    }

    public static String urlDecode(String urlEncoded) {
        String value = null;
        try {
            value = new String(URLCodec.decodeUrl((byte[])urlEncoded.getBytes("UTF-8")));
            LOG.debug((Object)("decoded url: " + value));
            return value;
        }
        catch (Exception e) {
            LOG.error((Object)("url decoding exception: " + e.getMessage()));
            return urlEncoded;
        }
    }

    public static String hexDecode(String hexEncoded) {
        String value = null;
        try {
            value = new String(Hex.decodeHex((char[])hexEncoded.toCharArray()));
            LOG.debug((Object)("decoded url: " + value));
            return value;
        }
        catch (Exception e) {
            LOG.error((Object)("url decoding exception: " + e.getMessage()));
            return hexEncoded;
        }
    }

    public static String getFileName(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return "";
        }
        String[] details = StringUtils.split((String)url, (String)"/");
        return details[details.length - 1];
    }

    public static String getMPFileName(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return "";
        }
        String[] details = StringUtils.split((String)url, (String)"/");
        return details[details.length - 2];
    }

    public static boolean isPkgIdURL(String url) {
        String fileName = URLUtil.getFileName(url);
        if (fileName != null && fileName.startsWith("PKG")) {
            return true;
        }
        String mpFileName = URLUtil.getMPFileName(url);
        return mpFileName != null && mpFileName.startsWith("PKG");
    }
}

