/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.util;

public final class Timer {
    private long started = 0L;
    private long stopped = 0L;
    private long elapsedMillis = 0L;

    public Timer() {
    }

    public Timer(long elapsedMillis) {
        this.elapsedMillis = elapsedMillis;
    }

    public void start() {
        this.started = System.currentTimeMillis();
    }

    public void stop() {
        this.stopped = System.currentTimeMillis();
        this.elapsedMillis = this.stopped - this.started;
    }

    public String toString() {
        double seconds = (double)this.getSeconds() + (double)this.getMilliseconds() / 1000.0;
        return this.getHours() + ":" + this.getMinutes() + ":" + seconds;
    }

    public long toMilliseconds() {
        return this.elapsedMillis;
    }

    public Long toMillisecondsLong() {
        return new Long(this.elapsedMillis);
    }

    public long asSeconds() {
        return this.elapsedMillis / 1000L;
    }

    public long getHours() {
        return this.asSeconds() / 3600L;
    }

    public int getMinutes() {
        return (int)(this.asSeconds() / 60L % 60L);
    }

    public int getSeconds() {
        return (int)(this.asSeconds() % 60L);
    }

    public int getMilliseconds() {
        return (int)(this.elapsedMillis % 1000L);
    }

    public static void main(String[] args) {
        Timer t = new Timer();
        System.out.println("call start/stop: sleep 10000");
        t.start();
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            System.err.println(e);
        }
        t.stop();
        System.out.println("started/stopped: " + t.started + "/" + t.stopped);
        System.out.println("toString: " + t.toString());
        System.out.println("min: " + t.getMinutes());
        System.out.println("sec: " + t.getSeconds());
        System.out.println("ms: " + t.toMilliseconds());
        System.out.println("call start/stop: yield");
        t.start();
        Thread.yield();
        t.stop();
        System.out.println("started/stopped: " + t.started + "/" + t.stopped);
        System.out.println("toString: " + t.toString());
    }
}

