/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.util;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class TextResources {
    private static final Logger log = Logger.getLogger((String)TextResources.class.getName());
    private ResourceBundle resource = null;

    public TextResources(ResourceBundle resource) {
        this.resource = resource;
    }

    public ResourceBundle asResourceBundle() {
        return this.resource;
    }

    public boolean containsKey(String key) {
        boolean hasKey = true;
        try {
            String string = this.resource.getString(key);
        }
        catch (MissingResourceException mre) {
            log.info((Object)"KEY DOES NOT EXIST");
            return false;
        }
        catch (Exception e) {
            log.error((Object)("ERROR: EXCEPTION THROWN:\n" + e));
            return false;
        }
        return hasKey;
    }

    public String getText(String key, boolean hideErrorMsg) {
        String errorMsg = "[???." + key + ".???]";
        try {
            String msg = this.resource.getString(key);
            log.debug((Object)msg);
            if (StringUtils.isNotBlank((String)msg)) {
                return msg;
            }
        }
        catch (NullPointerException e) {
            log.error((Object)("ERROR: NullPointerException:\n" + e));
            e.printStackTrace();
            if (hideErrorMsg) {
                return "";
            }
            return errorMsg;
        }
        catch (MissingResourceException e) {
            log.error((Object)("ERROR: MissingResourceException:\n" + e));
            e.printStackTrace();
            if (hideErrorMsg) {
                return "";
            }
            return errorMsg;
        }
        catch (ClassCastException e) {
            log.error((Object)("ERROR: ClassCastException:\n" + e));
            e.printStackTrace();
            if (hideErrorMsg) {
                return "";
            }
            return errorMsg;
        }
        return errorMsg;
    }

    public String getText(String key) {
        return this.getText(key, false);
    }

    public String getText(String key, Object[] args, boolean hideErrorMsg) {
        String errorMsg = "[???-" + key + "-???]";
        try {
            String msg = this.resource.getString(key);
            log.debug((Object)msg);
            MessageFormat msgFormat = null;
            if (StringUtils.isNotBlank((String)msg)) {
                msgFormat = new MessageFormat(StringEscapeUtils.escapeJava((String)msg));
                return msgFormat.format(args);
            }
        }
        catch (NullPointerException npe) {
            log.error((Object)("ERROR: NullPointerException THROWN:\n" + npe));
            if (hideErrorMsg) {
                return "";
            }
            return errorMsg;
        }
        catch (MissingResourceException mre) {
            log.error((Object)("ERROR: MissingResourceException THROWN:\n" + mre));
            if (hideErrorMsg) {
                return "";
            }
            return errorMsg;
        }
        catch (ClassCastException cce) {
            log.error((Object)("ERROR: ClassCastException THROWN:\n" + cce));
            if (hideErrorMsg) {
                return "";
            }
            return errorMsg;
        }
        return errorMsg;
    }

    public String getText(String key, Object[] args) {
        return this.getText(key, args, false);
    }

    public String getText(String key, String arg0, boolean hideErrorMsg) {
        return this.getText(key, new Object[]{arg0}, hideErrorMsg);
    }

    public String getText(String key, String arg0) {
        return this.getText(key, new Object[]{arg0});
    }

    public String getText(String key, String arg0, String arg1, boolean hideErrorMsg) {
        return this.getText(key, new Object[]{arg0, arg1}, hideErrorMsg);
    }

    public String getText(String key, String arg0, String arg1) {
        return this.getText(key, new Object[]{arg0, arg1});
    }

    public String getText(String key, String arg0, String arg1, String arg2, boolean hideErrorMsg) {
        return this.getText(key, new Object[]{arg0, arg1, arg2}, hideErrorMsg);
    }

    public String getText(String key, String arg0, String arg1, String arg2) {
        return this.getText(key, new Object[]{arg0, arg1, arg2});
    }

    public String getText(String key, String arg0, String arg1, String arg2, String arg3, boolean hideErrorMsg) {
        return this.getText(key, new Object[]{arg0, arg1, arg2, arg3}, hideErrorMsg);
    }

    public String getText(String key, String arg0, String arg1, String arg2, String arg3) {
        return this.getText(key, new Object[]{arg0, arg1, arg2, arg3});
    }
}

